/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.Vector;

class Bubble
extends StretchyBox {
    boolean pointLeft = false;
    BufferedImage leftPointer;
    BufferedImage rightPointer;
    int fontSize = 13;
    Font font = new Font("Arial Unicode MS", 1, this.fontSize);
    FontRenderContext renderContext = Skin.bubbleFrame.createGraphics().getFontRenderContext();
    int wrapWidth = 135;
    String contents;
    String[] lines;
    int[] xOffsets;

    Bubble() {
        this.setFrameImage(Skin.bubbleFrame);
        this.beThinkBubble(false);
    }

    void beThinkBubble(boolean bl) {
        if (bl) {
            this.leftPointer = Skin.thinkPointerL;
            this.rightPointer = Skin.thinkPointerR;
        } else {
            this.leftPointer = Skin.talkPointerL;
            this.rightPointer = Skin.talkPointerR;
        }
    }

    void beAskBubble() {
        this.renderContext = Skin.askBubbleFrame.createGraphics().getFontRenderContext();
        this.setFrameImage(Skin.askBubbleFrame);
        this.leftPointer = Skin.askPointerL;
        this.rightPointer = Skin.askPointerR;
    }

    void setContents(String string) {
        int n;
        this.contents = string;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < string.length()) {
            n = this.findLineEnd(string, n2);
            vector.addElement(string.substring(n2, n));
            n2 = n;
        }
        this.lines = new String[vector.size()];
        this.w = 65;
        for (n = 0; n < this.lines.length; ++n) {
            this.lines[n] = (String)vector.get(n);
            this.w = Math.max(this.w, this.widthOf(this.lines[n]) + 15);
        }
        this.xOffsets = new int[this.lines.length];
        for (n = 0; n < this.lines.length; ++n) {
            this.xOffsets[n] = (this.w - this.widthOf(this.lines[n])) / 2;
        }
        this.h = this.lines.length * (this.fontSize + 2) + 19;
    }

    int findLineEnd(String string, int n) {
        int n2;
        for (n2 = n + 1; n2 < string.length() && this.widthOf(string.substring(n, n2 + 1)) < this.wrapWidth; ++n2) {
        }
        if (n2 == string.length()) {
            return n2;
        }
        if (this.widthOf(string.substring(n, n2 + 1)) < this.wrapWidth) {
            return n2 + 1;
        }
        int n3 = n2 + 1;
        while (n2 > n + 1) {
            if (n2 < string.length() && string.charAt(n2) == ' ') {
                return n2 + 1;
            }
            --n2;
        }
        return n3;
    }

    int widthOf(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return (int)new TextLayout(string, this.font, this.renderContext).getAdvance();
    }

    public Rectangle rect() {
        return new Rectangle(this.x, this.y, this.w, this.h + this.leftPointer.getHeight(null));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.pointLeft) {
            graphics.drawImage(this.leftPointer, this.x + 7, this.y + this.h - 3, null);
        } else {
            graphics.drawImage(this.rightPointer, this.x - 9 + this.w - this.rightPointer.getWidth(null), this.y + this.h - 3, null);
        }
        graphics.setColor(new Color(0, 0, 0));
        graphics.setFont(this.font);
        int n = this.y + this.fontSize + 8;
        for (int i = 0; i < this.lines.length; ++i) {
            graphics.drawString(this.lines[i], this.x + this.xOffsets[i], n);
            n += this.fontSize + 2;
        }
    }
}

