/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;

public class Logo {
    static long starttime = System.currentTimeMillis();

    static String runToplevel(Object[] objectArray, LContext lContext) {
        lContext.iline = new MapList(objectArray);
        lContext.timeToStop = false;
        try {
            Logo.evLine(lContext);
        }
        catch (LogoError logoError) {
            if (logoError.getMessage() != null) {
                return logoError.getMessage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
        catch (Error error) {
            return error.toString();
        }
        return null;
    }

    static void evLine(LContext lContext) {
        while (!lContext.iline.eof() && lContext.ufunresult == null) {
            Object object = Logo.eval(lContext);
            if (object == null) continue;
            Logo.error("You don't say what to do with " + Logo.prs(object), lContext);
        }
    }

    static Object eval(LContext lContext) {
        Object object = Logo.evalToken(lContext);
        while (Logo.infixNext(lContext.iline, lContext)) {
            if (object instanceof Nothing) {
                Logo.error(lContext.iline.peek() + " needs more inputs", lContext);
            }
            object = Logo.evalInfix(object, lContext);
        }
        return object;
    }

    static Object evalToken(LContext lContext) {
        Object object = lContext.iline.next();
        if (object instanceof QuotedSymbol) {
            return ((QuotedSymbol)object).sym;
        }
        if (object instanceof DottedSymbol) {
            return Logo.getValue(((DottedSymbol)object).sym, lContext);
        }
        if (object instanceof Symbol) {
            return Logo.evalSym((Symbol)object, null, lContext);
        }
        if (object instanceof String) {
            return Logo.evalSym(Logo.intern((String)object, lContext), null, lContext);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object evalSym(Symbol symbol, Object[] objectArray, LContext lContext) {
        if (lContext.timeToStop) {
            Logo.error("Stopped!!!", lContext);
        }
        if (symbol.fcn == null) {
            Logo.error("I don't know how to " + symbol, lContext);
        }
        Symbol symbol2 = lContext.cfun;
        lContext.cfun = symbol;
        int n = lContext.priority;
        lContext.priority = 0;
        Object object = null;
        try {
            Function function = symbol.fcn;
            int n2 = function.nargs;
            if (objectArray == null) {
                objectArray = Logo.evalArgs(n2, lContext);
            }
            object = function.instance.dispatch(function.dispatchOffset, objectArray, lContext);
        }
        catch (RuntimeException runtimeException) {
            Logo.errorHandler(symbol, objectArray, runtimeException, lContext);
        }
        finally {
            lContext.cfun = symbol2;
            lContext.priority = n;
        }
        if (lContext.mustOutput && object == null) {
            Logo.error(symbol + " didn't output to " + lContext.cfun, lContext);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] evalArgs(int n, LContext lContext) {
        boolean bl = lContext.mustOutput;
        lContext.mustOutput = true;
        Object[] objectArray = new Object[n];
        try {
            for (int i = 0; i < n; ++i) {
                if (lContext.iline.eof()) {
                    Logo.error(lContext.cfun + " needs more inputs", lContext);
                }
                objectArray[i] = Logo.eval(lContext);
                if (!(objectArray[i] instanceof Nothing)) continue;
                Logo.error(lContext.cfun + " needs more inputs", lContext);
            }
        }
        finally {
            lContext.mustOutput = bl;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runCommand(Object[] objectArray, LContext lContext) {
        boolean bl = lContext.mustOutput;
        lContext.mustOutput = false;
        try {
            Logo.runList(objectArray, lContext);
        }
        finally {
            lContext.mustOutput = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object runList(Object[] objectArray, LContext lContext) {
        MapList mapList = lContext.iline;
        lContext.iline = new MapList(objectArray);
        Object object = null;
        try {
            if (lContext.mustOutput) {
                object = Logo.eval(lContext);
            } else {
                Logo.evLine(lContext);
            }
            Logo.checkListEmpty(lContext.iline, lContext);
        }
        finally {
            lContext.iline = mapList;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object evalOneArg(MapList mapList, LContext lContext) {
        boolean bl = lContext.mustOutput;
        lContext.mustOutput = true;
        MapList mapList2 = lContext.iline;
        lContext.iline = mapList;
        try {
            Object object = Logo.eval(lContext);
            return object;
        }
        finally {
            lContext.iline = mapList2;
            lContext.mustOutput = bl;
        }
    }

    static boolean infixNext(MapList mapList, LContext lContext) {
        Object object = null;
        Function function = null;
        return !mapList.eof() && (object = mapList.peek()) instanceof Symbol && (function = ((Symbol)object).fcn) != null && function.nargs < lContext.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object evalInfix(Object object, LContext lContext) {
        Symbol symbol = (Symbol)lContext.iline.next();
        Function function = symbol.fcn;
        Symbol symbol2 = lContext.cfun;
        lContext.cfun = symbol;
        int n = lContext.priority;
        lContext.priority = function.nargs;
        Object object2 = null;
        Object[] objectArray = new Object[2];
        objectArray[0] = object;
        try {
            Object[] objectArray2 = Logo.evalArgs(1, lContext);
            objectArray[1] = objectArray2[0];
            object2 = function.instance.dispatch(function.dispatchOffset, objectArray, lContext);
        }
        catch (RuntimeException runtimeException) {
            Logo.errorHandler(symbol, objectArray, runtimeException, lContext);
        }
        finally {
            lContext.cfun = symbol2;
            lContext.priority = n;
        }
        if (lContext.mustOutput && object2 == null) {
            Logo.error(symbol + " didn't output to " + lContext.cfun, lContext);
        }
        return object2;
    }

    static Symbol intern(String string, LContext lContext) {
        String string2 = string.length() == 0 ? string : (string.charAt(0) == '|' ? (string = string.substring(1)) : string);
        Symbol symbol = (Symbol)lContext.oblist.get(string2);
        if (symbol == null) {
            symbol = new Symbol(string);
            lContext.oblist.put(string2, symbol);
        }
        return symbol;
    }

    static Object[] parse(String string, LContext lContext) {
        TokenStream tokenStream = new TokenStream(string);
        return tokenStream.readList(lContext);
    }

    static String prs(Object object) {
        return Logo.prs(object, 10);
    }

    static String prs(Object object, int n) {
        return Logo.prs(object, n, new HashSet());
    }

    static String prs(Object object, int n, HashSet hashSet) {
        if (object instanceof Number && n == 16) {
            return Long.toString(((Number)object).longValue(), 16).toUpperCase();
        }
        if (object instanceof Number && n == 8) {
            return Long.toString(((Number)object).longValue(), 8);
        }
        if (object instanceof Number && Logo.isInt((Number)object)) {
            return Long.toString(((Number)object).longValue(), 10);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length > 0 && hashSet.contains(object)) {
                return "...";
            }
            if (objectArray.length > 0) {
                hashSet.add(object);
            }
            String string = "";
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Object[]) {
                    string = string + "[";
                }
                string = string + Logo.prs(objectArray[i], n, hashSet);
                if (objectArray[i] instanceof Object[]) {
                    string = string + "]";
                }
                if (i == objectArray.length - 1) continue;
                string = string + " ";
            }
            return string;
        }
        return object.toString();
    }

    static boolean isInt(Number number) {
        return number.doubleValue() == new Integer(number.intValue()).doubleValue();
    }

    static boolean aValidNumber(String string) {
        if (string.length() == 1 && "0123456789".indexOf(string.charAt(0)) == -1) {
            return false;
        }
        if ("eE.+-0123456789".indexOf(string.charAt(0)) == -1) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if ("eE.0123456789".indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    static Object getValue(Symbol symbol, LContext lContext) {
        Object object = symbol.value;
        if (object != null) {
            return object;
        }
        Logo.error(symbol + " has no value", lContext);
        return null;
    }

    static void setValue(Symbol symbol, Object object, LContext lContext) {
        symbol.value = object;
    }

    static double aDouble(Object object, LContext lContext) {
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = Logo.prs(object);
        if (string.length() > 0 && Logo.aValidNumber(string)) {
            return Double.valueOf(string);
        }
        Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        return 0.0;
    }

    static int anInt(Object object, LContext lContext) {
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        String string = Logo.prs(object);
        if (Logo.aValidNumber(string)) {
            return Double.valueOf(string).intValue();
        }
        Logo.error(lContext.cfun + " doesn't like " + string + " as input", lContext);
        return 0;
    }

    static long aLong(Object object, LContext lContext) {
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        String string = Logo.prs(object);
        if (Logo.aValidNumber(string)) {
            return Double.valueOf(string).longValue();
        }
        Logo.error(lContext.cfun + " doesn't like " + string + " as input", lContext);
        return 0L;
    }

    static boolean aBoolean(Object object, LContext lContext) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Symbol) {
            return ((Symbol)object).pname.equals("true");
        }
        Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        return false;
    }

    static Object[] aList2Double(Object object, LContext lContext) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 2 && ((Object[])object)[0] instanceof Double && ((Object[])object)[1] instanceof Double) {
                return (Object[])object;
            }
            Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        }
        return null;
    }

    static Object[] aList(Object object, LContext lContext) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        return null;
    }

    static Symbol aSymbol(Object object, LContext lContext) {
        if (object instanceof Symbol) {
            return (Symbol)object;
        }
        if (object instanceof String) {
            return Logo.intern((String)object, lContext);
        }
        if (object instanceof Number) {
            String string = String.valueOf(((Number)object).longValue());
            return Logo.intern(string, lContext);
        }
        Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        return null;
    }

    static String aString(Object object, LContext lContext) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Symbol) {
            return ((Symbol)object).toString();
        }
        Logo.error(lContext.cfun + " doesn't like " + Logo.prs(object) + " as input", lContext);
        return null;
    }

    static void setupPrims(String[] stringArray, LContext lContext) {
        for (int i = 0; i < stringArray.length; ++i) {
            Logo.setupPrims(stringArray[i], lContext);
        }
    }

    static void setupPrims(String string, LContext lContext) {
        try {
            Class<?> clazz = Class.forName(string);
            Primitives primitives = (Primitives)clazz.newInstance();
            String[] stringArray = primitives.primlist();
            for (int i = 0; i < stringArray.length; i += 2) {
                String string2 = stringArray[i + 1];
                boolean bl = string2.startsWith("i");
                if (bl) {
                    string2 = string2.substring(1);
                }
                Symbol symbol = Logo.intern(stringArray[i], lContext);
                symbol.fcn = new Function(primitives, Integer.parseInt(string2), i / 2, bl);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    static void checkListEmpty(MapList mapList, LContext lContext) {
        if (!mapList.eof() && lContext.ufunresult == null) {
            Logo.error("You don't say what to do with " + Logo.prs(mapList.next()), lContext);
        }
    }

    static void errorHandler(Symbol symbol, Object[] objectArray, RuntimeException runtimeException, LContext lContext) {
        if (!(runtimeException instanceof ArrayIndexOutOfBoundsException || runtimeException instanceof StringIndexOutOfBoundsException || runtimeException instanceof NegativeArraySizeException)) {
            throw runtimeException;
        }
        Logo.error(symbol + " doesn't like " + Logo.prs(objectArray[0]) + " as input", lContext);
    }

    static void error(String string, LContext lContext) {
        if (string.equals("")) {
            throw new LogoError(null);
        }
        string = string + (lContext.ufun == null ? "" : " in " + lContext.ufun);
        throw new LogoError(string);
    }

    static void readAllFunctions(String string, LContext lContext) {
        TokenStream tokenStream = new TokenStream(string);
        while (true) {
            switch (Logo.findKeyWord(tokenStream)) {
                case 0: {
                    return;
                }
                case 1: {
                    Logo.doDefine(tokenStream, lContext);
                    break;
                }
                case 2: {
                    Logo.doTo(tokenStream, lContext);
                }
            }
        }
    }

    static int findKeyWord(TokenStream tokenStream) {
        while (!tokenStream.eof()) {
            if (tokenStream.startsWith("define ")) {
                return 1;
            }
            if (tokenStream.startsWith("to ")) {
                return 2;
            }
            tokenStream.skipToNextLine();
        }
        return 0;
    }

    static void doDefine(TokenStream tokenStream, LContext lContext) {
        tokenStream.readToken(lContext);
        Symbol symbol = Logo.aSymbol(tokenStream.readToken(lContext), lContext);
        Object[] objectArray = Logo.aList(tokenStream.readToken(lContext), lContext);
        Object[] objectArray2 = Logo.aList(tokenStream.readToken(lContext), lContext);
        Ufun ufun = new Ufun(objectArray, objectArray2);
        symbol.fcn = new Function(ufun, objectArray.length, 0);
    }

    static void doTo(TokenStream tokenStream, LContext lContext) {
        Object[] objectArray = Logo.parse(tokenStream.nextLine(), lContext);
        Object[] objectArray2 = Logo.parse(Logo.readBody(tokenStream, lContext), lContext);
        Object[] objectArray3 = Logo.getArglistFromTitle(objectArray);
        Symbol symbol = Logo.aSymbol(objectArray[1], lContext);
        Ufun ufun = new Ufun(objectArray3, objectArray2);
        symbol.fcn = new Function(ufun, objectArray3.length, 0);
    }

    static String readBody(TokenStream tokenStream, LContext lContext) {
        String string = "";
        while (!tokenStream.eof()) {
            String string2 = tokenStream.nextLine();
            if (string2.startsWith("end") && "end".equals(((Symbol)Logo.parse((String)string2, (LContext)lContext)[0]).pname)) {
                return string;
            }
            string = string + " " + string2;
        }
        return string;
    }

    static Object[] getArglistFromTitle(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length - 2];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = ((DottedSymbol)objectArray[i + 2]).sym;
        }
        return objectArray2;
    }
}

