/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

class StretchyBox
implements Drawable {
    int x;
    int y;
    int w = 100;
    int h = 75;
    BufferedImage cornerTL;
    BufferedImage cornerTR;
    BufferedImage cornerBL;
    BufferedImage cornerBR;
    BufferedImage edgeTop;
    BufferedImage edgeBottom;
    BufferedImage edgeLeft;
    BufferedImage edgeRight;
    Color fillColor;

    StretchyBox() {
    }

    void setFrameImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        int n3 = n / 2;
        int n4 = n2 / 2;
        this.cornerTL = bufferedImage.getSubimage(0, 0, n3, n4);
        this.cornerTR = bufferedImage.getSubimage(n - n3, 0, n3, n4);
        this.cornerBL = bufferedImage.getSubimage(0, n2 - n4, n3, n4);
        this.cornerBR = bufferedImage.getSubimage(n - n3, n2 - n4, n3, n4);
        this.edgeTop = bufferedImage.getSubimage(n3, 0, 1, n4);
        this.edgeBottom = bufferedImage.getSubimage(n3, n2 - n4, 1, n4);
        this.edgeLeft = bufferedImage.getSubimage(0, n4, n3, 1);
        this.edgeRight = bufferedImage.getSubimage(n - n3, n4, n3, 1);
        this.fillColor = new Color(bufferedImage.getRGB(n3, n4));
    }

    public boolean isShowing() {
        return true;
    }

    public Rectangle rect() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public Rectangle fullRect() {
        return this.rect();
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.cornerTL == null) {
            graphics.setColor(new Color(100, 100, 250));
            graphics.fillRect(this.x, this.y, this.w, this.h);
            return;
        }
        int n2 = this.cornerTL.getWidth(null);
        int n3 = this.cornerTL.getHeight(null);
        graphics.setColor(this.fillColor);
        graphics.fillRect(this.x + n2, this.y + n3, this.w - 2 * n2, this.h - 2 * n3);
        for (n = this.x + n2; n < this.x + this.w - n2; ++n) {
            graphics.drawImage(this.edgeTop, n, this.y, null);
            graphics.drawImage(this.edgeBottom, n, this.y + this.h - n3, null);
        }
        for (n = this.y + n3; n < this.y + this.h - n3; ++n) {
            graphics.drawImage(this.edgeLeft, this.x, n, null);
            graphics.drawImage(this.edgeRight, this.x + this.w - n2, n, null);
        }
        graphics.drawImage(this.cornerTL, this.x, this.y, null);
        graphics.drawImage(this.cornerTR, this.x + this.w - n2, this.y, null);
        graphics.drawImage(this.cornerBL, this.x, this.y + this.h - n3, null);
        graphics.drawImage(this.cornerBR, this.x + this.w - n2, this.y + this.h - n3, null);
    }

    public void paintBubble(Graphics graphics) {
    }

    public void dragTo(int n, int n2) {
    }

    public void mouseDown(int n, int n2) {
    }
}

