/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jfx.messagebox.MessageBox;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import utils.ExchangeKey;
import utils.ExchangeKeyTypes;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.tasks.CheckCardTask;
import utils.tasks.SFS3EncryptedStudMoveTask;

public class FXXCAUploadController
implements Initializable {
    private String webparams;
    private Stage stage;
    private static final Logger logger = Logger.getLogger(FXXCAUploadController.class);
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnCheckReg;
    @FXML
    private Button btnVerify;
    @FXML
    private PasswordField tfPin;
    @FXML
    private ProgressIndicator pbLogin;
    private String session_id;
    private String curr_seme;
    private String useragent;
    private String targetpage;
    private String upload_id;
    private String submit_ip;

    public void initialize(URL url, ResourceBundle rb) {
        this.pbLogin.setVisible(false);
        this.btnVerify.setDisable(true);
        this.tfPin.setEditable(false);
    }

    public String getSession_id() {
        return this.session_id;
    }

    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }

    public String getUpload_id() {
        return this.upload_id;
    }

    public void setUpload_id(String upload_id) {
        this.upload_id = upload_id;
    }

    public String getSubmit_ip() {
        return this.submit_ip;
    }

    public void setSubmit_ip(String submit_ip) {
        this.submit_ip = submit_ip;
    }

    public String getTargetpage() {
        return this.targetpage;
    }

    public void setTargetpage(String targetpage) {
        this.targetpage = targetpage;
    }

    public String getWebparams() {
        return this.webparams;
    }

    public void setWebparams(String webparams) {
        this.webparams = webparams;
        logger.debug((Object)webparams);
        this.parseWebParams();
    }

    private void parseWebParams() {
        try {
            JSONObject json = new JSONObject(this.webparams);
            this.curr_seme = json.getString("curr_seme");
            this.session_id = json.getString("session_id");
            this.useragent = json.getString("useragent");
            this.targetpage = json.getString("target_page");
            this.upload_id = json.getString("upload_id");
            this.submit_ip = json.getString("submit_ip");
            logger.debug((Object)("\ncurr_seme:" + this.curr_seme + "\nsession_id:" + this.session_id + "\nuseragent:" + this.useragent + "\ntargetpage:" + this.targetpage + "\nsubmit_ip: " + this.submit_ip + "\nupload_id:" + this.upload_id));
        }
        catch (JSONException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    public String getSessionid() {
        return this.session_id;
    }

    public void setSessionid(String session_id) {
        this.session_id = session_id;
    }

    public String getCurr_seme() {
        return this.curr_seme;
    }

    public void setCurr_seme(String curr_seme) {
        this.curr_seme = curr_seme;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    @FXML
    private void doCheckReg(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbLogin.setProgress(-1.0);
        final CheckCardTask task = new CheckCardTask("XCA");
        task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUploadController.this.pbLogin.setVisible(true);
                FXXCAUploadController.this.btnCheckReg.setDisable(true);
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUploadController.this.pbLogin.setVisible(false);
                MESSAGE isExist = (MESSAGE)((Object)task.getValue());
                if (isExist == MESSAGE.CERT_CHECK_SUCCESS) {
                    FXXCAUploadController.this.btnVerify.setDisable(false);
                    FXXCAUploadController.this.tfPin.setEditable(true);
                    FXXCAUploadController.this.btnCheckReg.setDisable(true);
                    FXXCAUploadController.this.webparams = task.getCardnumber();
                    logger.debug((Object)("\u5361\u865f:" + FXXCAUploadController.this.webparams));
                }
                FXXCAUploadController.this.showMsg(TCCertUtil.getMessage(isExist), "\u6191\u8b49\u6aa2\u67e5\u7d50\u679c", 0x4000000);
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }

    private void showMsg(String message, String title, int msgicon) {
        MessageBox.show((Window)this.stage, (String)message, (String)title, (int)msgicon);
    }

    @FXML
    private void doVerify(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbLogin.setProgress(-1.0);
        final SFS3EncryptedStudMoveTask task = new SFS3EncryptedStudMoveTask(this.targetpage, this.session_id, this.useragent, this.curr_seme, this.submit_ip, this.upload_id);
        task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUploadController.this.pbLogin.setVisible(true);
                FXXCAUploadController.this.btnCheckReg.setDisable(true);
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUploadController.this.pbLogin.setVisible(false);
                Map result = (Map)task.getValue();
                logger.debug((Object)("\u52a0\u5bc6\u5f8c\u5167\u5bb9:" + (String)result.get((Object)ExchangeKeyTypes.EncryptedContent)));
                try {
                    String ori = ExchangeKey.generateDecryptedContent((String)result.get((Object)ExchangeKeyTypes.EncryptedContent), ((String)result.get((Object)ExchangeKeyTypes.ShareAESKey)).getBytes());
                    logger.debug((Object)("\u5167\u89e3\u78bc\u5f8c\u5167\u5bb9:" + ori));
                }
                catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }
}

