/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import tw.com.chttl.CertUtil;
import tw.com.chttl.Module;
import tw.com.chttl.Token;
import tw.com.chttl.TokenException;
import utils.CertificateDN;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.X500PrincipalHelper;
import utils.exchange.soap.Xcaexchange;
import utils.exchange.soap.Xcaexchange_Service;

public class OpenIDLoginVerification
implements PrivilegedAction<JSONObject> {
    private static final Logger logger = Logger.getLogger(OpenIDLoginVerification.class);
    private String cardnumber;
    private String signserial;
    private String signpem;
    private String signedSerial;
    private String cardtype;
    private String schoolid;
    private String schoolname;
    private String orgoid;
    private String ownername;
    private String ownerpid;
    private String datetime;
    private String md5;
    private String signedmd5;
    private String uid;
    private final String password;

    public OpenIDLoginVerification(String password) {
        this.password = password;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSignedmd5() {
        return this.signedmd5;
    }

    public void setSignedmd5(String signedmd5) {
        this.signedmd5 = signedmd5;
    }

    public String getCardnumber() {
        return this.cardnumber;
    }

    public void setCardnumber(String cardnumber) {
        this.cardnumber = cardnumber;
    }

    public String getSignserial() {
        return this.signserial;
    }

    public String getSignpem() {
        return this.signpem;
    }

    public void setSignpem(String signpem) {
        this.signpem = signpem;
    }

    public String getSignedSerial() {
        return this.signedSerial;
    }

    public void setSignedSerial(String signedSerial) {
        this.signedSerial = signedSerial;
    }

    public String getOwnername() {
        return this.ownername;
    }

    public void setOwnername(String ownername) {
        this.ownername = ownername;
    }

    public String getOrgoid() {
        return this.orgoid;
    }

    public void setOrgoid(String orgoid) {
        this.orgoid = orgoid;
    }

    public String getOwnerpid() {
        return this.ownerpid;
    }

    public void setOwnerpid(String ownerpid) {
        this.ownerpid = ownerpid;
    }

    public void setSignserial(String signserial) {
        this.signserial = signserial;
    }

    public String getCardtype() {
        return this.cardtype;
    }

    public void setCardtype(String cardtype) {
        this.cardtype = cardtype;
    }

    public String getSchoolid() {
        return this.schoolid;
    }

    public void setSchoolid(String schoolid) {
        this.schoolid = schoolid;
    }

    public String getSchoolname() {
        return this.schoolname;
    }

    public void setSchoolname(String schoolname) {
        this.schoolname = schoolname;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject run() {
        JSONObject json = new JSONObject();
        try {
            boolean init = Module.initialize();
            if (!init) {
                logger.debug((Object)"READER NOT EXIST");
                return this.setJsonError(MESSAGE.CERTERROR_READER_NOT_EXIST);
            }
            Module module = Module.getInstance();
            int[] tokIDs = module.getTokens();
            if (tokIDs.length == 0) {
                logger.debug((Object)"CARD NOT EXIST");
                return this.setJsonError(MESSAGE.CERTERROR_CARD_NOT_EXIST);
            }
            X509Certificate smartcard = null;
            Token token = module.getToken(tokIDs[0]);
            this.cardnumber = token.getSerialNumber();
            logger.debug((Object)("\u5361\u865f : " + this.cardnumber));
            smartcard = token.getCert(Token.ID_SIGN);
            this.signpem = Base64.encodeBase64String((byte[])smartcard.getEncoded());
            logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49 :\n" + this.signpem));
            this.cardtype = CertUtil.getCertType(smartcard);
            logger.debug((Object)("\u5361\u7247\u985e\u578b : " + this.cardtype));
            logger.debug((Object)("OCSP : " + CertUtil.getOCSP(smartcard)));
            logger.debug((Object)"TCCertUtil String : https://oidc.tc.edu.tw/api/stud-move-upload");
            logger.debug((Object)("\u7c3d\u7ae0:" + TCCertUtil.getSerialNumberFromHex(smartcard.getSerialNumber().toByteArray())));
            this.signserial = TCCertUtil.getSerialNumberFromHex(smartcard.getSerialNumber().toByteArray());
            logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49\u5e8f\u865f : " + this.signserial));
            int ocsp = 0;
            if (ocsp == 0) {
                this.datetime = TCCertUtil.getCurrentDateTime();
                logger.debug((Object)("\u76ee\u524d\u6642\u9593:\n" + this.datetime));
                if (!token.login(this.password)) {
                    logger.debug((Object)"PIN ERROR!");
                    return this.setJsonError(MESSAGE.CERTERROR_PINCODE_ERROR);
                }
                switch (this.cardtype) {
                    case "XCA": {
                        List<String> schoolinfo = OpenIDLoginVerification.doQuerySchoolid(this.cardnumber);
                        if (schoolinfo.isEmpty()) {
                            this.schoolid = "000000";
                            this.schoolname = TCCertUtil.parseDN(smartcard.getSubjectDN().getName(), CertificateDN.VERIFICATION);
                        } else {
                            this.schoolid = schoolinfo.get(0);
                            this.schoolname = schoolinfo.get(1);
                        }
                        logger.debug((Object)("\u6559\u80b2\u90e8\u4ee3\u78bc:" + this.schoolid + ";\u5b78\u6821\u540d\u7a31:" + this.schoolname));
                        this.orgoid = CertUtil.getOrgOID(smartcard);
                        logger.debug((Object)("\u7d44\u7e54OID : " + this.orgoid));
                        ArrayList<String> xcadatas = new ArrayList<String>();
                        xcadatas.add(this.schoolid);
                        xcadatas.add(this.schoolname);
                        xcadatas.add(this.orgoid);
                        logger.debug((Object)TCCertUtil.generateSignData(this.datetime, xcadatas));
                        this.md5 = TCCertUtil.generateSignDataDigest(this.datetime, xcadatas);
                        byte[] bparams = this.md5.getBytes("UTF-8");
                        byte[] sbparams = token.sign(Token.ID_SIGN, bparams, "SHA256withRSA");
                        String b64 = Base64.encodeBase64String((byte[])sbparams);
                        logger.debug((Object)("XCA\u7c3d\u7ae0\u904e\u5f8c\u5b57\u4e32BASE64:\n" + b64));
                        this.signedmd5 = b64;
                        this.setJsonSuccess(json, this.setJsonResponseXCA());
                        break;
                    }
                    case "GCA": {
                        this.setJsonSuccess(json, this.setJsonResponseGCACard());
                        break;
                    }
                    case "MOICA": {
                        X500Principal pn = smartcard.getSubjectX500Principal();
                        X500PrincipalHelper pnhelper = new X500PrincipalHelper(pn);
                        this.ownername = pnhelper.getCN();
                        this.ownerpid = CertUtil.getPersonId(smartcard);
                        ArrayList<String> datas = new ArrayList<String>();
                        datas.add(this.ownername);
                        datas.add(this.ownerpid);
                        this.md5 = TCCertUtil.generateSignDataDigest(this.datetime, datas);
                        logger.debug((Object)("MOICA\u7522\u751f\u6b32\u7c3d\u7ae0\u5b57\u4e32 : " + this.md5));
                        byte[] bparams = this.md5.getBytes("UTF-8");
                        byte[] sbparams = token.sign(Token.ID_SIGN, bparams, "SHA256withRSA");
                        String b64 = Base64.encodeBase64String((byte[])sbparams);
                        logger.debug((Object)("MOICA\u7c3d\u7ae0\u904e\u5f8c\u5b57\u4e32BASE64:\n" + b64));
                        if (logger.isDebugEnabled()) {
                            X509Certificate x509 = TCCertUtil.generateX509FromPEM(this.signpem);
                            TCCertUtil.checkMOICASignature(x509, b64, this.md5);
                            TCCertUtil.checkMOICASignature(smartcard, b64, this.md5);
                        }
                        this.signedmd5 = b64;
                        this.setJsonSuccess(json, this.setJsonResponseMOICACard());
                        break;
                    }
                }
            } else {
                logger.debug((Object)("OCSP FAILED : " + ocsp));
                if (ocsp != 15 && ocsp != 16) {
                    return this.setJsonError(MESSAGE.CERTERROR_OCSP_VERIFY_FAILED);
                }
                return this.setJsonError(MESSAGE.CERTERROR_OCSP_SERVER_CONNECT_FAILED);
            }
            token.logout();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException | CertificateException | JSONException | TokenException e2) {
            try {
                logger.error((Object)e2.getMessage());
                logger.debug((Object)"CERT EXCEPTION");
                return this.setJsonError(MESSAGE.CERTERROR_EXCEPTION);
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            try {
                return this.setJsonError(MESSAGE.CERTERROR_EXCEPTION);
            }
            catch (JSONException exp) {
                logger.error((Object)ex);
            }
        }
        TCCertUtil.listJson(json);
        return json;
    }

    private Map<String, String> setJsonResponseXCA() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cardtype", this.cardtype);
        result.put("serial", this.signserial);
        result.put("orgoid", this.orgoid);
        result.put("time", this.datetime);
        result.put("md5", this.md5);
        result.put("signedmd5", this.signedmd5);
        result.put("schoolid", this.schoolid);
        result.put("schoolname", this.schoolname);
        return result;
    }

    private Map<String, String> setJsonResponseGCACard() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cardtype", this.cardtype);
        result.put("serial", this.signserial);
        result.put("time", this.datetime);
        result.put("md5", this.md5);
        result.put("signedmd5", this.signedmd5);
        result.put("uid", this.uid);
        return result;
    }

    private Map<String, String> setJsonResponseMOICACard() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cardtype", this.cardtype);
        result.put("serial", this.signserial);
        result.put("time", this.datetime);
        result.put("md5", this.md5);
        result.put("signedmd5", this.signedmd5);
        result.put("ownername", this.ownername);
        result.put("ownerpid", this.ownerpid);
        result.put("signpem", this.signpem);
        return result;
    }

    private void setJsonError(JSONObject json, MESSAGE msg) throws JSONException {
        json.put("cardtype", (Object)"NULL");
        json.put("result", (Object)msg);
        TCCertUtil.listJson(json);
    }

    private JSONObject setJsonError(MESSAGE msg) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("cardtype", (Object)"NULL");
        obj.put("result", (Object)msg);
        TCCertUtil.listJson(obj);
        return obj;
    }

    private void setJsonSuccess(JSONObject json, Map<String, String> result) throws JSONException {
        for (String key : result.keySet()) {
            json.put(key, (Object)result.get(key));
            logger.debug((Object)(key + " : " + result.get(key)));
        }
    }

    private static List<String> doQuerySchoolid(String xcaSerial) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQuerySchoolid(xcaSerial);
    }
}

