/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import tw.com.chttl.TokenException;

public abstract class GeneralToken {
    static byte[] SHA1_HEADER = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    static byte[] MD5_HEADER = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    static byte[] SHA256_HEADER = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    static byte[] SHA384_HEADER = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    static byte[] SHA512_HEADER = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};

    GeneralToken() {
    }

    public abstract boolean isTokenPresent();

    public abstract X509Certificate getCert(int var1) throws CertificateException;

    public abstract boolean login(String var1) throws TokenException;

    public abstract boolean logout();

    public abstract byte[] signSHA1(int var1, byte[] var2);

    public abstract byte[] signSHA256(int var1, byte[] var2);

    public abstract byte[] signMD5(int var1, byte[] var2);

    public abstract byte[] signRAW(int var1, byte[] var2);

    public abstract byte[] sign(int var1, byte[] var2, String var3) throws NoSuchAlgorithmException;

    public abstract byte[] unwrap(int var1, byte[] var2);

    public abstract Key unwrap(int var1, byte[] var2, String var3) throws NoSuchAlgorithmException, InvalidKeyException;
}

