/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.EmptyIterator;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class HashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -7079717428744528670L;
    private ArrayList<LinkedList<Dictionary.Pair<K, V>>> buckets;
    private float loadFactor;
    private int count = 0;
    private ArrayList<K> keys = null;
    private transient Map.MapListenerList<K, V> mapListeners = null;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(int capacity) {
        this(capacity, 0.75f);
    }

    public HashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.rehash(capacity);
    }

    public HashMap(Dictionary.Pair<K, V> ... entries) {
        this(Math.max((int)((float)entries.length / 0.75f) + 1, 16));
        for (int i = 0; i < entries.length; ++i) {
            Dictionary.Pair<K, V> entry = entries[i];
            this.put(entry.key, entry.value);
        }
    }

    public HashMap(Map<K, V> map) {
        this(Math.max((int)((float)map.getCount() / 0.75f) + 1, 16));
        for (Object key : map) {
            this.put(key, map.get(key));
        }
    }

    public HashMap(Comparator<K> comparator) {
        this();
        this.setComparator(comparator);
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        V value = null;
        LinkedList<Dictionary.Pair<K, V>> bucket = this.getBucket(key);
        for (Dictionary.Pair pair : bucket) {
            if (!pair.key.equals(key)) continue;
            value = pair.value;
            break;
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, true);
    }

    private V put(K key, V value, boolean notifyListeners) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object previousValue = null;
        LinkedList<Dictionary.Pair<K, V>> bucket = this.getBucket(key);
        int i = 0;
        Iterator iterator = bucket.iterator();
        while (iterator.hasNext()) {
            Dictionary.Pair entry = (Dictionary.Pair)iterator.next();
            if (entry.key.equals(key)) {
                previousValue = entry.value;
                iterator.update(new Dictionary.Pair<K, V>(key, value));
                if (this.mapListeners == null || !notifyListeners) break;
                this.mapListeners.valueUpdated(this, key, previousValue);
                break;
            }
            ++i;
        }
        if (i == bucket.getLength()) {
            bucket.add(new Dictionary.Pair<K, V>(key, value));
            if (this.keys != null) {
                this.keys.add(key);
            }
            ++this.count;
            int capacity = this.getCapacity();
            if (this.count > (int)((float)capacity * this.loadFactor)) {
                this.rehash(capacity * 2);
            }
            if (this.mapListeners != null && notifyListeners) {
                this.mapListeners.valueAdded(this, key);
            }
        }
        return previousValue;
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object value = null;
        LinkedList<Dictionary.Pair<K, V>> bucket = this.getBucket(key);
        Iterator iterator = bucket.iterator();
        while (iterator.hasNext()) {
            Dictionary.Pair entry = (Dictionary.Pair)iterator.next();
            if (!entry.key.equals(key)) continue;
            value = entry.value;
            iterator.remove();
            if (this.keys != null) {
                this.keys.remove(key);
            }
            --this.count;
            if (this.mapListeners == null) break;
            this.mapListeners.valueRemoved(this, key, value);
            break;
        }
        return value;
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            for (LinkedList linkedList : this.buckets) {
                if (linkedList == null) continue;
                linkedList.clear();
            }
            if (this.keys != null) {
                this.keys.clear();
            }
            this.count = 0;
            if (this.mapListeners != null) {
                this.mapListeners.mapCleared(this);
            }
        }
    }

    @Override
    public boolean containsKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        LinkedList<Dictionary.Pair<K, V>> bucket = this.getBucket(key);
        int i = 0;
        for (Dictionary.Pair pair : bucket) {
            if (pair.key.equals(key)) break;
            ++i;
        }
        return i < bucket.getLength();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public int getCapacity() {
        return this.buckets.getLength();
    }

    private void rehash(int capacity) {
        ArrayList<LinkedList<Dictionary.Pair<K, V>>> previousBuckets = this.buckets;
        this.buckets = new ArrayList(capacity);
        for (int i = 0; i < capacity; ++i) {
            this.buckets.add(null);
        }
        if (previousBuckets != null) {
            this.count = 0;
            if (this.keys != null) {
                this.keys.clear();
            }
            for (LinkedList linkedList : previousBuckets) {
                if (linkedList == null) continue;
                for (Dictionary.Pair entry : linkedList) {
                    this.put(entry.key, entry.value, false);
                }
            }
        }
    }

    private LinkedList<Dictionary.Pair<K, V>> getBucket(K key) {
        int hashCode = key.hashCode();
        int bucketIndex = Math.abs(hashCode % this.getCapacity());
        LinkedList<Dictionary.Pair<K, V>> bucket = this.buckets.get(bucketIndex);
        if (bucket == null) {
            bucket = new LinkedList();
            this.buckets.update(bucketIndex, bucket);
        }
        return bucket;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.keys == null ? null : this.keys.getComparator();
    }

    @Override
    public void setComparator(Comparator<K> comparator) {
        Comparator<K> previousComparator = this.getComparator();
        if (comparator == null) {
            this.keys = null;
        } else {
            if (this.keys == null) {
                ArrayList<K> keysLocal = new ArrayList<K>((int)((float)this.getCapacity() * this.loadFactor));
                for (K key : this) {
                    keysLocal.add(key);
                }
                this.keys = keysLocal;
            }
            this.keys.setComparator(comparator);
        }
        if (this.mapListeners != null) {
            this.mapListeners.comparatorChanged(this, previousComparator);
        }
    }

    @Override
    public Iterator<K> iterator() {
        return this.keys == null ? new KeyIterator() : new ImmutableIterator(this.keys.iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        if (this.mapListeners == null) {
            this.mapListeners = new Map.MapListenerList();
        }
        return this.mapListeners;
    }

    public boolean equals(Object o) {
        boolean equals;
        block2: {
            K key;
            V value;
            Map map;
            block1: {
                equals = false;
                if (this != o) break block1;
                equals = true;
                break block2;
            }
            if (!(o instanceof Map) || this.count != (map = (Map)o).getCount()) break block2;
            Iterator<K> i$ = this.iterator();
            while (i$.hasNext() && (equals = (value = this.get(key = i$.next())) == null ? map.containsKey(key) && map.get(key) == null : value.equals(map.get(key)))) {
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 1;
        for (K key : this) {
            hashCode = 31 * hashCode + key.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" {");
        int i = 0;
        for (K key : this) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(key + ":" + this.get(key));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    private class KeyIterator
    implements Iterator<K> {
        private int bucketIndex = 0;
        private Iterator<Dictionary.Pair<K, V>> entryIterator = this.getBucketIterator(this.bucketIndex);
        private int countLocal;
        private Dictionary.Pair<K, V> entry = null;

        public KeyIterator() {
            this.countLocal = HashMap.this.count;
        }

        @Override
        public boolean hasNext() {
            if (this.countLocal != HashMap.this.count) {
                throw new ConcurrentModificationException();
            }
            while (this.entryIterator != null && !this.entryIterator.hasNext()) {
                this.entryIterator = ++this.bucketIndex < HashMap.this.buckets.getLength() ? this.getBucketIterator(this.bucketIndex) : null;
            }
            return this.entryIterator != null;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry = this.entryIterator.next();
            return this.entry.key;
        }

        @Override
        public void remove() {
            if (this.entry == null || this.entryIterator == null) {
                throw new IllegalStateException();
            }
            this.entryIterator.remove();
            --this.countLocal;
            HashMap.this.count--;
            if (HashMap.this.mapListeners != null) {
                HashMap.this.mapListeners.valueRemoved(HashMap.this, this.entry.key, this.entry.value);
            }
            this.entry = null;
        }

        private Iterator<Dictionary.Pair<K, V>> getBucketIterator(int bucketIndexArgument) {
            LinkedList bucket = (LinkedList)HashMap.this.buckets.get(bucketIndexArgument);
            return bucket == null ? new EmptyIterator() : bucket.iterator();
        }
    }
}

