/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ListenerList;

public interface Queue<T>
extends Collection<T> {
    public void enqueue(T var1);

    public T dequeue();

    public T peek();

    @Override
    public boolean isEmpty();

    public int getLength();

    public ListenerList<QueueListener<T>> getQueueListeners();

    public static class QueueListenerList<T>
    extends ListenerList<QueueListener<T>>
    implements QueueListener<T> {
        @Override
        public void itemEnqueued(Queue<T> queue, T item) {
            for (QueueListener listener : this) {
                listener.itemEnqueued(queue, item);
            }
        }

        @Override
        public void itemDequeued(Queue<T> queue, T item) {
            for (QueueListener listener : this) {
                listener.itemDequeued(queue, item);
            }
        }

        @Override
        public void queueCleared(Queue<T> queue) {
            for (QueueListener listener : this) {
                listener.queueCleared(queue);
            }
        }

        @Override
        public void comparatorChanged(Queue<T> queue, Comparator<T> previousComparator) {
            for (QueueListener listener : this) {
                listener.comparatorChanged(queue, previousComparator);
            }
        }
    }
}

