/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedSet<E>
implements Set<E> {
    private Set<E> set;
    private SynchronizedSetListenerList<E> setListeners = new SynchronizedSetListenerList();

    public SynchronizedSet(Set<E> set) {
        if (set == null) {
            throw new IllegalArgumentException("set cannot be null.");
        }
        this.set = set;
    }

    @Override
    public synchronized boolean add(E element) {
        boolean added = false;
        if (!this.contains(element)) {
            this.set.add(element);
            added = true;
            this.setListeners.elementAdded(this, element);
        }
        return added;
    }

    @Override
    public synchronized boolean remove(E element) {
        boolean removed = false;
        if (this.contains(element)) {
            this.set.remove(element);
            removed = true;
            this.setListeners.elementRemoved(this, element);
        }
        return removed;
    }

    @Override
    public synchronized boolean contains(E element) {
        return this.set.contains(element);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public synchronized void clear() {
        if (!this.set.isEmpty()) {
            this.set.clear();
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public synchronized int getCount() {
        return this.set.getCount();
    }

    @Override
    public synchronized Comparator<E> getComparator() {
        return this.set.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<E> comparator) {
        Comparator<E> previousComparator = this.getComparator();
        this.set.setComparator(comparator);
        this.setListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator(this.set.iterator());
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    private static class SynchronizedSetListenerList<E>
    extends Set.SetListenerList<E> {
        private SynchronizedSetListenerList() {
        }

        @Override
        public synchronized void add(SetListener<E> listener) {
            super.add(listener);
        }

        @Override
        public synchronized void remove(SetListener<E> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void elementAdded(Set<E> set, E element) {
            super.elementAdded(set, element);
        }

        @Override
        public synchronized void elementRemoved(Set<E> set, E element) {
            super.elementRemoved(set, element);
        }

        @Override
        public synchronized void setCleared(Set<E> set) {
            super.setCleared(set);
        }

        @Override
        public synchronized void comparatorChanged(Set<E> set, Comparator<E> previousComparator) {
            super.comparatorChanged(set, previousComparator);
        }
    }
}

