/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.json;

import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.adapter.MapAdapter;

public class JSON {
    public static <T> T get(Object root, String path) {
        return JSON.get(root, JSON.parse(path));
    }

    public static <T> T get(Object root, Sequence<String> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("keys is null.");
        }
        Object value = root;
        int n = keys.getLength();
        for (int i = 0; i < n && value != null; ++i) {
            Map adapter;
            String key = keys.get(i);
            Map map = value instanceof java.util.Map ? new MapAdapter((java.util.Map)value) : (adapter = value instanceof Map ? (Map)value : new BeanAdapter(value));
            if (adapter.containsKey(key)) {
                value = adapter.get(key);
                continue;
            }
            if (value instanceof Sequence) {
                Sequence sequence = (Sequence)value;
                value = sequence.get(Integer.parseInt(key));
                continue;
            }
            if (value instanceof Dictionary) {
                Dictionary dictionary = (Dictionary)value;
                value = dictionary.get(key);
                continue;
            }
            throw new IllegalArgumentException("Property \"" + key + "\" not found.");
        }
        return (T)value;
    }

    public static byte getByte(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.byteValue();
    }

    public static short getShort(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.shortValue();
    }

    public static int getInt(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.intValue();
    }

    public static long getLong(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.longValue();
    }

    public static float getFloat(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.floatValue();
    }

    public static double getDouble(Object root, String path) {
        Number value = (Number)JSON.get(root, path);
        return value.doubleValue();
    }

    public static <T> T put(Object root, String path, T value) {
        Object previousValue;
        Map<String, T> adapter;
        if (root == null) {
            throw new IllegalArgumentException("root is null.");
        }
        Sequence<String> keys = JSON.parse(path);
        if (keys.getLength() == 0) {
            throw new IllegalArgumentException("Path is empty.");
        }
        String key = keys.remove(keys.getLength() - 1, 1).get(0);
        T parent = JSON.get(root, keys);
        if (parent == null) {
            throw new IllegalArgumentException("Invalid path.");
        }
        Map<Object, Object> map = parent instanceof java.util.Map ? new MapAdapter((java.util.Map)parent) : (adapter = parent instanceof Map ? (Map)parent : new BeanAdapter(parent));
        if (adapter.containsKey(key)) {
            previousValue = adapter.put(key, value);
        } else if (parent instanceof Sequence) {
            Sequence sequence = (Sequence)parent;
            previousValue = sequence.update(Integer.parseInt(key), value);
        } else if (parent instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)parent;
            previousValue = dictionary.put(key, value);
        } else {
            throw new IllegalArgumentException("Property \"" + key + "\" not found.");
        }
        return (T)previousValue;
    }

    public static <T> T remove(Object root, String path) {
        Object previousValue;
        if (root == null) {
            throw new IllegalArgumentException("root is null.");
        }
        Sequence<String> keys = JSON.parse(path);
        if (keys.getLength() == 0) {
            throw new IllegalArgumentException("Path is empty.");
        }
        String key = keys.remove(keys.getLength() - 1, 1).get(0);
        T parent = JSON.get(root, keys);
        if (parent == null) {
            throw new IllegalArgumentException("Invalid path.");
        }
        if (parent instanceof Sequence) {
            Sequence sequence = (Sequence)parent;
            previousValue = sequence.remove(Integer.parseInt(key), 1).get(0);
        } else if (parent instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)parent;
            previousValue = dictionary.remove(key);
        } else {
            throw new IllegalArgumentException("Property \"" + key + "\" not found.");
        }
        return (T)previousValue;
    }

    public static <T> boolean containsKey(Object root, String path) {
        boolean containsKey;
        if (root == null) {
            throw new IllegalArgumentException("root is null.");
        }
        Sequence<String> keys = JSON.parse(path);
        if (keys.getLength() == 0) {
            throw new IllegalArgumentException("Path is empty.");
        }
        String key = keys.remove(keys.getLength() - 1, 1).get(0);
        T parent = JSON.get(root, keys);
        if (parent == null) {
            containsKey = false;
        } else {
            Map adapter = parent instanceof java.util.Map ? new MapAdapter((java.util.Map)parent) : (parent instanceof Map ? (Map)parent : new BeanAdapter(parent));
            containsKey = adapter.containsKey(key);
            if (!containsKey) {
                if (parent instanceof Sequence) {
                    Sequence sequence = (Sequence)parent;
                    containsKey = sequence.getLength() > Integer.parseInt(key);
                } else if (parent instanceof Dictionary) {
                    Dictionary dictionary = (Dictionary)parent;
                    containsKey = dictionary.containsKey(key);
                } else {
                    throw new IllegalArgumentException("Property \"" + key + "\" not found.");
                }
            }
        }
        return containsKey;
    }

    public static Sequence<String> parse(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        int n = path.length();
        while (i < n) {
            boolean bracketed;
            char c = path.charAt(i++);
            StringBuilder identifierBuilder = new StringBuilder();
            boolean bl = bracketed = c == '[';
            if (bracketed && i < n) {
                boolean quoted;
                c = path.charAt(i++);
                char quote = '\u0000';
                boolean bl2 = quoted = c == '\"' || c == '\'';
                if (quoted && i < n) {
                    quote = c;
                    c = path.charAt(i++);
                }
                while (i <= n && bracketed) {
                    bracketed = quoted || c != ']';
                    if (!bracketed) continue;
                    if (c == quote && i < n) {
                        boolean bl3 = quoted = (c = path.charAt(i++)) == quote;
                    }
                    if (!quoted && c == ']') continue;
                    if (Character.isISOControl(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    identifierBuilder.append(c);
                    if (i >= n) continue;
                    c = path.charAt(i++);
                }
                if (quoted) {
                    throw new IllegalArgumentException("Unterminated quoted identifier.");
                }
                if (bracketed) {
                    throw new IllegalArgumentException("Unterminated bracketed identifier.");
                }
                if (i < n && (c = path.charAt(i)) == '.') {
                    ++i;
                }
            } else {
                while (i <= n && c != '.' && c != '[') {
                    if (!Character.isJavaIdentifierPart(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    identifierBuilder.append(c);
                    if (i < n) {
                        c = path.charAt(i);
                    }
                    ++i;
                }
                if (c == '[') {
                    --i;
                }
            }
            if (c == '.' && i == n) {
                throw new IllegalArgumentException("Path cannot end with a '.' character.");
            }
            if (identifierBuilder.length() == 0) {
                throw new IllegalArgumentException("Missing identifier.");
            }
            keys.add(identifierBuilder.toString());
        }
        return keys;
    }
}

