/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Map;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;

public class Resources
implements Dictionary<String, Object>,
Iterable<String> {
    private final Resources parent;
    private final String baseName;
    private final Locale locale;
    private final Charset charset;
    private Map<String, Object> resourceMap = null;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public Resources(String baseName) throws IOException, SerializationException {
        this(null, baseName, Locale.getDefault(), Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public Resources(Resources parent, String baseName) throws IOException, SerializationException {
        this(parent, baseName, Locale.getDefault(), Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public Resources(String baseName, Locale locale) throws IOException, SerializationException {
        this(null, baseName, locale, Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public Resources(Resources parent, String baseName, Locale locale) throws IOException, SerializationException {
        this(parent, baseName, locale, Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public Resources(String baseName, Charset charset) throws IOException, SerializationException {
        this(null, baseName, Locale.getDefault(), charset);
    }

    public Resources(Resources parent, String baseName, Charset charset) throws IOException, SerializationException {
        this(parent, baseName, Locale.getDefault(), charset);
    }

    public Resources(Resources parent, String baseName, Locale locale, Charset charset) throws IOException, SerializationException {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.parent = parent;
        this.baseName = baseName;
        this.locale = locale;
        this.charset = charset;
        String resourceName = baseName.replace('.', '/');
        this.resourceMap = this.readJSONResource(resourceName + "." + "json");
        Map<String, Object> overrideMap = this.readJSONResource(resourceName + "_" + locale.getLanguage() + "." + "json");
        if (overrideMap != null) {
            if (this.resourceMap == null) {
                this.resourceMap = overrideMap;
            } else {
                this.applyOverrides(this.resourceMap, overrideMap);
            }
        }
        if ((overrideMap = this.readJSONResource(resourceName + "_" + locale.toString() + "." + "json")) != null) {
            if (this.resourceMap == null) {
                this.resourceMap = overrideMap;
            } else {
                this.applyOverrides(this.resourceMap, overrideMap);
            }
        }
        if (this.resourceMap == null) {
            throw new MissingResourceException("Can't find resource for base name " + baseName + ", locale " + locale, baseName, "");
        }
    }

    public Resources getParent() {
        return this.parent;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Object get(String key) {
        return this.resourceMap.containsKey(key) ? this.resourceMap.get(key) : (this.parent == null ? null : this.parent.get(key));
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("Resources are immutable.");
    }

    @Override
    public Object remove(String key) {
        throw new UnsupportedOperationException("Resources are immutable.");
    }

    @Override
    public boolean containsKey(String key) {
        return this.resourceMap.containsKey(key) || this.parent != null && this.parent.containsKey(key);
    }

    @Override
    public Iterator<String> iterator() {
        return new ImmutableIterator<String>(this.resourceMap.iterator());
    }

    private void applyOverrides(Map<String, Object> sourceMap, Map<String, Object> overridesMap) {
        for (String key : overridesMap) {
            if (!sourceMap.containsKey(key)) continue;
            Object source = sourceMap.get(key);
            Object override = overridesMap.get(key);
            if (source instanceof Map && override instanceof Map) {
                this.applyOverrides((Map)source, (Map)override);
                continue;
            }
            sourceMap.put(key, overridesMap.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readJSONResource(String name) throws IOException, SerializationException {
        Map resourceMapFromResource = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(name);
        if (inputStream != null) {
            JSONSerializer serializer = new JSONSerializer(this.charset);
            try {
                resourceMapFromResource = (Map)serializer.readObject(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return resourceMapFromResource;
    }
}

