/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProvider(String providerName) {
        String providerClassName = null;
        try {
            providerClassName = System.getProperty(providerName);
        }
        catch (SecurityException exception) {
            // empty catch block
        }
        if (providerClassName == null) {
            String serviceName = "META-INF/services/" + providerName;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream serviceInputStream = classLoader.getResourceAsStream(serviceName);
            if (serviceInputStream != null) {
                try {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(serviceInputStream, "UTF-8"));
                        String line = reader.readLine();
                        while (line != null && (line.length() == 0 || line.startsWith("#"))) {
                            line = reader.readLine();
                        }
                        providerClassName = line;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException exception) {
                    // empty catch block
                }
            }
        }
        Class<?> providerClass = null;
        if (providerClassName != null) {
            try {
                providerClass = Class.forName(providerClassName);
            }
            catch (ClassNotFoundException exception) {
                // empty catch block
            }
        }
        Object provider = null;
        if (providerClass != null) {
            try {
                provider = providerClass.newInstance();
            }
            catch (InstantiationException exception) {
            }
            catch (IllegalAccessException exception) {
                // empty catch block
            }
        }
        return provider;
    }
}

