/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Time
implements Comparable<Time>,
Serializable {
    private static final long serialVersionUID = -2813485511869915193L;
    public final int hour;
    public final int minute;
    public final int second;
    public final int millisecond;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    private static final Pattern PATTERN = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{3}))?$");

    public Time() {
        this(new GregorianCalendar());
    }

    public Time(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException();
        }
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.millisecond = calendar.get(14);
    }

    public Time(int hour, int minute, int second) {
        this(hour, minute, second, 0);
    }

    public Time(int hour, int minute, int second, int millisecond) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour.");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute.");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second.");
        }
        if (millisecond < 0 || millisecond > 999) {
            throw new IllegalArgumentException("Invalid millisecond.");
        }
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
    }

    public Time(int milliseconds) {
        int msec = milliseconds;
        msec %= 86400000;
        msec = (msec + 86400000) % 86400000;
        this.hour = msec / 3600000;
        this.minute = (msec %= 3600000) / 60000;
        this.second = (msec %= 60000) / 1000;
        this.millisecond = msec %= 1000;
    }

    public Time add(int milliseconds) {
        return new Time(this.toMilliseconds() + milliseconds);
    }

    public int subtract(Time time) {
        if (time == null) {
            throw new IllegalArgumentException();
        }
        return this.toMilliseconds() - time.toMilliseconds();
    }

    public int toMilliseconds() {
        return this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.millisecond;
    }

    @Override
    public int compareTo(Time time) {
        int result = this.hour - time.hour;
        if (result == 0 && (result = this.minute - time.minute) == 0 && (result = this.second - time.second) == 0) {
            result = this.millisecond - time.millisecond;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof Time && ((Time)o).hour == this.hour && ((Time)o).minute == this.minute && ((Time)o).second == this.second && ((Time)o).millisecond == this.millisecond;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.second;
        result = 31 * result + this.millisecond;
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        format.setMinimumIntegerDigits(2);
        buf.append(format.format(this.hour));
        buf.append(":");
        buf.append(format.format(this.minute));
        buf.append(":");
        buf.append(format.format(this.second));
        if (this.millisecond > 0) {
            buf.append(".");
            format.setMinimumIntegerDigits(3);
            buf.append(format.format(this.millisecond));
        }
        return buf.toString();
    }

    public static Time decode(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid time format: " + value);
        }
        int hour = Integer.parseInt(matcher.group(1));
        int minute = Integer.parseInt(matcher.group(2));
        int second = Integer.parseInt(matcher.group(3));
        String millisecondSequence = matcher.group(4);
        int millisecond = millisecondSequence == null ? 0 : Integer.parseInt(millisecondSequence.substring(1));
        return new Time(hour, minute, second, millisecond);
    }

    public static final class Range {
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public final Time start;
        public final Time end;

        public Range(Time time) {
            this(time, time);
        }

        public Range(Time start, Time end) {
            this.start = start;
            this.end = end;
        }

        public Range(String start, String end) {
            this.start = Time.decode(start);
            this.end = Time.decode(end);
        }

        public Range(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            this.start = range.start;
            this.end = range.end;
        }

        public Range(Dictionary<String, ?> range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Object startRange = range.get(START_KEY);
            Object endRange = range.get(END_KEY);
            if (startRange == null) {
                throw new IllegalArgumentException("start is required.");
            }
            if (endRange == null) {
                throw new IllegalArgumentException("end is required.");
            }
            this.start = startRange instanceof String ? Time.decode((String)startRange) : (Time)startRange;
            this.end = endRange instanceof String ? Time.decode((String)endRange) : (Time)endRange;
        }

        public int getLength() {
            return Math.abs(this.start.subtract(this.end)) + 1;
        }

        public boolean contains(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range normalizedRange = range.normalize();
            boolean contains = this.start.compareTo(this.end) < 0 ? this.start.compareTo(normalizedRange.start) <= 0 && this.end.compareTo(normalizedRange.end) >= 0 : this.end.compareTo(normalizedRange.start) <= 0 && this.start.compareTo(normalizedRange.end) >= 0;
            return contains;
        }

        public boolean contains(Time time) {
            if (time == null) {
                throw new IllegalArgumentException("time is null.");
            }
            boolean contains = this.start.compareTo(this.end) < 0 ? this.start.compareTo(time) <= 0 && this.end.compareTo(time) >= 0 : this.end.compareTo(time) <= 0 && this.start.compareTo(time) >= 0;
            return contains;
        }

        public boolean intersects(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range normalizedRange = range.normalize();
            boolean intersects = this.start.compareTo(this.end) < 0 ? this.start.compareTo(normalizedRange.end) <= 0 && this.end.compareTo(normalizedRange.start) >= 0 : this.end.compareTo(normalizedRange.end) <= 0 && this.start.compareTo(normalizedRange.start) >= 0;
            return intersects;
        }

        public Range normalize() {
            Time earlier = this.start.compareTo(this.end) < 0 ? this.start : this.end;
            Time later = earlier == this.start ? this.end : this.start;
            return new Range(earlier, later);
        }

        public static Range decode(String value) {
            Range range;
            if (value == null) {
                throw new IllegalArgumentException();
            }
            if (value.startsWith("{")) {
                try {
                    range = new Range(JSONSerializer.parseMap(value));
                }
                catch (SerializationException exception) {
                    throw new IllegalArgumentException(exception);
                }
            } else {
                range = new Range(Time.decode(value));
            }
            return range;
        }
    }
}

