/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.pivot.collections.Group;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;

public class TaskGroup
extends Task<Void>
implements Group<Task<?>>,
Iterable<Task<?>> {
    private HashSet<Task<?>> tasks = new HashSet();
    private int complete = 0;

    public TaskGroup() {
        this(DEFAULT_EXECUTOR_SERVICE);
    }

    public TaskGroup(ExecutorService executorService) {
        super(executorService);
    }

    @Override
    public synchronized Void execute() throws TaskExecutionException {
        TaskListener<Object> taskListener = new TaskListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskExecuted(Task<Object> task) {
                TaskGroup taskGroup = TaskGroup.this;
                synchronized (taskGroup) {
                    TaskGroup.this.complete++;
                    TaskGroup.this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeFailed(Task<Object> task) {
                TaskGroup taskGroup = TaskGroup.this;
                synchronized (taskGroup) {
                    TaskGroup.this.complete++;
                    TaskGroup.this.notify();
                }
            }
        };
        this.complete = 0;
        for (Task<?> task : this.tasks) {
            task.execute(taskListener);
        }
        while (this.complete < this.getCount()) {
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw new TaskExecutionException(exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void abort() {
        Iterator<Task<?>> i$ = this.iterator();
        while (i$.hasNext()) {
            Task<?> task;
            Task<?> task2 = task = i$.next();
            synchronized (task2) {
                if (task.isPending()) {
                    task.abort();
                }
            }
        }
        super.abort();
    }

    @Override
    public synchronized boolean add(Task<?> element) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.add(element);
    }

    @Override
    public synchronized boolean remove(Task<?> element) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.remove(element);
    }

    @Override
    public synchronized boolean contains(Task<?> element) {
        return this.tasks.contains(element);
    }

    public synchronized int getCount() {
        return this.tasks.getCount();
    }

    @Override
    public Iterator<Task<?>> iterator() {
        return new ImmutableIterator(this.tasks.iterator());
    }
}

