/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.xml;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.xml.Element;
import org.apache.pivot.xml.Node;

public class XML {
    public static Element getElement(Element root, String path) {
        if (root == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        ArrayList<String> pathComponents = new ArrayList<String>(path.split("/"));
        Element current = root;
        int n = pathComponents.getLength();
        for (int i = 0; i < n; ++i) {
            int index;
            String tagName;
            String pathComponent = pathComponents.get(i);
            int leadingBracketIndex = pathComponent.indexOf(91);
            if (leadingBracketIndex == -1) {
                tagName = pathComponent;
                index = 0;
            } else {
                tagName = pathComponent.substring(0, leadingBracketIndex);
                int trailingBracketIndex = pathComponent.lastIndexOf(93);
                if (trailingBracketIndex == -1) {
                    throw new IllegalArgumentException("Unterminated index identifier.");
                }
                index = Integer.parseInt(pathComponent.substring(leadingBracketIndex + 1, trailingBracketIndex));
            }
            int j = 0;
            int k = 0;
            for (Node node : current) {
                Element element;
                if (node instanceof Element && (element = (Element)node).getName().equals(tagName)) {
                    if (k == index) break;
                    ++k;
                }
                ++j;
            }
            if (j >= current.getLength()) {
                current = null;
                break;
            }
            current = (Element)current.get(j);
        }
        return current;
    }

    public static List<Element> getElements(Element root, String path, String name) {
        Element element = XML.getElement(root, path);
        return element == null ? null : element.getElements(name);
    }

    public static String getText(Element root, String path) {
        Element element = XML.getElement(root, path);
        return element == null ? null : element.getText();
    }
}

