/*
 * Decompiled with CFR 0.152.
 */
package certutil;

import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import tw.com.chttl.Module;
import tw.com.chttl.Token;

public class CertFromXCA
implements PrivilegedAction<X509Certificate> {
    private int type;
    private static final Logger logger = Logger.getLogger(CertFromXCA.class);

    public CertFromXCA(int type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate run() {
        X509Certificate xca2 = null;
        Token tok = null;
        try {
            Module.initialize();
            Module module = Module.getInstance();
            int[] tokIDs = module.getTokens();
            if (tokIDs.length != 0) {
                tok = module.getToken(tokIDs[0]);
                if (tok.isTokenPresent()) {
                    xca2 = tok.getCert(this.type);
                    return xca2;
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        finally {
            return xca2;
        }
    }
}

