/*
 * Decompiled with CFR 0.152.
 */
package sfs3;

import certutil.TrustStoreFromClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.SSLContext;
import key.ExchangeKey;
import key.ExchangeKeyTypes;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public abstract class EncryptedXML {
    private static final Logger logger = Logger.getLogger(EncryptedXML.class);
    private Map<ExchangeKeyTypes, Object> mapserverdhkey;
    private DHParameterSpec servParamSpec;
    private final String postUrl;
    private String phppk;
    private KeyPair servKP;
    private String servPub;
    private String xml;
    private byte[] servSecret;
    private static CloseableHttpClient demo;
    private String sessionid;
    private String cookie_sch_id;
    private String useragent;
    private static HttpPost httpPost;
    private String aeskey;

    public String getPostUrl() {
        return this.postUrl;
    }

    public String getCookie_sch_id() {
        return this.cookie_sch_id;
    }

    public void setCookie_sch_id(String cookie_sch_id) {
        this.cookie_sch_id = cookie_sch_id;
    }

    public Map<ExchangeKeyTypes, Object> getMapserverdhkey() {
        return this.mapserverdhkey;
    }

    public void setMapserverdhkey(Map<ExchangeKeyTypes, Object> mapserverdhkey) {
        this.mapserverdhkey = mapserverdhkey;
    }

    public DHParameterSpec getServParamSpec() {
        return this.servParamSpec;
    }

    public void setServParamSpec(DHParameterSpec servParamSpec) {
        this.servParamSpec = servParamSpec;
    }

    public String getPhppk() {
        return this.phppk;
    }

    public void setPhppk(String phppk) {
        this.phppk = phppk;
    }

    public KeyPair getServKP() {
        return this.servKP;
    }

    public void setServKP(KeyPair servKP) {
        this.servKP = servKP;
    }

    public String getServPub() {
        return this.servPub;
    }

    public void setServPub(String servPub) {
        this.servPub = servPub;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public byte[] getServSecret() {
        return this.servSecret;
    }

    public void setServSecret(byte[] servSecret) {
        this.servSecret = servSecret;
    }

    public static CloseableHttpClient getDemo() {
        return demo;
    }

    public static void setDemo(CloseableHttpClient demo) {
        EncryptedXML.demo = demo;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public String getAeskey() {
        return this.aeskey;
    }

    public void setAeskey(String aeskey) {
        this.aeskey = aeskey;
    }

    public static HttpPost getHttpPost() {
        return httpPost;
    }

    public static void setHttpPost(HttpPost httpPost) {
        EncryptedXML.httpPost = httpPost;
    }

    public EncryptedXML(String url, String sessionid, String useragent, String cookie_sch_id) {
        this.postUrl = url;
        this.sessionid = sessionid;
        this.useragent = useragent;
        this.cookie_sch_id = cookie_sch_id;
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String path = AccessController.doPrivileged(new TrustStoreFromClient());
            logger.debug((Object)("Trust Store : " + path));
            trustStore.load(new FileInputStream(path), "changeit".toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("compatibility").build();
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie session_cookie = new BasicClientCookie("PHPSESSID", sessionid);
            session_cookie.setDomain(this.getDomainName(this.postUrl));
            session_cookie.setPath("/");
            BasicClientCookie schoolid_cookie = new BasicClientCookie("cookie_sch_id", cookie_sch_id);
            schoolid_cookie.setDomain(this.getDomainName(this.postUrl));
            schoolid_cookie.setPath("/");
            cookieStore.addCookie((Cookie)session_cookie);
            cookieStore.addCookie((Cookie)schoolid_cookie);
            demo = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(globalConfig).setDefaultCookieStore((CookieStore)cookieStore).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            logger.debug((Object)ex);
        }
        httpPost = new HttpPost(this.postUrl);
        httpPost.setHeader("User-Agent", useragent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDomainName(String url) {
        String domainname = "";
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            domainname = domain.startsWith("www.") ? domain.substring(4) : domain;
            return domainname;
        }
        catch (URISyntaxException ex) {
            logger.error((Object)ex);
        }
        finally {
            return domainname;
        }
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public String getXML() {
        return this.xml;
    }

    public void setXML(String xml) {
        this.xml = xml;
    }

    public byte[] getSecretKey() {
        return this.servSecret;
    }

    public String getAesKey() {
        return this.aeskey;
    }

    protected abstract void init();

    protected void getDHKey() {
        try {
            this.mapserverdhkey = ExchangeKey.generateServerDHKey();
            this.servParamSpec = (DHParameterSpec)this.mapserverdhkey.get((Object)ExchangeKeyTypes.DHParameterSpec);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String performKeyExchangePost() {
        String responseString = null;
        BigInteger servp = this.servParamSpec.getP();
        BigInteger servg = this.servParamSpec.getG();
        this.servKP = (KeyPair)this.mapserverdhkey.get((Object)ExchangeKeyTypes.ServerPublicKeyPair);
        this.servPub = (String)this.mapserverdhkey.get((Object)ExchangeKeyTypes.ServerPublicKey);
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        pairList.add(new BasicNameValuePair("sid", this.sessionid));
        pairList.add(new BasicNameValuePair("getkey", "true"));
        pairList.add(new BasicNameValuePair("serverp", servp.toString()));
        pairList.add(new BasicNameValuePair("serverg", servg.toString()));
        pairList.add(new BasicNameValuePair("serverpk", this.servPub));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairList, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            CloseableHttpResponse response = demo.execute((HttpUriRequest)httpPost, (HttpContext)clientContext);
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.debug((Object)("PHP Response : " + responseString));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        finally {
            return responseString;
        }
    }
}

