/*
 * Decompiled with CFR 0.152.
 */
package sfs3;

import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import key.ExchangeKey;
import key.ExchangeKeyTypes;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import sfs3.EncryptedXML;
import sfs3.XMLParser;

public class SFS3EncryptedXML
extends EncryptedXML
implements PrivilegedAction<Map<ExchangeKeyTypes, String>> {
    private static final Logger logger = Logger.getLogger(SFS3EncryptedXML.class);
    private List<String> sts;
    private String currseme;

    public SFS3EncryptedXML(String url, String sessionid, String useragent, String currseme, List<String> sts, String cookie_sch_id) {
        super(url, sessionid, useragent, cookie_sch_id);
        this.currseme = currseme;
        this.sts = sts;
        this.init();
    }

    public void setCurrseme(String seme) {
        this.currseme = seme;
    }

    public String getCurrseme() {
        return this.currseme;
    }

    @Override
    protected final void init() {
        this.getDHKey();
        this.setPhppk(this.performKeyExchangePost());
        this.performPostXML(this.currseme, this.sts);
    }

    private void performPostXML(String curr_seme, List<String> choice) {
        String output = null;
        try {
            byte[] servSecret = ExchangeKey.generateShareKey(this.getPhppk(), this.getServParamSpec(), this.getServKP());
            logger.debug((Object)("Server Secret Key:" + Base64.encodeBase64String(servSecret)));
            ArrayList<BasicNameValuePair> pair = new ArrayList<BasicNameValuePair>();
            pair.add(new BasicNameValuePair("sid", this.getSessionid()));
            pair.add(new BasicNameValuePair("getkey", "false"));
            pair.add(new BasicNameValuePair("curr_seme", curr_seme));
            for (String s : choice) {
                pair.add(new BasicNameValuePair("choice[".concat(s).concat("]"), "on"));
            }
            pair.add(new BasicNameValuePair("output_xml", "\u532f\u51faXML"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pair, "UTF-8");
            HttpPost httpPost = SFS3EncryptedXML.getHttpPost();
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpClient demo = SFS3EncryptedXML.getDemo();
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            CloseableHttpResponse response = demo.execute((HttpUriRequest)httpPost, (HttpContext)clientContext);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            this.setXML(responseString);
            logger.info((Object)("PHP Response 2 :" + this.getXML()));
            this.setAeskey(ExchangeKey.generateAESKey(servSecret));
            String aeskey = this.getAeskey();
            if (logger.isDebugEnabled()) {
                output = ExchangeKey.generateDecryptedXML(responseString, aeskey.getBytes());
                logger.debug((Object)("\u89e3\u78bc\u5f8cXML : " + output));
                XMLParser xmlparser = new XMLParser(new StringReader(output));
                logger.info((Object)("\u5b78\u751f\u59d3\u540d : " + xmlparser.getName()));
                logger.debug((Object)("\u5b78\u751f\u6027\u5225 : " + xmlparser.getSex()));
                logger.debug((Object)("\u5b78\u751f\u751f\u65e5 : " + xmlparser.getBirthday()));
                logger.debug((Object)("\u5b78\u751f\u8eab\u4efd\u8b49 : " + xmlparser.getPid()));
            }
        }
        catch (InvalidKeyException ex) {
            logger.error((Object)ex);
            this.init();
        }
        catch (Exception ex) {
            logger.info((Object)ex);
        }
    }

    @Override
    public Map<ExchangeKeyTypes, String> run() {
        EnumMap<ExchangeKeyTypes, String> cypher = new EnumMap<ExchangeKeyTypes, String>(ExchangeKeyTypes.class);
        cypher.put(ExchangeKeyTypes.ShareAESKey, this.getAesKey());
        logger.debug((Object)("Return EncryptedXML : " + this.getXML()));
        cypher.put(ExchangeKeyTypes.EncryptedXML, this.getXML());
        return cypher;
    }
}

