/*
 * Decompiled with CFR 0.152.
 */
package sfs3;

import certutil.AESUtil;
import certutil.DecryptFromXCA;
import certutil.VerifyFromXCA;
import certutil.checkCard;
import java.io.Serializable;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import key.ExchangeDataTypes;
import org.apache.log4j.Logger;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.MessageType;

public class exchangedata
implements Serializable {
    private static final long serialVersionUID = -3740598785998193900L;
    private static final Logger logger = Logger.getLogger(exchangedata.class);
    private String xcapassword;
    private String out_school_id;
    private String in_school_id;
    private String stud_name;
    private String stud_pid;
    private String stud_birthday;
    private String matchable_name;
    private String matchable_pid;
    private String matchable_birthday;
    private String encryption_key;
    private String encryption_xml;
    private String sign_xml;
    private String upload_time;
    private String download_time;
    private int download_times;
    private final Map<ExchangeDataTypes, String> DecryptedData;

    public exchangedata(String out_school_id, String in_school_id, String stud_name, String stud_pid, String stud_birthday, String encryption_key, String encryption_xml, String sign_xml, String xcapassword, String matchable_name, String matchable_pid, String matchable_birthday) {
        this.out_school_id = out_school_id;
        this.in_school_id = in_school_id;
        this.stud_name = stud_name;
        this.stud_pid = stud_pid;
        this.stud_birthday = stud_birthday;
        this.encryption_key = encryption_key;
        this.xcapassword = xcapassword;
        this.DecryptedData = new HashMap<ExchangeDataTypes, String>();
        this.encryption_xml = encryption_xml;
        this.sign_xml = sign_xml;
        this.matchable_name = matchable_name;
        this.matchable_pid = matchable_pid;
        this.matchable_birthday = matchable_birthday;
        this.doAESCrypt();
    }

    public exchangedata() {
        this.DecryptedData = new HashMap<ExchangeDataTypes, String>();
        this.DecryptedData.put(ExchangeDataTypes.AESKEY, "empty record");
        this.generateFalseDecryptedData();
    }

    protected final void doAESCrypt() {
        int result = AccessController.doPrivileged(new checkCard());
        if (result != 2) {
            Alert.alert((MessageType)MessageType.ERROR, (String)"\u8acb\u78ba\u5b9a\u5099\u59a5\u8b80\u5361\u6a5f\u4e26\u63d2\u5165XCA\u6191\u8b49", null);
        } else {
            String aeskey = this.generateAESKey();
            logger.debug((Object)("\u91cd\u5efaAESKEY : " + aeskey));
            if (aeskey.equals("pin error")) {
                logger.error((Object)"PIN\u78bc\u932f\u8aa4!");
                this.DecryptedData.put(ExchangeDataTypes.AESKEY, "pin error");
                this.generateFalseDecryptedData();
            } else if (aeskey.equals("no aes key")) {
                logger.error((Object)"\u7121\u6cd5\u6b63\u78ba\u4ee5\u8f49\u5165\u6821XCA\u52a0\u5bc6\u91d1\u9470\u91cd\u5efaAES KEY!");
                this.DecryptedData.put(ExchangeDataTypes.AESKEY, "no aes key");
                this.generateFalseDecryptedData();
            } else {
                this.generateDecryptedData();
            }
        }
    }

    private void generateFalseDecryptedData() {
        String aeskey = this.DecryptedData.get((Object)ExchangeDataTypes.AESKEY);
        logger.debug((Object)("AES KEY : " + aeskey));
        this.DecryptedData.put(ExchangeDataTypes.STUD_NAME, aeskey);
        logger.debug((Object)("Stud Name : " + this.stud_name));
        this.DecryptedData.put(ExchangeDataTypes.STUD_PID, aeskey);
        this.DecryptedData.put(ExchangeDataTypes.STUD_BIRTHDAY, aeskey);
        logger.debug((Object)("Encryption XML : " + aeskey));
        this.DecryptedData.put(ExchangeDataTypes.VERIFIED, String.valueOf(false));
        this.DecryptedData.put(ExchangeDataTypes.MATCH, String.valueOf(false));
    }

    private String generateAESKey() {
        String aeskey = "";
        logger.debug((Object)("\nXCA PASSWORD : " + this.xcapassword + "\nEncryption_key : " + this.encryption_key));
        aeskey = AccessController.doPrivileged(new DecryptFromXCA(this.xcapassword, this.encryption_key));
        if (aeskey.equals("pin error")) {
            this.DecryptedData.put(ExchangeDataTypes.AESKEY, "pin error");
        } else if (aeskey.equals("no aes key")) {
            this.DecryptedData.put(ExchangeDataTypes.AESKEY, "no aes key");
        } else {
            this.DecryptedData.put(ExchangeDataTypes.AESKEY, aeskey);
        }
        logger.debug((Object)("\u4ee5\u8f49\u51fa\u6821XCA\u89e3\u5bc6\u5f8c\u4e4bAES KEY : " + aeskey));
        return aeskey;
    }

    private void generateDecryptedData() {
        String aeskey = this.DecryptedData.get((Object)ExchangeDataTypes.AESKEY);
        logger.debug((Object)("AES KEY : " + aeskey));
        this.DecryptedData.put(ExchangeDataTypes.STUD_NAME, AESUtil.decrypt(this.stud_name, aeskey));
        logger.debug((Object)("Stud Name : " + this.stud_name));
        this.DecryptedData.put(ExchangeDataTypes.STUD_PID, AESUtil.decrypt(this.stud_pid, aeskey));
        this.DecryptedData.put(ExchangeDataTypes.STUD_BIRTHDAY, AESUtil.decrypt(this.stud_birthday, aeskey));
        logger.debug((Object)("Encryption XML : " + this.encryption_xml));
        this.DecryptedData.put(ExchangeDataTypes.XML, AESUtil.decrypt(this.encryption_xml, aeskey));
        String verified = AccessController.doPrivileged(new VerifyFromXCA(this.xcapassword, this.encryption_xml, this.sign_xml));
        logger.debug((Object)("\u9a57\u7c3d : " + verified));
        this.DecryptedData.put(ExchangeDataTypes.VERIFIED, verified);
        this.DecryptedData.put(ExchangeDataTypes.MATCH, String.valueOf(this.checkDataEqual(this.getDecryptedStud_Name(), this.getDecryptedStud_Pid(), this.getDecryptedStud_Birthday())));
        logger.debug((Object)("isMatch : " + this.DecryptedData.get((Object)ExchangeDataTypes.MATCH)));
    }

    private boolean checkDataEqual(String name, String pid, String birthday) {
        logger.debug((Object)("Name : " + name + ":" + this.matchable_name + "\nPID : " + pid + ":" + this.matchable_pid + "\nBirthday : " + birthday + ":" + this.matchable_birthday));
        return name.equals(this.matchable_name) && pid.equals(this.matchable_pid) && birthday.equals(this.matchable_birthday);
    }

    public Map<ExchangeDataTypes, String> getDecryptedData() {
        return this.DecryptedData;
    }

    public String getDecryptedAESLKey() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.AESKEY);
    }

    public String getDecryptedStud_Name() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.STUD_NAME);
    }

    public String getDecryptedStud_Pid() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.STUD_PID);
    }

    public String getDecryptedStud_Birthday() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.STUD_BIRTHDAY);
    }

    public String getDescryptedXML() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.XML);
    }

    public String getMatch() {
        return this.DecryptedData.get((Object)ExchangeDataTypes.MATCH);
    }

    public String getOut_school_id() {
        return this.out_school_id;
    }

    public void setOut_school_id(String out_school_id) {
        this.out_school_id = out_school_id;
    }

    public String getIn_school_id() {
        return this.in_school_id;
    }

    public void setIn_school_id(String in_school_id) {
        this.in_school_id = in_school_id;
    }

    public String getStud_name() {
        return this.stud_name;
    }

    public void setStud_name(String stud_name) {
        this.stud_name = stud_name;
    }

    public String getStud_pid() {
        return this.stud_pid;
    }

    public void setStud_pid(String stud_pid) {
        this.stud_pid = stud_pid;
    }

    public String getStud_birthday() {
        return this.stud_birthday;
    }

    public void setStud_birthday(String stud_birthday) {
        this.stud_birthday = stud_birthday;
    }

    public String getEncryption_key() {
        return this.encryption_key;
    }

    public void setEncryption_key(String encryption_key) {
        this.encryption_key = encryption_key;
    }

    public String getEncryption_xml() {
        return this.encryption_xml;
    }

    public void setEncryption_xml(String encryption_xml) {
        this.encryption_xml = encryption_xml;
    }

    public String getSign_xml() {
        return this.sign_xml;
    }

    public void setSign_xml(String sign_xml) {
        this.sign_xml = sign_xml;
    }

    public String getUpload_time() {
        return this.upload_time;
    }

    public void setUpload_time(String upload_time) {
        this.upload_time = upload_time;
    }

    public String getDownload_time() {
        return this.download_time;
    }

    public void setDownload_time(String download_time) {
        this.download_time = download_time;
    }

    public int getDownload_times() {
        return this.download_times;
    }

    public void setDownload_times(int download_times) {
        this.download_times = download_times;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("out_school_id : ").append(this.out_school_id).append("\n").append("in_school_id : ").append(this.in_school_id).append("\n").append("stud_name : ").append(this.stud_name).append("\n").append("stud_pid : ").append(this.stud_pid).append("\n").append("stud_birthday : ").append(this.stud_birthday).append("\n").append("encryption_key : ").append(this.encryption_key).append("\n").append("encryption_xml : ").append(this.encryption_xml).append("\n").append("upload_time : ").append(this.upload_time).append("\n");
        return sb.toString();
    }
}

