/*
 * Decompiled with CFR 0.152.
 */
package tasks;

import certutil.CertFromXCA;
import certutil.checkCard;
import java.security.AccessController;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import tw.com.chttl.Token;

public class ReadCardTask
extends Task<Map<Integer, X509Certificate>> {
    private static final Logger logger = Logger.getLogger(ReadCardTask.class);

    public Map<Integer, X509Certificate> execute() throws TaskExecutionException {
        HashMap certs = new HashMap();
        X509Certificate xca2 = null;
        X509Certificate xcaencrypt = null;
        int key = AccessController.doPrivileged(new checkCard());
        switch (key) {
            case 2: {
                logger.info((Object)"\u8b80\u53d6\u6191\u8b49\u6210\u529f!");
                xca2 = AccessController.doPrivileged(new CertFromXCA(Token.ID_SIGN));
                certs.put((Object)Token.ID_SIGN, (Object)xca2);
                try {
                    logger.info((Object)("Sign Cert : " + Base64.encodeBase64String(xca2.getEncoded())));
                }
                catch (CertificateEncodingException ex) {
                    logger.error((Object)ex);
                }
                xcaencrypt = AccessController.doPrivileged(new CertFromXCA(Token.ID_ENCRYPT));
                certs.put((Object)Token.ID_ENCRYPT, (Object)xcaencrypt);
                try {
                    logger.info((Object)("Encrypt Cert : " + Base64.encodeBase64String(xcaencrypt.getEncoded())));
                }
                catch (CertificateEncodingException ex) {
                    logger.error((Object)ex);
                }
                break;
            }
            case 0: {
                logger.info((Object)"\u8b80\u5361\u6a5f\u932f\u8aa4");
                break;
            }
            case 1: {
                logger.info((Object)"\u5361\u7247\u4e0d\u5b58\u5728");
                break;
            }
            case 3: {
                logger.info((Object)"\u7a0b\u5f0f\u767c\u751f\u4f8b\u5916\u72c0\u6cc1");
            }
        }
        return certs;
    }
}

