/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import tw.com.chttl.Wrapper;

public class CryptoUtil {
    protected CryptoUtil() {
    }

    public static boolean verify(PublicKey publicKey, byte[] byArray, byte[] byArray2, String string) {
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean verify(X509Certificate x509Certificate, byte[] byArray, byte[] byArray2, String string) {
        return CryptoUtil.verify(x509Certificate.getPublicKey(), byArray, byArray2, string);
    }

    public static boolean verifySHA1(PublicKey publicKey, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verify(publicKey, byArray, byArray2, "SHA1withRSA");
    }

    public static boolean verifySHA1(X509Certificate x509Certificate, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verifySHA1(x509Certificate.getPublicKey(), byArray, byArray2);
    }

    public static boolean verifySHA256(PublicKey publicKey, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verify(publicKey, byArray, byArray2, "SHA256withRSA");
    }

    public static boolean verifySHA256(X509Certificate x509Certificate, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verifySHA256(x509Certificate.getPublicKey(), byArray, byArray2);
    }

    public static boolean verifyMD5(PublicKey publicKey, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verify(publicKey, byArray, byArray2, "MD5withRSA");
    }

    public static boolean verifyMD5(X509Certificate x509Certificate, byte[] byArray, byte[] byArray2) {
        return CryptoUtil.verifyMD5(x509Certificate.getPublicKey(), byArray, byArray2);
    }

    public static byte[] wrap(PublicKey publicKey, Key key) throws InvalidKeyException, IllegalBlockSizeException {
        Wrapper wrapper = new Wrapper(publicKey);
        return wrapper.engineWrap(key);
    }

    public static byte[] wrap(X509Certificate x509Certificate, Key key) throws InvalidKeyException, IllegalBlockSizeException {
        return CryptoUtil.wrap(x509Certificate.getPublicKey(), key);
    }

    public static byte[] wrap(PublicKey publicKey, byte[] byArray) throws IllegalBlockSizeException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        return CryptoUtil.wrap(publicKey, (Key)secretKeySpec);
    }

    public static byte[] wrap(X509Certificate x509Certificate, byte[] byArray) throws IllegalBlockSizeException, InvalidKeyException {
        return CryptoUtil.wrap(x509Certificate.getPublicKey(), byArray);
    }

    public static void main(String[] stringArray) {
        CryptoUtil cryptoUtil = new CryptoUtil();
    }
}

