/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import tw.com.chttl.RevokedRecord;

public class TLCRL {
    Hashtable ht;
    private X509CRL a;

    public TLCRL(byte[] byArray) throws CertificateEncodingException {
        this(new ByteArrayInputStream(byArray));
    }

    public TLCRL(InputStream inputStream) throws CertificateEncodingException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            this.a = (X509CRL)certificateFactory.generateCRL(inputStream);
            Set<? extends X509CRLEntry> set = this.a.getRevokedCertificates();
            Iterator<? extends X509CRLEntry> iterator = set.iterator();
            this.ht = new Hashtable();
            for (int i2 = 0; i2 < set.size(); ++i2) {
                X509CRLEntry x509CRLEntry = iterator.next();
                BigInteger bigInteger = x509CRLEntry.getSerialNumber();
                Date date = x509CRLEntry.getRevocationDate();
                byte[] byArray = x509CRLEntry.getExtensionValue("2.5.29.21");
                int n2 = -1;
                if (byArray != null) {
                    n2 = byArray[4];
                }
                this.ht.put(bigInteger, new RevokedRecord(bigInteger, date, n2));
            }
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("Bad CRL encoding");
        }
    }

    public boolean verify(PublicKey publicKey) throws NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        try {
            this.a.verify(publicKey);
        }
        catch (SignatureException signatureException) {
            return false;
        }
        return true;
    }

    public boolean verify(X509Certificate x509Certificate) throws CertificateEncodingException, CertificateEncodingException, SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        try {
            this.a.verify(x509Certificate.getPublicKey());
        }
        catch (SignatureException signatureException) {
            return false;
        }
        return true;
    }

    public Date getThisUpdate() {
        return this.a.getThisUpdate();
    }

    public Date getNextUpdate() {
        return this.a.getNextUpdate();
    }

    public BigInteger getCRLNumber() {
        byte[] byArray = this.a.getExtensionValue("2.5.29.20");
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return new BigInteger(byArray2);
    }

    public BigInteger getDeltaCRLIndicator() {
        byte[] byArray = this.a.getExtensionValue("2.5.29.27");
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return new BigInteger(byArray2);
    }

    public String getFreshCRLDistributionPoint() {
        byte[] byArray = this.a.getExtensionValue("2.5.29.46");
        if (byArray == null) {
            return null;
        }
        return new String(byArray, 12, byArray.length - 12);
    }

    public RevokedRecord getRevokedRecord(BigInteger bigInteger) {
        return (RevokedRecord)this.ht.get(bigInteger);
    }

    public RevokedRecord[] getRevokedRecords() {
        if (this.ht.size() == 0) {
            return null;
        }
        RevokedRecord[] revokedRecordArray = new RevokedRecord[this.ht.size()];
        this.ht.values().toArray(revokedRecordArray);
        return revokedRecordArray;
    }

    public static void main(String[] stringArray) {
        try {
            TLCRL tLCRL = new TLCRL(new FileInputStream("moica.crl"));
            System.out.println(tLCRL.getCRLNumber());
            System.out.println(tLCRL.getFreshCRLDistributionPoint());
            System.out.println("Record count=" + tLCRL.getRevokedRecords().length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

