/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.GeneralToken;
import tw.com.chttl.TokenException;

public class Token
extends GeneralToken {
    long module = -1L;
    int slotId;
    long session;
    String readerName;
    String manufacturer;
    String serialNumber;
    String label;
    public static int ID_SIGN = 0;
    public static int ID_ENCRYPT = 1;

    static native long initialize();

    static native int[] getTokens(long var0);

    private native long login(long var1, int var3, byte[] var4);

    private native int logout(long var1, long var3);

    private native byte[] decrypt(long var1, long var3, byte[] var5, int var6);

    private native byte[] sign(long var1, long var3, byte[] var5, int var6);

    private native byte[] getCert(long var1, int var3, int var4);

    private native int isTokenPresent(long var1, int var3);

    private native byte[] getTokenInfo(long var1, int var3);

    public String getReaderName() {
        return this.readerName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    static int[] getTokens2(long l2) {
        int[] nArray = Token.getTokens(l2);
        if (nArray.length == 0) {
            nArray = Token.getTokens(l2);
        }
        return nArray;
    }

    Token() {
        this.slotId = -1;
        this.session = -1L;
    }

    Token(int n2) {
        this.slotId = n2;
        this.getTokenInfo(0L, n2);
        this.session = -1L;
    }

    public boolean isTokenPresent() {
        return this.isTokenPresent(this.module, this.slotId) == 0;
    }

    public X509Certificate getCert(int n2) throws CertificateException {
        byte[] byArray = this.getCert(this.session, this.slotId, n2);
        if (byArray == null) {
            return null;
        }
        CertificateFactory certificateFactory = null;
        certificateFactory = CertificateFactory.getInstance("X509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }

    public boolean login(String string) throws TokenException {
        if (this.session != -1L) {
            this.logout();
        }
        this.session = this.login(this.module, this.slotId, string.getBytes());
        return this.session != -1L;
    }

    public boolean logout() {
        if (this.session == -1L) {
            return true;
        }
        if (this.logout(this.module, this.session) == 0) {
            this.session = -1L;
            return true;
        }
        this.session = -1L;
        return false;
    }

    private byte[] a(int n2, byte[] byArray) {
        if (this.session == -1L) {
            return null;
        }
        byte[] byArray2 = this.decrypt(this.module, this.session, byArray, n2);
        if (byArray2.length > 120) {
            return null;
        }
        return byArray2;
    }

    private static byte[] a(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        byte[] byArray2 = null;
        if (string.startsWith("MD5")) {
            messageDigest = MessageDigest.getInstance("MD5");
            byArray2 = MD5_HEADER;
        } else if (string.startsWith("SHA1")) {
            messageDigest = MessageDigest.getInstance("SHA1");
            byArray2 = SHA1_HEADER;
        } else if (string.startsWith("SHA256")) {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byArray2 = SHA256_HEADER;
        } else if (string.startsWith("SHA384")) {
            messageDigest = MessageDigest.getInstance("SHA-384");
            byArray2 = SHA384_HEADER;
        } else if (string.startsWith("SHA512")) {
            messageDigest = MessageDigest.getInstance("SHA-512");
            byArray2 = SHA512_HEADER;
        }
        if (messageDigest == null) {
            throw new NoSuchAlgorithmException("No such algorithm " + string);
        }
        byte[] byArray3 = messageDigest.digest(byArray);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        return byArray4;
    }

    public byte[] signSHA1(int n2, byte[] byArray) {
        if (this.session == -1L) {
            return null;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = Token.a("SHA1", byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[35];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        System.arraycopy(SHA1_HEADER, 0, byArray3, 0, SHA1_HEADER.length);
        byte[] byArray4 = this.sign(this.module, this.session, byArray3, n2);
        if (byArray4 == null) {
            return null;
        }
        try {
            if (CryptoUtil.verifySHA1(this.getCert(n2), byArray, byArray4)) {
                return byArray4;
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public byte[] signSHA256(int n2, byte[] byArray) {
        if (this.session == -1L) {
            return null;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = Token.a("SHA-256", byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[byArray2.length + SHA256_HEADER.length];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        System.arraycopy(SHA256_HEADER, 0, byArray3, 0, SHA1_HEADER.length);
        byte[] byArray4 = this.sign(this.module, this.session, byArray3, n2);
        if (byArray4 == null) {
            return null;
        }
        try {
            if (CryptoUtil.verifySHA256(this.getCert(n2), byArray, byArray4)) {
                return byArray4;
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public byte[] signMD5(int n2, byte[] byArray) {
        if (this.session == -1L) {
            return null;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = Token.a("MD5", byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[34];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        System.arraycopy(MD5_HEADER, 0, byArray3, 0, MD5_HEADER.length);
        byte[] byArray4 = this.sign(this.module, this.session, byArray3, n2);
        if (byArray4 == null) {
            return null;
        }
        try {
            if (CryptoUtil.verifyMD5(this.getCert(n2), byArray, byArray4)) {
                return byArray4;
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public byte[] signRAW(int n2, byte[] byArray) {
        if (this.session == -1L) {
            return null;
        }
        return this.sign(this.module, this.session, byArray, n2);
    }

    public byte[] unwrap(int n2, byte[] byArray) {
        return this.a(n2, byArray);
    }

    public Key unwrap(int n2, byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray2 = this.a(n2, byArray);
        if (byArray2 == null) {
            return null;
        }
        if (string.indexOf("DES") != -1) {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            try {
                if (string.compareToIgnoreCase("DES") == 0) {
                    return secretKeyFactory.generateSecret(new DESKeySpec(byArray2));
                }
                return secretKeyFactory.generateSecret(new DESedeKeySpec(byArray2));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                return null;
            }
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string);
        return secretKeySpec;
    }

    public byte[] sign(int n2, byte[] byArray, String string) throws NoSuchAlgorithmException {
        if (this.session == -1L) {
            return null;
        }
        byte[] byArray2 = null;
        byArray2 = Token.a(string, byArray);
        byte[] byArray3 = this.sign(this.module, this.session, byArray2, n2);
        if (byArray3 == null) {
            return null;
        }
        try {
            if (CryptoUtil.verify(this.getCert(n2), byArray, byArray3, string)) {
                return byArray3;
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }
}

