/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Toolkit;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.DialogListener;
import org.apache.pivot.wtk.DialogStateListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraFrameSkin;

public class TerraDialogSkin
extends TerraFrameSkin
implements DialogListener,
DialogStateListener {
    private static final float GOLDEN_SECTION = 0.382f;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseMove(Container display, int x, int y) {
            return this.isMouseOverOwner(display, x, y);
        }

        public boolean mouseDown(Container display, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Dialog dialog = (Dialog)TerraDialogSkin.this.getComponent();
            if (this.isMouseOverOwner(display, x, y)) {
                Window rootOwner = dialog.getRootOwner();
                rootOwner.moveToFront();
                consumed = true;
                Toolkit.getDefaultToolkit().beep();
            }
            int top = display.getLength() - 1;
            int index = display.indexOf((Component)dialog);
            if (index == top) {
                dialog.requestActive();
            }
            return consumed;
        }

        public boolean mouseUp(Container display, Mouse.Button button, int x, int y) {
            return this.isMouseOverOwner(display, x, y);
        }

        public boolean mouseWheel(Container display, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            return this.isMouseOverOwner(display, x, y);
        }

        private boolean isMouseOverOwner(Container display, int x, int y) {
            Component descendant;
            boolean mouseOverOwner = false;
            Dialog dialog = (Dialog)TerraDialogSkin.this.getComponent();
            if (dialog.isModal() && (descendant = display.getDescendantAt(x, y)) != display) {
                Window window = descendant.getWindow();
                mouseOverOwner = dialog.getOwner() == window;
            }
            return mouseOverOwner;
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        Dialog dialog = (Dialog)component;
        dialog.getDialogStateListeners().add((Object)this);
        this.setShowMaximizeButton(false);
        this.setShowMinimizeButton(false);
    }

    public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
        Dialog dialog = (Dialog)container;
        if (!dialog.isTopMost()) {
            Window rootOwner = dialog.getRootOwner();
            rootOwner.moveToFront();
        }
        return super.mouseDown(container, button, x, y);
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        Dialog dialog = (Dialog)this.getComponent();
        if (keyCode == 10) {
            dialog.close(true);
            consumed = true;
        } else if (keyCode == 27) {
            dialog.close(false);
            consumed = true;
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public void windowOpened(Window window) {
        Window ancestor;
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.reenterMouse();
        if (!window.requestFocus()) {
            Component.clearFocus();
        }
        if ((ancestor = window.getOwner()) == null) {
            ancestor = window.getDisplay();
        }
        Dimensions size = window.getPreferredSize();
        int deltaWidth = ancestor.getWidth() - size.width;
        int deltaHeight = ancestor.getHeight() - size.height;
        int x = Math.max(0, Math.round((float)ancestor.getX() + 0.5f * (float)deltaWidth));
        int y = Math.max(0, Math.round((float)ancestor.getY() + 0.382f * (float)deltaHeight));
        window.setLocation(x, y);
    }

    public void windowClosed(Window window, Display display, Window owner) {
        super.windowClosed(window, display, owner);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
    }

    public void modalChanged(Dialog dialog) {
    }

    public Vote previewDialogClose(Dialog dialog, boolean result) {
        return Vote.APPROVE;
    }

    public void dialogCloseVetoed(Dialog dialog, Vote reason) {
    }

    public void dialogClosed(Dialog dialog, boolean modal) {
    }
}

