/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.LinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraLinkButtonSkin
extends LinkButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;

    public TerraLinkButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(12);
        this.disabledColor = theme.getColor(7);
    }

    public int getPreferredWidth(int height) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredHeight(width);
    }

    public Dimensions getPreferredSize() {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredSize();
    }

    public int getBaseline(int width, int height) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getBaseline(width, height);
    }

    public void paint(Graphics2D graphics) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, this.highlighted);
        dataRenderer.setSize(width, height);
        dataRenderer.paint(graphics);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraLinkButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }
}

