/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.skin.MenuBarItemSkin;

public class TerraMenuBarItemSkin
extends MenuBarItemSkin {
    public void install(Component component) {
        super.install(component);
        MenuBar.Item menuBarItem = (MenuBar.Item)component;
        menuBarItem.setCursor(Cursor.DEFAULT);
    }

    public int getPreferredWidth(int height) {
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuBarItem.getDataRenderer();
        dataRenderer.render(menuBarItem.getButtonData(), (Button)menuBarItem, false);
        return dataRenderer.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuBarItem.getDataRenderer();
        dataRenderer.render(menuBarItem.getButtonData(), (Button)menuBarItem, false);
        return dataRenderer.getPreferredHeight(width);
    }

    public Dimensions getPreferredSize() {
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuBarItem.getDataRenderer();
        dataRenderer.render(menuBarItem.getButtonData(), (Button)menuBarItem, false);
        return dataRenderer.getPreferredSize();
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean highlight = menuBarItem.isActive();
        if (highlight) {
            MenuBar menuBar = (MenuBar)menuBarItem.getParent();
            Color activeBackgroundColor = (Color)menuBar.getStyles().get("activeBackgroundColor");
            graphics.setColor(activeBackgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        Button.DataRenderer dataRenderer = menuBarItem.getDataRenderer();
        dataRenderer.render(menuBarItem.getButtonData(), (Button)menuBarItem, highlight);
        dataRenderer.setSize(width, height);
        dataRenderer.paint(graphics);
    }

    public boolean isOpaque() {
        boolean opaque = false;
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        if (menuBarItem.isActive()) {
            MenuBar menuBar = (MenuBar)menuBarItem.getParent();
            Color activeBackgroundColor = (Color)menuBar.getStyles().get("activeBackgroundColor");
            opaque = activeBackgroundColor.getTransparency() == 1;
        }
        return opaque;
    }

    public Color getPopupBorderColor() {
        return (Color)this.menuPopup.getStyles().get("borderColor");
    }

    public void setPopupBorderColor(Color popupBorderColor) {
        this.menuPopup.getStyles().put("borderColor", (Object)popupBorderColor);
    }

    public void setPopupBorderColor(String popupBorderColor) {
        if (popupBorderColor == null) {
            throw new IllegalArgumentException("popupBorderColor is null.");
        }
        this.menuPopup.getStyles().put("borderColor", (Object)popupBorderColor);
    }
}

