/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.MenuButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuButtonSkin
extends MenuButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private int spacing;
    private float minumumAspectRatio;
    private float maximumAspectRatio;
    private boolean toolbar;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private static final int CORNER_RADIUS = 4;
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        public void windowOpened(Window window) {
            MenuButton menuButton = (MenuButton)TerraMenuButtonSkin.this.getComponent();
            Display display = menuButton.getDisplay();
            Dimensions displaySize = display.getSize();
            Point buttonLocation = menuButton.mapPointToAncestor((Container)display, 0, 0);
            window.setLocation(buttonLocation.x, buttonLocation.y + TerraMenuButtonSkin.this.getHeight() - 1);
            int width = TerraMenuButtonSkin.this.getWidth();
            window.setMinimumWidth(width - 10 - 1);
            int popupWidth = window.getPreferredWidth();
            if (buttonLocation.x + popupWidth > displaySize.width) {
                window.setX(buttonLocation.x + width - popupWidth);
            }
            window.setMaximumHeight(Integer.MAX_VALUE);
            int popupHeight = window.getPreferredHeight();
            int maximumHeight = displaySize.height - window.getY();
            if (popupHeight > maximumHeight && buttonLocation.y > maximumHeight) {
                window.setMaximumHeight(buttonLocation.y);
                window.setY(buttonLocation.y - window.getPreferredHeight() + 1);
            } else {
                window.setMaximumHeight(maximumHeight);
            }
            TerraMenuButtonSkin.this.repaintComponent();
        }

        public void windowClosed(Window window, Display display, Window owner) {
            TerraMenuButtonSkin.this.repaintComponent();
        }
    };
    private static final int TRIGGER_WIDTH = 10;

    public TerraMenuButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(10);
        this.disabledBackgroundColor = theme.getColor(10);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.padding = new Insets(3);
        this.spacing = 0;
        this.minumumAspectRatio = Float.NaN;
        this.maximumAspectRatio = Float.NaN;
        this.toolbar = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        if (height == -1) {
            preferredWidth = this.getPreferredSize().width;
        } else {
            MenuButton menuButton = (MenuButton)this.getComponent();
            Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
            dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
            preferredWidth = dataRenderer.getPreferredWidth(-1) + 10 + this.padding.left + this.padding.right + this.spacing + 2;
            if (!Float.isNaN(this.minumumAspectRatio) && (float)preferredWidth / (float)height < this.minumumAspectRatio) {
                preferredWidth = (int)((float)height * this.minumumAspectRatio);
            }
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        if (width == -1) {
            preferredHeight = this.getPreferredSize().height;
        } else {
            MenuButton menuButton = (MenuButton)this.getComponent();
            Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
            dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
            preferredHeight = dataRenderer.getPreferredHeight(-1) + this.padding.top + this.padding.bottom + 2;
            if (!Float.isNaN(this.maximumAspectRatio) && (float)width / (float)preferredHeight > this.maximumAspectRatio) {
                preferredHeight = (int)((float)width / this.maximumAspectRatio);
            }
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        Dimensions contentSize = dataRenderer.getPreferredSize();
        int preferredWidth = contentSize.width + 10 + this.padding.left + this.padding.right + 2;
        int preferredHeight = contentSize.height + this.padding.top + this.padding.bottom + 2;
        float aspectRatio = (float)preferredWidth / (float)preferredHeight;
        if (!Float.isNaN(this.minumumAspectRatio) && aspectRatio < this.minumumAspectRatio) {
            preferredWidth = (int)((float)preferredHeight * this.minumumAspectRatio);
        }
        if (!Float.isNaN(this.maximumAspectRatio) && aspectRatio > this.maximumAspectRatio) {
            preferredHeight = (int)((float)preferredWidth / this.maximumAspectRatio);
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        int clientWidth = Math.max(width - (10 + this.padding.left + this.padding.right + 2), 0);
        int clientHeight = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
        int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
        if (baseline != -1) {
            baseline += this.padding.top + 1;
        }
        return baseline;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Color colorLocal = null;
        Color backgroundColorLocal = null;
        Color bevelColorLocal = null;
        Color borderColorLocal = null;
        if (!this.toolbar || this.highlighted || menuButton.isFocused() || this.menuPopup.isOpen()) {
            if (menuButton.isEnabled()) {
                colorLocal = this.color;
                backgroundColorLocal = this.backgroundColor;
                bevelColorLocal = this.pressed || this.menuPopup.isOpen() && !this.menuPopup.isClosing() ? this.pressedBevelColor : this.bevelColor;
                borderColorLocal = this.borderColor;
            } else {
                colorLocal = this.disabledColor;
                backgroundColorLocal = this.disabledBackgroundColor;
                bevelColorLocal = this.disabledBevelColor;
                borderColorLocal = this.disabledBorderColor;
            }
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (backgroundColorLocal != null && bevelColorLocal != null) {
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, bevelColorLocal, (float)width / 2.0f, (float)height / 2.0f, backgroundColorLocal));
            graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Bounds contentBounds = new Bounds(this.padding.left + 1, this.padding.top + 1, Math.max(width - (this.padding.left + this.padding.right + this.spacing + 10 + 2), 0), Math.max(height - (this.padding.top + this.padding.bottom + 2), 0));
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, this.highlighted);
        dataRenderer.setSize(contentBounds.width, contentBounds.height);
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(contentBounds.x, contentBounds.y);
        contentGraphics.clipRect(0, 0, contentBounds.width, contentBounds.height);
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (borderColorLocal != null) {
            graphics.setPaint(borderColorLocal);
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        }
        if (menuButton.isFocused() && !this.toolbar) {
            BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics.setStroke(dashStroke);
            graphics.setColor(this.borderColor);
            graphics.draw(new RoundRectangle2D.Double(2.5, 2.5, Math.max(width - 5, 0), Math.max(height - 5, 0), 2.0, 2.0));
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GeneralPath triggerIconShape = new GeneralPath(0);
        triggerIconShape.moveTo(0.0f, 0.0f);
        triggerIconShape.lineTo(3.0f, 3.0f);
        triggerIconShape.lineTo(6.0f, 0.0f);
        triggerIconShape.closePath();
        Graphics2D triggerGraphics = (Graphics2D)graphics.create();
        triggerGraphics.setStroke(new BasicStroke(0.0f));
        triggerGraphics.setPaint(colorLocal);
        Bounds triggerBounds = new Bounds(Math.max(width - (this.padding.right + 10), 0), 0, 10, Math.max(height - (this.padding.top - this.padding.bottom), 0));
        int tx = triggerBounds.x + (triggerBounds.width - triggerIconShape.getBounds().width) / 2;
        int ty = triggerBounds.y + (triggerBounds.height - triggerIconShape.getBounds().height) / 2;
        triggerGraphics.translate(tx, ty);
        triggerGraphics.draw(triggerIconShape);
        triggerGraphics.fill(triggerIconShape);
        triggerGraphics.dispose();
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isOpaque() {
        MenuButton menuButton = (MenuButton)this.getComponent();
        return !this.toolbar || this.highlighted || menuButton.isFocused();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.brighten(backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public final void setDisabledBackgroundColor(int disabledBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(theme.getColor(disabledBackgroundColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.menuPopup.getStyles().put("borderColor", (Object)borderColor);
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public final void setDisabledBorderColor(int disabledBorderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(theme.getColor(disabledBorderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }

    public float getMinimumAspectRatio() {
        return this.minumumAspectRatio;
    }

    public void setMinimumAspectRatio(float minumumAspectRatio) {
        if (!Float.isNaN(this.maximumAspectRatio) && minumumAspectRatio > this.maximumAspectRatio) {
            throw new IllegalArgumentException("minumumAspectRatio is greater than maximumAspectRatio.");
        }
        this.minumumAspectRatio = minumumAspectRatio;
        this.invalidateComponent();
    }

    public final void setMinimumAspectRatio(Number minumumAspectRatio) {
        if (minumumAspectRatio == null) {
            throw new IllegalArgumentException("minumumAspectRatio is null.");
        }
        this.setMinimumAspectRatio(minumumAspectRatio.floatValue());
    }

    public float getMaximumAspectRatio() {
        return this.maximumAspectRatio;
    }

    public void setMaximumAspectRatio(float maximumAspectRatio) {
        if (!Float.isNaN(this.minumumAspectRatio) && maximumAspectRatio < this.minumumAspectRatio) {
            throw new IllegalArgumentException("maximumAspectRatio is less than minimumAspectRatio.");
        }
        this.maximumAspectRatio = maximumAspectRatio;
        this.invalidateComponent();
    }

    public final void setMaximumAspectRatio(Number maximumAspectRatio) {
        if (maximumAspectRatio == null) {
            throw new IllegalArgumentException("maximumAspectRatio is null.");
        }
        this.setMaximumAspectRatio(maximumAspectRatio.floatValue());
    }

    public boolean isToolbar() {
        return this.toolbar;
    }

    public void setToolbar(boolean toolbar) {
        this.toolbar = toolbar;
        if (toolbar && this.getComponent().isFocused()) {
            Component.clearFocus();
        }
        this.repaintComponent();
    }

    public int getCloseTransitionDuration() {
        return (Integer)this.menuPopup.getStyles().get("closeTransitionDuration");
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.menuPopup.getStyles().put("closeTransitionDuration", (Object)closeTransitionDuration);
    }

    public int getCloseTransitionRate() {
        return (Integer)this.menuPopup.getStyles().get("closeTransitionRate");
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.menuPopup.getStyles().put("closeTransitionRate", (Object)closeTransitionRate);
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.toolbar && component.isFocused()) {
            Component.clearFocus();
        }
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        if (!this.toolbar) {
            component.requestFocus();
        }
        return super.mouseClick(component, button, x, y, count);
    }
}

