/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.MenuItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuItemSkin
extends MenuItemSkin {
    private Image checkmarkImage = new CheckmarkImage();
    public static final int EXPANDER_SIZE = 11;
    public static final int EXPANDER_ICON_SIZE = 5;

    public void install(Component component) {
        super.install(component);
        Menu.Item menuItem = (Menu.Item)component;
        menuItem.setCursor(Cursor.DEFAULT);
    }

    public int getPreferredWidth(int height) {
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuItem.getDataRenderer();
        dataRenderer.render(menuItem.getButtonData(), (Button)menuItem, false);
        return dataRenderer.getPreferredWidth(height) + 11;
    }

    public int getPreferredHeight(int width) {
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuItem.getDataRenderer();
        dataRenderer.render(menuItem.getButtonData(), (Button)menuItem, false);
        return Math.max(dataRenderer.getPreferredHeight(width), 11);
    }

    public Dimensions getPreferredSize() {
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = menuItem.getDataRenderer();
        dataRenderer.render(menuItem.getButtonData(), (Button)menuItem, false);
        Dimensions preferredSize = dataRenderer.getPreferredSize();
        return new Dimensions(preferredSize.width + 11, Math.max(preferredSize.height, 11));
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        Menu menu = (Menu)menuItem.getParent();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean highlight = menuItem.isActive();
        if (highlight) {
            Color activeBackgroundColor = (Color)menu.getStyles().get("activeBackgroundColor");
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, TerraTheme.brighten(activeBackgroundColor), (float)width / 2.0f, height, activeBackgroundColor));
            graphics.fillRect(0, 0, width, height);
        }
        Button.DataRenderer dataRenderer = menuItem.getDataRenderer();
        dataRenderer.render(menuItem.getButtonData(), (Button)menuItem, highlight);
        dataRenderer.setSize(Math.max(width - 11, 0), height);
        dataRenderer.paint(graphics);
        if (menuItem.getMenu() != null) {
            Color color = (Color)(highlight ? menu.getStyles().get("activeColor") : menu.getStyles().get("color"));
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.translate(dataRenderer.getWidth() + 3, (height - 5) / 2);
            int[] xPoints = new int[]{0, 5, 0};
            int[] yPoints = new int[]{0, 2, 5};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    public boolean isOpaque() {
        boolean opaque = false;
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        if (menuItem.isActive()) {
            Menu menu = (Menu)menuItem.getParent();
            Color activeBackgroundColor = (Color)menu.getStyles().get("activeBackgroundColor");
            opaque = activeBackgroundColor.getTransparency() == 1;
        }
        return opaque;
    }

    public Image getCheckmarkImage() {
        return this.checkmarkImage;
    }

    public Color getPopupBorderColor() {
        return (Color)this.menuPopup.getStyles().get("borderColor");
    }

    public void setPopupBorderColor(Color popupBorderColor) {
        this.menuPopup.getStyles().put("borderColor", (Object)popupBorderColor);
    }

    public void setPopupBorderColor(String popupBorderColor) {
        if (popupBorderColor == null) {
            throw new IllegalArgumentException("popupBorderColor is null.");
        }
        this.menuPopup.getStyles().put("borderColor", (Object)popupBorderColor);
    }

    public final class CheckmarkImage
    extends Image {
        public static final int SIZE = 14;
        public static final int CHECKMARK_SIZE = 10;

        public int getWidth() {
            return 14;
        }

        public int getHeight() {
            return 14;
        }

        public void paint(Graphics2D graphics) {
            Menu.Item menuItem = (Menu.Item)TerraMenuItemSkin.this.getComponent();
            Menu menu = (Menu)menuItem.getParent();
            Color color = (Color)menu.getStyles().get("color");
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.5f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = 5;
            int m = 2;
            int offsetX = (14 - (n + m)) / 2;
            int offsetY = (14 - n) / 2;
            graphics.drawLine(offsetX, n - m + offsetY, m + offsetX, n + offsetY);
            graphics.drawLine(m + offsetX, n + offsetY, m + n + offsetX, offsetY);
        }
    }
}

