/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Palette;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowClassListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPaletteSkin
extends WindowSkin {
    private Image closeImage = new CloseImage();
    private Image resizeImage = new ResizeImage();
    private TablePane titleBarTablePane = new TablePane();
    private BoxPane titleBoxPane = new BoxPane();
    private BoxPane buttonBoxPane = new BoxPane();
    private Label titleLabel = new Label();
    private LinkButton closeButton = new LinkButton((Object)this.closeImage);
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private DropShadowDecorator dropShadowDecorator = null;
    private Point dragOffset = null;
    private Point resizeOffset = null;
    private float titleFontScale = 0.8f;
    private Insets padding = new Insets(1);
    private WindowClassListener windowClassListener = new WindowClassListener(){

        public void activeWindowChanged(Window previousActiveWindow) {
            Palette palette = (Palette)TerraPaletteSkin.this.getComponent();
            Window owner = palette.getOwner();
            Window activeWindow = Window.getActiveWindow();
            palette.setVisible(activeWindow != null && (owner == activeWindow || owner.isOwner(activeWindow)));
            TerraPaletteSkin.this.invalidateComponent();
        }
    };
    private Color titleBarColor;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color contentBorderColor;
    private Color inactiveTitleBarBackgroundColor;
    private Color inactiveTitleBarBorderColor;
    private Color contentBevelColor;

    public TerraPaletteSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(10));
        this.titleBarColor = theme.getColor(4);
        this.titleBarBackgroundColor = theme.getColor(14);
        this.titleBarBorderColor = theme.getColor(12);
        this.contentBorderColor = theme.getColor(7);
        this.inactiveTitleBarBackgroundColor = theme.getColor(9);
        this.inactiveTitleBarBorderColor = theme.getColor(7);
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row titleRow = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(titleRow);
        titleRow.add((Component)this.titleBoxPane);
        titleRow.add((Component)this.buttonBoxPane);
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        this.titleBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBoxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 3));
        Font titleFont = theme.getFont();
        titleFont = titleFont.deriveFont(1, Math.round(titleFont.getSize2D() * this.titleFontScale));
        this.titleLabel.getStyles().put("font", (Object)titleFont);
        this.titleLabel.getStyles().put("color", (Object)this.titleBarColor);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.buttonBoxPane.add((Component)this.closeButton);
        this.closeButton.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){

            public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
                return true;
            }
        });
        this.closeButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                Palette palette = (Palette)TerraPaletteSkin.this.getComponent();
                palette.close();
            }
        });
    }

    public void install(Component component) {
        super.install(component);
        Palette palette = (Palette)component;
        palette.add((Component)this.titleBarTablePane);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        palette.getDecorators().add((Decorator)this.dropShadowDecorator);
        palette.add((Component)this.resizeHandle);
        this.titleChanged((Window)palette, null);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Palette palette = (Palette)this.getComponent();
        Component content = palette.getContent();
        Dimensions preferredTitleBarSize = this.titleBarTablePane.getPreferredSize();
        preferredWidth = preferredTitleBarSize.width;
        if (content != null) {
            if (height != -1) {
                height = Math.max(height - preferredTitleBarSize.height - 4 - this.padding.top - this.padding.bottom, 0);
            }
            preferredWidth = Math.max(preferredWidth, content.getPreferredWidth(height));
        }
        return preferredWidth += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Palette palette = (Palette)this.getComponent();
        Component content = palette.getContent();
        if (width != -1) {
            width = Math.max(width - 2, 0);
        }
        preferredHeight = this.titleBarTablePane.getPreferredHeight(width);
        if (content != null) {
            if (width != -1) {
                width = Math.max(width - this.padding.left - this.padding.right, 0);
            }
            preferredHeight += content.getPreferredHeight(width);
        }
        return preferredHeight += this.padding.top + this.padding.bottom + 4;
    }

    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        Palette palette = (Palette)this.getComponent();
        Component content = palette.getContent();
        Dimensions preferredTitleBarSize = this.titleBarTablePane.getPreferredSize();
        preferredWidth = preferredTitleBarSize.width;
        preferredHeight = preferredTitleBarSize.height;
        if (content != null) {
            Dimensions preferredContentSize = content.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, preferredContentSize.width);
            preferredHeight += preferredContentSize.height;
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right + 2, preferredHeight += this.padding.top + this.padding.bottom + 4);
    }

    public void layout() {
        Palette palette = (Palette)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int clientX = 1;
        int clientY = 1;
        int clientWidth = Math.max(width - 2, 0);
        int clientHeight = Math.max(height - 2, 0);
        this.titleBarTablePane.setLocation(clientX, clientY);
        this.titleBarTablePane.setSize(clientWidth, this.titleBarTablePane.getPreferredHeight());
        this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
        this.resizeHandle.setLocation(clientWidth - this.resizeHandle.getWidth(), clientHeight - this.resizeHandle.getHeight());
        this.resizeHandle.setVisible(palette.isPreferredWidthSet() || palette.isPreferredHeightSet());
        Component content = palette.getContent();
        if (content != null) {
            content.setLocation(this.padding.left + 1, this.titleBarTablePane.getHeight() + this.padding.top + 3);
            int contentWidth = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
            int contentHeight = Math.max(height - (this.titleBarTablePane.getHeight() + this.padding.top + this.padding.bottom + 4), 0);
            content.setSize(contentWidth, contentHeight);
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        int titleBarHeight = this.titleBarTablePane.getHeight();
        graphics.setStroke(new BasicStroke());
        Palette palette = (Palette)this.getComponent();
        boolean active = palette.getOwner().isActive();
        boolean enabled = palette.isEnabled();
        Color currentTitleBarBackgroundColor = active && enabled ? this.titleBarBackgroundColor : this.inactiveTitleBarBackgroundColor;
        Color currentTitleBarBorderColor = active && enabled ? this.titleBarBorderColor : this.inactiveTitleBarBorderColor;
        Color titleBarBevelColor = TerraTheme.brighten(currentTitleBarBackgroundColor);
        graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, titleBarBevelColor, (float)width / 2.0f, titleBarHeight + 1, currentTitleBarBackgroundColor));
        graphics.fillRect(0, 0, width, titleBarHeight + 1);
        graphics.setPaint(currentTitleBarBorderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)(titleBarHeight + 1));
        Bounds contentAreaRectangle = new Bounds(0, titleBarHeight + 2, width, height - (titleBarHeight + 2));
        graphics.setPaint(this.contentBorderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)contentAreaRectangle.x, (int)contentAreaRectangle.y, (int)contentAreaRectangle.width, (int)contentAreaRectangle.height);
        graphics.setPaint(this.contentBevelColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)(contentAreaRectangle.x + 1), (int)(contentAreaRectangle.y + 1), (int)(contentAreaRectangle.width - 2), (Orientation)Orientation.HORIZONTAL);
    }

    public Bounds getClientArea() {
        int width = this.getWidth();
        int height = this.getHeight();
        int titleBarHeight = this.titleBarTablePane.getHeight();
        return new Bounds(0, titleBarHeight + 2, width, height - (titleBarHeight + 2));
    }

    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
        this.contentBevelColor = TerraTheme.brighten(backgroundColor);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public final void setTitleFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.titleLabel.getStyles().put("font", (Object)TerraPaletteSkin.decodeFont((String)font));
    }

    public final void setTitleFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.titleLabel.getStyles().put("font", (Object)Theme.deriveFont(font));
    }

    public final float getTitleFontScale() {
        return this.titleFontScale;
    }

    public final void setTitleFontScale(float scale) {
        this.titleFontScale = scale;
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        Font titleFont = theme.getFont();
        titleFont = titleFont.deriveFont(1, Math.round(titleFont.getSize2D() * scale));
        this.titleLabel.getStyles().put("font", (Object)titleFont);
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            Palette palette = (Palette)this.getComponent();
            Display display = palette.getDisplay();
            Point location = palette.mapPointToAncestor((Container)display, x, y);
            location = new Point(Math.min(Math.max(location.x, 0), display.getWidth() - 1), Math.min(Math.max(location.y, 0), display.getHeight() - 1));
            if (this.dragOffset != null) {
                palette.setLocation(location.x - this.dragOffset.x, location.y - this.dragOffset.y);
            } else if (this.resizeOffset != null) {
                int preferredWidth = -1;
                int preferredHeight = -1;
                if (palette.isPreferredWidthSet()) {
                    preferredWidth = Math.max(location.x - palette.getX() + this.resizeOffset.x, this.titleBarTablePane.getPreferredWidth(-1) + 2);
                    preferredWidth = Math.min(preferredWidth, palette.getMaximumWidth());
                    preferredWidth = Math.max(preferredWidth, palette.getMinimumWidth());
                }
                if (palette.isPreferredHeightSet()) {
                    preferredHeight = Math.max(location.y - palette.getY() + this.resizeOffset.y, this.titleBarTablePane.getHeight() + this.resizeHandle.getHeight() + 7);
                    preferredHeight = Math.min(preferredHeight, palette.getMaximumHeight());
                    preferredHeight = Math.max(preferredHeight, palette.getMinimumHeight());
                }
                palette.setPreferredSize(preferredWidth, preferredHeight);
            }
        } else {
            Cursor cursor = null;
            if (this.resizeHandle.isVisible() && x > this.resizeHandle.getX() && y > this.resizeHandle.getY()) {
                boolean preferredWidthSet = component.isPreferredWidthSet();
                boolean preferredHeightSet = component.isPreferredHeightSet();
                if (preferredWidthSet && preferredHeightSet) {
                    cursor = Cursor.RESIZE_SOUTH_EAST;
                } else if (preferredWidthSet) {
                    cursor = Cursor.RESIZE_EAST;
                } else if (preferredHeightSet) {
                    cursor = Cursor.RESIZE_SOUTH;
                }
            }
            component.setCursor(cursor);
        }
        return consumed;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        Window window = (Window)this.getComponent();
        boolean maximized = window.isMaximized();
        if (button == Mouse.Button.LEFT && !maximized) {
            Bounds titleBarBounds = this.titleBarTablePane.getBounds();
            if (titleBarBounds.contains(x, y)) {
                this.dragOffset = new Point(x, y);
                Mouse.capture((Component)component);
            } else if (this.resizeHandle.isVisible() && x > this.resizeHandle.getX() && y > this.resizeHandle.getY()) {
                this.resizeOffset = new Point(this.getWidth() - x, this.getHeight() - y);
                Mouse.capture((Component)component);
            }
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            this.dragOffset = null;
            this.resizeOffset = null;
            Mouse.release();
        }
        return consumed;
    }

    public void titleChanged(Window window, String previousTitle) {
        super.titleChanged(window, previousTitle);
        String title = window.getTitle();
        this.titleLabel.setVisible(title != null);
        this.titleLabel.setText(title != null ? title : "");
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Window.getWindowClassListeners().add((Object)this.windowClassListener);
    }

    public void windowClosed(Window window, Display display, Window owner) {
        super.windowClosed(window, display, owner);
        Window.getWindowClassListeners().remove((Object)this.windowClassListener);
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics) {
            graphics.setPaint(new Color(0, 0, 0, 64));
            graphics.fillRect(3, 0, 2, 1);
            graphics.fillRect(0, 3, 2, 1);
            graphics.fillRect(3, 3, 2, 1);
            graphics.setPaint(new Color(TerraPaletteSkin.this.contentBorderColor.getRed(), TerraPaletteSkin.this.contentBorderColor.getGreen(), TerraPaletteSkin.this.contentBorderColor.getBlue(), 64));
            graphics.fillRect(3, 1, 2, 1);
            graphics.fillRect(0, 4, 2, 1);
            graphics.fillRect(3, 4, 2, 1);
        }
    }

    protected class CloseImage
    extends Image {
        protected CloseImage() {
        }

        public int getWidth() {
            return 6;
        }

        public int getHeight() {
            return 6;
        }

        public void paint(Graphics2D graphics) {
            graphics.setPaint(TerraPaletteSkin.this.titleBarColor);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.draw(new Line2D.Double(0.5, 0.5, 5.5, 5.5));
            graphics.draw(new Line2D.Double(0.5, 5.5, 5.5, 0.5));
        }
    }
}

