/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.SplitPane;
import org.apache.pivot.wtk.SplitPaneListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSplitPaneSkin
extends ContainerSkin
implements SplitPaneListener {
    private Splitter splitter = new Splitter();
    private Color splitterHandlePrimaryColor;
    private Color splitterHandleSecondaryColor;
    private int splitterThickness;
    private boolean useShadow;

    public TerraSplitPaneSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.splitterHandlePrimaryColor = theme.getColor(9);
        this.splitterHandleSecondaryColor = theme.getColor(10);
        this.splitterThickness = 6;
        this.useShadow = false;
    }

    public void install(Component component) {
        super.install(component);
        SplitPane splitPane = (SplitPane)component;
        splitPane.getSplitPaneListeners().add((Object)this);
        splitPane.add((Component)this.splitter);
        this.updateSplitterCursor();
    }

    public void setSize(int width, int height) {
        int previousWidth = this.getWidth();
        int previousHeight = this.getHeight();
        super.setSize(width, height);
        SplitPane splitPane = (SplitPane)this.getComponent();
        Orientation orientation = splitPane.getOrientation();
        if (splitPane.getResizeMode() == SplitPane.ResizeMode.PRIMARY_REGION && (previousWidth != width && orientation == Orientation.HORIZONTAL || previousHeight != height && orientation == Orientation.VERTICAL)) {
            SplitPane.Region primaryRegion = splitPane.getPrimaryRegion();
            float splitRatio = splitPane.getSplitRatio();
            if (orientation == Orientation.HORIZONTAL) {
                int splitLocation = (int)(splitRatio * (float)previousWidth);
                if (primaryRegion == SplitPane.Region.BOTTOM_RIGHT) {
                    splitLocation += width - previousWidth;
                }
                splitRatio = (float)this.limitSplitLocation(splitLocation) / (float)width;
            } else {
                int splitLocation = (int)(splitRatio * (float)previousHeight);
                if (primaryRegion == SplitPane.Region.BOTTOM_RIGHT) {
                    splitLocation += height - previousHeight;
                }
                splitRatio = (float)this.limitSplitLocation(splitLocation) / (float)height;
            }
            splitPane.setSplitRatio(splitRatio);
        }
    }

    public int getPreferredWidth(int height) {
        return 0;
    }

    public int getPreferredHeight(int width) {
        return 0;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(0, 0);
    }

    public void layout() {
        int width = this.getWidth();
        int height = this.getHeight();
        SplitPane splitPane = (SplitPane)this.getComponent();
        float splitRatio = splitPane.getSplitRatio();
        Component topLeft = splitPane.getTopLeft();
        Component bottomRight = splitPane.getBottomRight();
        if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
            int splitLocation = this.limitSplitLocation((int)(splitRatio * (float)width));
            int rightStart = splitLocation + this.splitterThickness;
            this.splitter.setLocation(splitLocation, 0);
            this.splitter.setSize(this.splitterThickness, height);
            if (topLeft != null) {
                topLeft.setLocation(0, 0);
                topLeft.setSize(splitLocation, height);
            }
            if (bottomRight != null) {
                bottomRight.setLocation(rightStart, 0);
                bottomRight.setSize(Math.max(width - rightStart, 0), height);
            }
        } else {
            int splitLocation = this.limitSplitLocation((int)(splitRatio * (float)height));
            int bottomStart = splitLocation + this.splitterThickness;
            this.splitter.setLocation(0, splitLocation);
            this.splitter.setSize(width, this.splitterThickness);
            if (topLeft != null) {
                topLeft.setLocation(0, 0);
                topLeft.setSize(width, splitLocation);
            }
            if (bottomRight != null) {
                bottomRight.setLocation(0, bottomStart);
                bottomRight.setSize(width, Math.max(height - bottomStart, 0));
            }
        }
    }

    public Color getSplitterHandlePrimaryColor() {
        return this.splitterHandlePrimaryColor;
    }

    public void setSplitterHandlePrimaryColor(Color splitterHandlePrimaryColor) {
        if (splitterHandlePrimaryColor == null) {
            throw new IllegalArgumentException("splitterHandlePrimaryColor is null.");
        }
        this.splitterHandlePrimaryColor = splitterHandlePrimaryColor;
        this.splitter.repaint();
    }

    public final void setSplitterHandlePrimaryColor(String splitterHandlePrimaryColor) {
        if (splitterHandlePrimaryColor == null) {
            throw new IllegalArgumentException("splitterHandlePrimaryColor is null.");
        }
        this.setSplitterHandlePrimaryColor(GraphicsUtilities.decodeColor((String)splitterHandlePrimaryColor));
    }

    public final void setSplitterHandlePrimaryColor(int splitterHandlePrimaryColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSplitterHandlePrimaryColor(theme.getColor(splitterHandlePrimaryColor));
    }

    public Color getSplitterHandleSecondaryColor() {
        return this.splitterHandleSecondaryColor;
    }

    public void setSplitterHandleSecondaryColor(Color splitterHandleSecondaryColor) {
        if (splitterHandleSecondaryColor == null) {
            throw new IllegalArgumentException("splitterHandleSecondaryColor is null.");
        }
        this.splitterHandleSecondaryColor = splitterHandleSecondaryColor;
        this.splitter.repaint();
    }

    public final void setSplitterHandleSecondaryColor(String splitterHandleSecondaryColor) {
        if (splitterHandleSecondaryColor == null) {
            throw new IllegalArgumentException("splitterHandleSecondaryColor is null.");
        }
        this.setSplitterHandleSecondaryColor(GraphicsUtilities.decodeColor((String)splitterHandleSecondaryColor));
    }

    public final void setSplitterHandleSecondaryColor(int splitterHandleSecondaryColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSplitterHandleSecondaryColor(theme.getColor(splitterHandleSecondaryColor));
    }

    public int getSplitterThickness() {
        return this.splitterThickness;
    }

    public void setSplitterThickness(int splitterThickness) {
        if (splitterThickness < 0) {
            throw new IllegalArgumentException("splitterThickness is negative.");
        }
        this.splitterThickness = splitterThickness;
        this.invalidateComponent();
    }

    public boolean getUseShadow() {
        return this.useShadow;
    }

    public void setUseShadow(boolean useShadow) {
        if (Mouse.getCapturer() == this.getComponent()) {
            throw new IllegalStateException("Cannot set useShadow while the splitter is being dragged.");
        }
        this.useShadow = useShadow;
    }

    public void topLeftChanged(SplitPane splitPane, Component previousTopLeft) {
        this.invalidateComponent();
    }

    public void bottomRightChanged(SplitPane splitPane, Component previousBottomRight) {
        this.invalidateComponent();
    }

    public void orientationChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
        this.invalidateComponent();
    }

    public void primaryRegionChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
    }

    public void splitRatioChanged(SplitPane splitPane, float previousSplitLocation) {
        this.invalidateComponent();
    }

    public void lockedChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
    }

    public void resizeModeChanged(SplitPane splitPane, SplitPane.ResizeMode previousResizeMode) {
    }

    private void updateSplitterCursor() {
        Cursor cursor = Cursor.DEFAULT;
        SplitPane splitPane = (SplitPane)this.getComponent();
        if (!splitPane.isLocked()) {
            block0 : switch (splitPane.getOrientation()) {
                case HORIZONTAL: {
                    switch (splitPane.getPrimaryRegion()) {
                        case TOP_LEFT: {
                            cursor = Cursor.RESIZE_EAST;
                            break block0;
                        }
                        case BOTTOM_RIGHT: {
                            cursor = Cursor.RESIZE_WEST;
                            break block0;
                        }
                    }
                    break;
                }
                case VERTICAL: {
                    switch (splitPane.getPrimaryRegion()) {
                        case TOP_LEFT: {
                            cursor = Cursor.RESIZE_SOUTH;
                            break block0;
                        }
                        case BOTTOM_RIGHT: {
                            cursor = Cursor.RESIZE_NORTH;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        this.splitter.setCursor(cursor);
    }

    private int limitSplitLocation(int splitLocation) {
        int upper;
        int lower;
        SplitPane splitPane = (SplitPane)this.getComponent();
        Component topLeft = splitPane.getTopLeft();
        Component bottomRight = splitPane.getBottomRight();
        if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
            int rightLimit;
            int leftLimit;
            lower = 0;
            upper = Math.max(this.getWidth() - this.splitterThickness, 0);
            if (topLeft != null && (leftLimit = topLeft.getMinimumWidth()) >= 0) {
                lower = Math.min(leftLimit, upper);
            }
            if (bottomRight != null && (rightLimit = bottomRight.getMinimumWidth()) >= 0) {
                upper = Math.max(upper - rightLimit, lower);
            }
        } else {
            int bottomLimit;
            int topLimit;
            lower = 0;
            upper = Math.max(this.getHeight() - this.splitterThickness, 0);
            if (topLeft != null && (topLimit = topLeft.getMinimumHeight()) >= 0) {
                lower = Math.min(topLimit, upper);
            }
            if (bottomRight != null && (bottomLimit = bottomRight.getMinimumHeight()) >= 0) {
                upper = Math.max(upper - bottomLimit, lower);
            }
        }
        if (splitLocation < lower) {
            return lower;
        }
        if (splitLocation > upper) {
            return upper;
        }
        return splitLocation;
    }

    protected class SplitterShadowSkin
    extends ComponentSkin {
        protected SplitterShadowSkin() {
        }

        public int getPreferredWidth(int height) {
            return 0;
        }

        public int getPreferredHeight(int width) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            graphics.setPaint(new Color(0, 0, 0, 64));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected class SplitterShadow
    extends Component {
        public SplitterShadow() {
            this.setSkin((Skin)new SplitterShadowSkin());
        }
    }

    protected class SplitterSkin
    extends ComponentSkin {
        private int dragOffset;
        private SplitterShadow shadow = null;

        protected SplitterSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int height) {
            return 0;
        }

        public int getPreferredHeight(int width) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            int imageHeight;
            int imageWidth;
            SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
            Orientation orientation = splitPane.getOrientation();
            int width = this.getWidth();
            int height = this.getHeight();
            if (orientation == Orientation.HORIZONTAL) {
                imageWidth = width - 4;
                imageHeight = Math.min(height - 4, 8);
            } else {
                imageWidth = Math.min(width - 4, 8);
                imageHeight = height - 4;
            }
            if (imageWidth > 0 && imageHeight > 0) {
                int translateX = (width - imageWidth) / 2;
                int translateY = (height - imageHeight) / 2;
                graphics.translate(translateX, translateY);
                Color dark = TerraSplitPaneSkin.this.splitterHandlePrimaryColor;
                Color light = TerraSplitPaneSkin.this.splitterHandleSecondaryColor;
                if (orientation == Orientation.HORIZONTAL) {
                    graphics.setStroke(new BasicStroke());
                    graphics.setPaint(dark);
                    graphics.drawLine(0, 0, imageWidth - 1, 0);
                    graphics.drawLine(0, 3, imageWidth - 1, 3);
                    graphics.drawLine(0, 6, imageWidth - 1, 6);
                    graphics.setPaint(light);
                    graphics.drawLine(0, 1, imageWidth - 1, 1);
                    graphics.drawLine(0, 4, imageWidth - 1, 4);
                    graphics.drawLine(0, 7, imageWidth - 1, 7);
                } else {
                    int half = imageHeight / 2;
                    graphics.setPaint(dark);
                    graphics.fillRect(0, 0, 2, half);
                    graphics.fillRect(3, 0, 2, half);
                    graphics.fillRect(6, 0, 2, half);
                    graphics.setPaint(light);
                    graphics.fillRect(0, half, 2, half);
                    graphics.fillRect(3, half, 2, half);
                    graphics.fillRect(6, half, 2, half);
                }
            }
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if (Mouse.getCapturer() == component) {
                float splitRatio;
                int splitLocation;
                SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
                Orientation orientation = splitPane.getOrientation();
                if (orientation == Orientation.HORIZONTAL) {
                    splitLocation = TerraSplitPaneSkin.this.limitSplitLocation(component.getX() + x - this.dragOffset);
                    splitRatio = (float)splitLocation / (float)splitPane.getWidth();
                } else {
                    splitLocation = TerraSplitPaneSkin.this.limitSplitLocation(component.getY() + y - this.dragOffset);
                    splitRatio = (float)splitLocation / (float)splitPane.getHeight();
                }
                if (this.shadow == null) {
                    splitPane.setSplitRatio(splitRatio);
                } else if (orientation == Orientation.HORIZONTAL) {
                    this.shadow.setLocation(splitLocation, 0);
                } else {
                    this.shadow.setLocation(0, splitLocation);
                }
            }
            return consumed;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
            if (button == Mouse.Button.LEFT && !splitPane.isLocked()) {
                Orientation orientation = splitPane.getOrientation();
                if (TerraSplitPaneSkin.this.useShadow) {
                    this.shadow = new SplitterShadow();
                    splitPane.add((Component)this.shadow);
                    if (orientation == Orientation.HORIZONTAL) {
                        this.shadow.setLocation(component.getX(), 0);
                    } else {
                        this.shadow.setLocation(0, component.getY());
                    }
                    this.shadow.setSize(this.getWidth(), this.getHeight());
                }
                this.dragOffset = orientation == Orientation.HORIZONTAL ? x : y;
                Mouse.capture((Component)component);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT && Mouse.getCapturer() == component) {
                if (this.shadow != null) {
                    float splitRatio;
                    SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
                    if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
                        int splitLocation = this.shadow.getX();
                        splitRatio = (float)splitLocation / (float)splitPane.getWidth();
                    } else {
                        int splitLocation = this.shadow.getY();
                        splitRatio = (float)splitLocation / (float)splitPane.getHeight();
                    }
                    splitPane.setSplitRatio(splitRatio);
                    splitPane.remove((Component)this.shadow);
                    this.shadow = null;
                }
                Mouse.release();
            }
            return consumed;
        }
    }

    protected class Splitter
    extends Component {
        public Splitter() {
            this.setSkin((Skin)new SplitterSkin());
        }
    }
}

