/*
 * Decompiled with CFR 0.152.
 */
package controller;

import app.NewFXMain;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.tasks.CheckCardTask;
import utils.tasks.SignValueTask;

public class FXXCAUIController
implements Initializable {
    @FXML
    private Parent root;
    @FXML
    private ProgressIndicator pbLogin;
    @FXML
    private PasswordField tfPin;
    @FXML
    private Button btnCheckReg;
    @FXML
    private Button btnVerify;
    private String webparams;
    private Stage stage;
    private static final Logger logger = Logger.getLogger(FXXCAUIController.class);

    public void initialize(URL url, ResourceBundle rb) {
        this.pbLogin.setVisible(false);
        this.btnVerify.setDisable(true);
        this.tfPin.setEditable(false);
    }

    public Parent getRoot() {
        return this.root;
    }

    public void setRoot(Parent root) {
        this.root = root;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public String getWebparams() {
        return this.webparams;
    }

    public void setWebparams(String webparams) {
        this.webparams = webparams;
    }

    @FXML
    private void doCheckReg(ActionEvent event) throws InterruptedException {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbLogin.setProgress(-1.0);
        final CheckCardTask task = new CheckCardTask("XCA");
        task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUIController.this.pbLogin.setVisible(true);
                FXXCAUIController.this.btnCheckReg.setDisable(true);
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAUIController.this.pbLogin.setVisible(false);
                MESSAGE isExist = (MESSAGE)((Object)task.getValue());
                if (isExist == MESSAGE.CERT_CHECK_SUCCESS) {
                    FXXCAUIController.this.btnVerify.setDisable(false);
                    FXXCAUIController.this.tfPin.setEditable(true);
                    FXXCAUIController.this.btnCheckReg.setDisable(true);
                    FXXCAUIController.this.webparams = task.getCardnumber();
                    logger.debug((Object)("\u5361\u865f:" + FXXCAUIController.this.webparams));
                }
                FXXCAUIController.this.showMsg(TCCertUtil.getMessage(isExist), "\u6191\u8b49\u6aa2\u67e5\u7d50\u679c", 0x4000000);
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }

    private void showMsg(String message, String title, int msgicon) {
        MessageBox.show((Window)this.stage, (String)message, (String)title, (int)msgicon);
    }

    @FXML
    private void doVerify(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbLogin.setProgress(-1.0);
        logger.debug((Object)("\u8f38\u5165\u7684PIN\u78bc\u662f:\n" + this.tfPin.getText()));
        try {
            logger.debug((Object)("webparams:" + this.webparams));
            final String base64params = Base64.encodeBase64String(this.webparams.getBytes("UTF-8"));
            final SignValueTask task = new SignValueTask(base64params, this.tfPin.getText());
            task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent t) {
                    FXXCAUIController.this.pbLogin.setVisible(true);
                }
            });
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent t) {
                    FXXCAUIController.this.pbLogin.setVisible(false);
                    String result = (String)task.getValue();
                    FXXCAUIController.this.btnVerify.setDisable(false);
                    if (result.equals("PIN\u78bc\u932f\u8aa4")) {
                        FXXCAUIController.this.showMsg(result, "\u6191\u8b49\u7c3d\u7ae0\u7d50\u679c", 0x2000000);
                    } else {
                        JSONObject jsonstring = new JSONObject();
                        try {
                            jsonstring.put("ori", (Object)base64params);
                            jsonstring.put("signed", (Object)result);
                        }
                        catch (JSONException ex) {
                            logger.debug((Object)ex.getMessage());
                        }
                        logger.debug((Object)("\u56de\u50b3\u7d50\u679c:\n" + jsonstring.toString()));
                        String post = "setForm('" + StringEscapeUtils.unescapeEcmaScript((String)jsonstring.toString()) + "')";
                        logger.debug((Object)("\u547c\u53eb\u7684JS:\n" + post));
                        NewFXMain.getInstance().testJS(post);
                    }
                }
            });
            new Thread((Runnable)((Object)task)).start();
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex.getMessage());
        }
    }
}

