/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Wrapper {
    private BigInteger if;
    private BigInteger a;

    Wrapper(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Should be RSA Public key");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        this.if = rSAPublicKey.getModulus();
        this.a = rSAPublicKey.getPublicExponent();
    }

    byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String string = key.getFormat();
        if (string == null || !string.equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format on key!");
        }
        byte[] byArray = key.getEncoded();
        try {
            int n2;
            byte[] byArray2 = new byte[this.engineGetOutputSize(byArray.length)];
            try {
                n2 = this.engineDoFinal(byArray, 0, byArray.length, byArray2, 0);
                if (n2 == byArray2.length) {
                    return byArray2;
                }
            }
            catch (ShortBufferException shortBufferException) {
                throw new RuntimeException("PANIC: Should not happned!");
            }
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            return byArray3;
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    protected final int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n5;
        if (byArray2.length < this.engineGetOutputSize(n3)) {
            throw new ShortBufferException();
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        BigInteger bigInteger = new BigInteger(1, this.a(byArray3, byArray3.length, 0, 2));
        if (bigInteger.compareTo(this.if) != -1) {
            throw new RuntimeException("TT");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.a, this.if);
        if (bigInteger2.compareTo(this.if) != -1) {
            throw new RuntimeException("TT");
        }
        int n6 = this.engineGetBlockSize();
        byte[] byArray4 = bigInteger2.toByteArray();
        if (byArray4.length - 1 > n6) {
            throw new RuntimeException("YY");
        }
        if (byArray4.length > n6) {
            byte[] byArray5 = new byte[n6];
            System.arraycopy(byArray4, 1, byArray5, 0, n6);
            byArray4 = byArray5;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            byArray2[n4 + n5] = 0;
        }
        n5 = n6 - byArray4.length;
        System.arraycopy(byArray4, 0, byArray2, n4 + n5, byArray4.length);
        return byArray4.length + n5;
    }

    protected final int engineGetBlockSize() {
        return (this.if.bitLength() + 7) / 8;
    }

    protected final int engineGetOutputSize(int n2) {
        return n2 < this.engineGetBlockSize() + 1 ? this.engineGetBlockSize() + 1 : n2;
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) throws BadPaddingException {
        int n5 = (this.if.bitLength() + 7) / 8;
        if (n2 > n5 - 11) {
            throw new BadPaddingException("Data too long for this modulus!");
        }
        byte[] byArray2 = new byte[n5];
        int n6 = n5 - 3 - n2;
        byArray2[2 + n6] = 0;
        byArray2[0] = 0;
        switch (n4) {
            case 2: {
                byArray2[1] = 2;
                byte[] byArray3 = new byte[1];
                SecureRandom secureRandom = new SecureRandom();
                for (int i2 = 2; i2 < 2 + n6; ++i2) {
                    byArray3[0] = 0;
                    while (byArray3[0] == 0) {
                        secureRandom.nextBytes(byArray3);
                    }
                    byArray2[i2] = byArray3[0];
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        System.arraycopy(byArray, n3, byArray2, n6 + 3, n2);
        return byArray2;
    }
}

