<?php
/*
 = General functions used by the LuxCal view scripts =

This file is part of the LuxCal Web Calendar.
Copyright 2009-2020 LuxSoft - www.LuxSoft.eu
License https://www.gnu.org/licenses/gpl.html GPL version 3

The LuxCal Web Calendar is distributed WITHOUT ANY WARRANTY.
*/

/* week and day functions used by Day and Week view scripts */

//sanity check
if (empty($lcV)) { exit('not permitted ('.substr(basename(__FILE__),0,-4).')'); } //launch via script only

function showDayEvents($date) {
	global $evtList, $set, $eDetails, $xx;

	$thsM = ($set['dwStartHour'] * 60); //threshold start of day in mins
	$theM = ($set['dwEndHour'] * 60); //threshold end of day in mins
	$offset = $set['dwStartHour'] ? 2 * $set['dwTimeSlot'] : $set['dwTimeSlot']; //"earlier" row
	//hereafter: M = in nbr of mins
	foreach ($evtList[$date] as $evt) {
		if ($evt['mde']) { //multi-day-event
			if ($evt['mde'] != 1) { $evt['sti'] = '00:00'; } //not the first day
			if ($evt['mde'] != 3) { $evt['eti'] = '23:59'; } //not the last day
		}
		if (($evt['sti'] == '' and $evt['eti'] == '') or $evt['ald']) { //all day (takes up 1 slot at the top)
			$st[] = 0; //start time
			$et[] = $set['dwTimeSlot']; //end time
		} else {
			$stM = substr($evt['sti'],0,2) * 60 + intval(substr($evt['sti'],3,2)); //start time
			if ($stM < $thsM) {
				$st[] = $set['dwTimeSlot']; //start time < threshold start of day in mins
			} elseif ($stM < $theM) {
				$st[] = $stM - $thsM + $offset; //start time < threshold end of day in mins
			} else {
				$st[] = $theM - $thsM + $offset; //start time >= threshold end of day in mins
			}
			if ($evt['eti'] == "" or $evt['eti'] == $evt['sti']) {
				$et[] = end($st) + $set['dwTimeSlot'];
			} else {
				$etM = substr($evt['eti'],0,2) * 60 + intval(substr($evt['eti'],3,2)); //end time in mins
				if ($etM <= $thsM) {
					$et[] = $offset; //end time <= threshold start of day in mins
				} elseif ($etM <= $theM) {
					$et[] = $etM - $thsM + $offset; //end time < threshold end of day in mins
				} else {
					$et[] = $theM - $thsM + $offset + $set['dwTimeSlot']; //end time > threshold end of day in mins
				}
			}
		}
	}
	//for day $date we now have:
	//$st: array with start time in mins for each event
	//$et: array with end time in mins for each event
	//the indexes in these arrays correspond to the indexes in $evtList
	$sEmpty[0][0] = 0;
	$eEmpty[0][0] = 1440; //24 x 60 mins
	$indent = 0;
	$column = array(); //array with column number of each event
	foreach ($st as $i => $stM) { //i: index in $evtList, stM: start time in mins
		$found = false;
		foreach ($sEmpty as $c => $ses) { //c: column nr, ses: start of empty spaces in mins
			foreach ($ses as $k => $sEtM) {
				if ($stM >= $sEtM and $et[$i] <= $eEmpty[$c][$k]) {
					$sEmpty[$c][] = $et[$i]; //end time in mins
					$eEmpty[$c][] = $eEmpty[$c][$k];
					$eEmpty[$c][$k] = $stM; //start in mins
					$sFill[$c][] = $stM;
					$eIndx[$c][] = $i;
					$column[$i] = $c;
					$found = true;
					break 2;
				}
			}
		}
		if (!$found) {
			$indent++;
			$sEmpty[$indent][0] = 0;
			$eEmpty[$indent][0] = $stM;
			$sEmpty[$indent][1] = $et[$i];
			$eEmpty[$indent][1] = 1440; //24 x 60
			$sFill[$indent][0] = $stM;
			$eIndx[$indent][0] = $i;
			$column[$i] = $indent;
		}
	}
	$cWidth = round(95 / ($indent+1),1); //width of smallest column
	foreach ($sFill as $c => $v) { //c: column nr
		$eLeft = $cWidth * $c + 0.5; //event left side in %
		foreach ($v as $k => $stM) { //event start time in mins
			$etM = $sEmpty[$c][$k + 1]; //event end time in mins
			$eHeight = $etM - $stM; //event height in mins
			$stP = round($stM * $set['dwTsHeight'] / $set['dwTimeSlot']) - 1; //scale start time in px
			$eHeight = round($eHeight * $set['dwTsHeight'] / $set['dwTimeSlot']) - 1; //scale height in px
			$i = $eIndx[$c][$k];
			$evt = $evtList[$date][$i];
			$sti = ($evt['sti']) ? ITtoDT($evt['sti']) : '';
			//widen event box if possible
			$ovlCol = $indent+1;
			foreach ($column as $iCol => $colNr) { //find next column of overlapping event
				$evtT = $evtList[$date][$iCol];
				if ($evtT['sti'] < $evt['eti'] and $evtT['eti'] > $evt['sti']) { //overlap
					if ($colNr > $column[$i] and $colNr < $ovlCol) { //column nr lower
						$ovlCol = $colNr;
					}
				}
			}
			$eWidth = ($ovlCol-$c) * $cWidth - 0.5;
			$toAppr = ($evt['app'] and !$evt['apd']) ? ' toAppr' : '';
			$popAttr = makePopAttrib($evt,$date);
			$eStyle = colorStyle($evt,'#FFFFFF'); //get event colors
			$chBox = $evt['cbx'] ? checkBox($evt,$date) : '';
			$class = ($eHeight < 21 ? 'dwEventNw' : 'dwEvent').(($eDetails or $evt['mayE']) ? ' point' : ' arrow');
			$onClick = ($eDetails or $evt['mayE']) ? " onclick=\"".($evt['mayE'] ? 'editE' : 'showE')."({$evt['eid']},'{$date}');\"" : '';
			$title = $evt['mayE'] ? $xx['vws_edit_event'] : ($eDetails ? $xx['vws_see_event'] : '');
			echo "<div class='evtBox evtTitle{$toAppr}' style='top:{$stP}px; left:{$eLeft}%; height:{$eHeight}px; width:{$eWidth}%; {$eStyle}'>\n";
			$event = makeHead($evt,$set['evtHeadW'],$date);
			if ($eHeight < 21) { $event = str_replace("<br>",' ',$event); }
			echo "<div class='{$class}'{$popAttr}{$onClick} title=\"{$title}\">{$chBox}{$event}</div>\n";
			echo "</div>\n";
		}
	}
}

function showHours() {
	global $set, $xx;
	//build day
	$tsHeight = $set['dwTsHeight'] -1;
	echo "<div class='timeFrame'>\n";
	echo "<div class='times' style='height:{$tsHeight}px;'>{$xx['vws_all_day']}</div>\n";
	$i = $set['dwStartHour'];
	$j = 0;
	if ($set['dwStartHour']) {
		echo "<div class='times' style='height:{$tsHeight}px;'>{$xx['vws_earlier']}</div>\n";
	}
	while ($i < $set['dwEndHour']) {
		echo "<div class='times' style='height:{$tsHeight}px;'>".ITtoDT(str_pad($i,2,"0",STR_PAD_LEFT).":".str_pad($j,2,"0",STR_PAD_LEFT))."</div>\n";
		if (($j += $set['dwTimeSlot']) >= 60) {
			$i++;
			$j -= 60;
		}
	}
	if ($set['dwEndHour'] < 24) {
		echo "<div class='times' style='height:{$tsHeight}px;'>{$xx['vws_later']}</div>\n";
	}
	echo "</div>\n";
}

function showDay($cDate,$caption="") {
	global $set, $evtList;

	//build day
	$tsHeight = $set['dwTsHeight'] -1;
	echo "<div class='timeFrame'>\n";
	echo "<var style='height:{$tsHeight}px;' id='a00:00:{$cDate}'></var>\n";
	$i = $set['dwStartHour'];
	$j = 0;
	if ($set['dwStartHour']) {
		echo "<var style='height:{$tsHeight}px;' id='t00:30:{$cDate}'></var>\n";
	}
	while ($i < $set['dwEndHour']) {
		echo "<var style='height:{$tsHeight}px;' id='t".str_pad($i,2,"0",STR_PAD_LEFT).":".str_pad($j,2,"0",STR_PAD_LEFT).":{$cDate}'></var>\n";
		if (($j += $set['dwTimeSlot']) >= 60) {
			$i++;
			$j -= 60;
		}
	}
	if ($set['dwEndHour'] < 24) {
		echo "<var style='height:{$tsHeight}px;' id='t".str_pad($i,2,"0",STR_PAD_LEFT).":".str_pad($j,2,"0",STR_PAD_LEFT).":{$cDate}'></var>\n";
	}
	echo "<div class=dates>\n";
	if (!empty($evtList[$cDate])) { showDayEvents($cDate); }
	echo "</div>";
	echo "</div>\n";
}


/* Side Panel functions used by Month, Week and Day view scripts */

function showMiniCal($tslotD,$mode) {
	global $set, $xx, $wkDays_s, $evtList;
	
	//compute dates
	$offM = isset($_GET['oM']) ? $_GET['oM'] : 0; //offset Month
	$timeD1 = mktime(12,0,0,date('n',$tslotD)+$offM,1,date('Y',$tslotD)); //time 1st day
	$dateD1 = date("Y-m-d", $timeD1); //date 1st day
	$curM = date("n",$timeD1);
	$curY = date("Y",$timeD1);
	$sOffset = ($set['weekStart']) ? date("N", $timeD1) - 1 : date("w", $timeD1); //offset first day
	$eOffset = date("t", $timeD1) + $sOffset; //offset last day
	$daysToShow = ($eOffset == 28) ? 28 : (($eOffset > 35) ? 42 : 35); //4, 5 or 6 weeks
	$sDate = date("Y-m-d", $timeD1 - ($sOffset * 86400)); //start date in 1st week
	$eDate = date("Y-m-d", $timeD1 + ($daysToShow - $sOffset - 1) * 86400); //end date in last week
	retrieve($sDate,$eDate,'guc'); //retrieve events

	/* display header */
	$arrowL = "<a class='arrowLink' href='".htmlentities($_SERVER['PHP_SELF']).'?oM='.($offM-1)."' title='{$xx['vws_prev_month']}'>&#9664;</a>\n";
	$arrowR = "<a class='arrowLink' href='".htmlentities($_SERVER['PHP_SELF']).'?oM='.($offM+1)."' title='{$xx['vws_next_month']}'>&#9654;</a>\n";
	echo "<h6 class='floatC'>{$arrowL}".makeD($dateD1,3)."{$arrowR}</h6>\n";

	/* display month */
	$days = ($mode and $mode[0] == 'w') ? $set['workWeekDays'] : '1234567'; //set days to show
	$cWidth = round(98 / strlen($days),1).'%';
	echo "<table class='grid'>
<col span='".strlen($days)."' class='dCol' style='width:{$cWidth}'>
<tr>\n";
	for ($i = 0; $i < 7; $i++) {
		$cTime = mktime(12,0,0,$curM,$i-$sOffset+1,$curY ); //current time
		if (strpos($days,date("N",$cTime)) !== false) { echo "<th>{$wkDays_s[$set['weekStart'] + $i]}</th>"; } //week days
	}
	echo "</tr>\n";
	for ($i = 0; $i < $daysToShow; $i++) {
		$cTime = mktime(12,0,0,$curM,$i-$sOffset+1,$curY ); //current time
		$cDate = date("Y-m-d", $cTime);
		if ($i%7 == 0) { //new week
			echo "<tr class='yearWeek'>\n";
		}
		$dayNr = date("N", $cTime);
		if (strpos($days,$dayNr) !== false) {
			$dow = ($i < $sOffset or $i >= $eOffset) ? 'out' : (($dayNr > 5) ? 'we0' : 'wd0');
			if ($cDate == date("Y-m-d")) { $dow .= ' today'; }
			$day = ltrim(substr($cDate, 8, 2),"0");
			echo "<td class='{$dow}'>\n<div class='dom'>{$day}</div>\n";
			if (!empty($evtList[$cDate])) {
				foreach ($evtList[$cDate] as $evt) { //show events for this date
					$popAttr = makePopAttrib($evt,$cDate);
					$bgColor = $evt['cbg'] ? " style=\"background-color:{$evt['cbg']};\"" : '';
					$class = $evt['sym'] ? ' symbol' : ' square';
					echo "<span class='arrow {$class}'{$bgColor}{$popAttr}>{$evt['sym']}</span>\n";
				}
			}
			echo "</td>\n";
		}
		if ($i%7 == 6) { echo "</tr>\n"; } //if last day of week, wrap to left
	}
	echo "<tr>\n<th class='smallHt' colspan='7'>";
	if ($offM != 0) { echo "<a class='floatC' href='".htmlentities($_SERVER['PHP_SELF'])."?oM=0' title=\"{$xx['vws_back_to_main_cal']}\">{$xx['back']}</a>"; }
	echo "</th>\n</tr>\n</table>\n";
}

function showSidePanel($tcDate) {
	global $set, $mode;
	
	echo "<div class='sPanel'>\n";
	if ($set['spMiniCal']) {
		echo "<div class='spCal'>\n";
		showMiniCal($tcDate,$mode); //this month
		echo "</div>\n";
	}
	if ($set['spImages']) {
		$files = scandir('sidepanel'); //get files from sidepanel folder
		foreach($files as $fName) {
			if (strlen($fName) > 5 and substr($fName,0,2) == date('m',$tcDate) and stripos('~.jpg.gif.png',substr($fName,-4)) ) {
				echo "<div class='spImg'>\n<img class='spImage' src='sidepanel/{$fName}' alt='decoration'>\n</div>\n";
				break;
			}
		}
	}
	if ($set['spInfoArea'] and is_file('sidepanel/info.txt')) {
		$info = file_get_contents('sidepanel/info.txt');
		if (preg_match_all('%^\s*~(?:(0?[1-9]|1[0-2])(?:\s*-\s*(0?[1-9]|1[0-2]))?)~([^~]+)%m',$info,$matches,PREG_SET_ORDER)) {
			$spInfo = '';
			$cD = date('n',$tcDate); //month number
			foreach($matches as $match) {
				if ($cD == ltrim($match[1],'0') or ($match[2] and ($cD >= ltrim($match[1],'0') and $cD <= ltrim($match[2],'0')))) {
					$spInfo .= trim($match[3]).'<br><br>';
				}
			}
			if ($spInfo) {
				echo "<div class='spMsg'>\n".substr($spInfo,0,-8)."\n</div>\n";
			}
		}
	}
	echo "</div>\n";
}
?>
