<?php
/* ============= Cron Relay - by LuxSoft =============

 When started via a cronjob, this script will subsequently . . . 
 - start the "SCRIPTS TO BE RUN VIA CRON"
 - send a confirmation email to the recipient's mail address 
 - log the result in the cron.log file.
*/

/*============== CONFIGURATION SECTION ==============*/

//----- SPECIFY BOTH EMAIL ADDRESSES -----
$from = "from.name@gmail.com"; //reply to
$to = "to.name@yourmail.com"; //recipient

//------------ YOUR TIME ZONE ------------
$timeZone = "Europe/Paris"; //your timezone (look here: https://www.php.net/manual/en/timezones.php)

//------ SCRIPTS TO BE RUN VIA CRON ------
$scripts = array (
"https://www.yourcal1.xxx/lcalcron.php",
"https://www.yourcal2.yyy/lcalcron.php",
);

//--------------- GENERAL ----------------
$sndMail = 1; //send confirmation email (0:no, 1:yes)
$logCron = 1; //log cron results to cron.log (0:no, 1:yes)

/*========== END OF CONFIGURATION SECTION ===========*/

date_default_timezone_set($timeZone);
$datetime = date("Y-m-d H:i");

//if PHP CURL extension enabled run specified scripts
if (extension_loaded('curl')) {
	$cron = "Scripts started:\n";
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_HEADER, 0);
	foreach ($scripts as $k  => $script) {
		curl_setopt($ch,CURLOPT_URL,$script);
		$result = curl_exec($ch);
		$cron .= "• {$script}: ".($result !== false ? 'OK' : 'Failed')."\n";
	}
	curl_close($ch);
} else {
	$cron .= "ERROR: THIS SCRIPT REQUIRES THE PHP CURL EXTENSION!\n";
}

if ($sndMail) {//send confirmation email
	//prepare confirmation email
	$subject = "Message from your server - triggered by cron";
	$message = "Hello, this email was sent by the cron.php script.\n
The cronjob ran at {$datetime} (server time) from directory ".getcwd()."
\n{$cron}
Server info:
• Host name: ".gethostname()."
• OS: ".PHP_OS."
\nPHP info:
• Version: ".PHP_VERSION."
• PDO-SQLite extension: ".(extension_loaded('pdo_sqlite') ? 'Yes' : 'No ')."
• PDO-MySQL extension: ".(extension_loaded('pdo_mysql') ? 'Yes' : 'No ')."
\n~ Made by LuxSoft ~";
	$headers = "From: {$from}\r\nReply-To: {$from}\r\nReturn-Path: {$from}\r\nX-Mailer: PHP-LuxSoft\r\n";
	//send email
	$result = mail($to,$subject,$message,$headers) ? 'Sent' : 'Failed';
}

if ($logCron) { //log result
	file_put_contents ('cron.log',"\n{$datetime} Cron run - Mail to {$to}: {$result}\n{$cron}",FILE_APPEND);
}
?>