<?php
namespace App\Http\Controllers\Merchant; use App\Http\Controllers\Shop\ApiPay; use App\Library\CurlRequest; use App\Library\FundHelper; use App\Library\Helper; use App\Library\Response; use App\Mail\OrderShipped; use App\System; use Carbon\Carbon; use Illuminate\Database\Eloquent\Relations\Relation; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use Illuminate\Support\Facades\Auth; use Illuminate\Support\Facades\DB; use Illuminate\Support\Facades\Mail; class Order extends Controller { function get(Request $sp62e4cd, $spb7f9df = false) { $sp4210ad = $this->authQuery($sp62e4cd, \App\Order::class); $sp93712d = (int) $sp62e4cd->input('category_id'); $sp5eed44 = (int) $sp62e4cd->input('product_id'); $sp09b66d = (int) $sp62e4cd->input('profit'); $sp84aaa0 = $sp93712d === \App\Product::ID_API || $sp5eed44 === \App\Product::ID_API; $spe0aaed = $sp62e4cd->input('search', false); $sp75c4d8 = $sp62e4cd->input('val', false); if ($spe0aaed && $sp75c4d8) { if ($spe0aaed == 'id' || $spe0aaed == 'order_no' || $spe0aaed === 'pay_trade_no' || $spe0aaed === 'api_out_no') { $sp4210ad->where($spe0aaed, $sp75c4d8); } else { $sp4210ad->where($spe0aaed, 'like', '%' . $sp75c4d8 . '%'); } } if ($sp93712d > 0) { if ($sp5eed44 > 0) { $sp4210ad->where('product_id', $sp5eed44); } else { $sp4210ad->whereHas('product', function ($sp4210ad) use($sp93712d) { $sp4210ad->where('category_id', $sp93712d); }); } } $sp8616f1 = (int) $sp62e4cd->input('recent', 0); if ($sp8616f1) { $sp20bce8 = (new Carbon())->addDay(-$sp8616f1); $sp4210ad->where(function ($sp4210ad) use($sp20bce8) { $sp4210ad->where('paid_at', '>=', $sp20bce8)->orWhere(function ($sp4210ad) use($sp20bce8) { $sp4210ad->whereNull('paid_at')->where('created_at', '>=', $sp20bce8); }); }); } else { $sp20bce8 = $sp62e4cd->input('start_at', false); if (strlen($sp20bce8)) { $sp4210ad->where(function ($sp4210ad) use($sp20bce8) { $sp4210ad->where('paid_at', '>=', $sp20bce8 . ' 00:00:00')->orWhere(function ($sp4210ad) use($sp20bce8) { $sp4210ad->whereNull('paid_at')->where('created_at', '>=', $sp20bce8 . ' 00:00:00'); }); }); } $sp761637 = $sp62e4cd->input('end_at', false); if (strlen($sp761637)) { $sp4210ad->where(function ($sp4210ad) use($sp761637) { $sp4210ad->where('paid_at', '<=', $sp761637 . ' 23:59:59')->orWhere(function ($sp4210ad) use($sp761637) { $sp4210ad->whereNull('paid_at')->where('created_at', '<=', $sp761637 . ' 23:59:59'); }); }); } } if ($sp09b66d) { $sp4210ad->where('status', \App\Order::STATUS_SUCCESS); $sp74827a = clone $sp4210ad; $sp9cf8be = $sp74827a->selectRaw('SUM(`income`) as income, SUM(`paid`-`sms_price`-`cost`-`fee`) as profit')->first(); } else { $sp7acd11 = $sp62e4cd->input('status'); if (strlen($sp7acd11)) { $sp4210ad->whereIn('status', explode(',', $sp7acd11)); } else { $sp4210ad->where('status', '!=', \App\Order::STATUS_UNPAY); } } if ($sp84aaa0) { $sp4210ad->where('product_id', \App\Product::ID_API); } else { $sp4210ad->where('product_id', '>', 0); $sp4210ad->with(array('product' => function (Relation $sp4210ad) { $sp4210ad->select(array('id', 'name', 'delivery')); }, 'card_orders.card' => function (Relation $sp4210ad) { $sp4210ad->select(array('id', 'card')); })); } $sp4210ad->with(array('pay' => function (Relation $sp4210ad) { $sp4210ad->select(array('id', 'name')); })); $sp4210ad->orderBy('id', 'DESC'); if ($spb7f9df === true) { $sp42d708 = (int) $sp62e4cd->input('export_update_status'); $sp25a9a2 = $sp62e4cd->input('export_update_card'); $sp30b232 = '﻿'; $sp30b232 .= '"订单号","商品名称","下单时间","订单金额","优惠金额","实付金额","手续费","成本价","利润","支付方式","支付流水号","支付时间","订单状态","买家联系方式","买家附加信息"' . '
'; $sp4210ad->chunk(100, function ($sp668460) use(&$sp30b232, $sp42d708, $sp25a9a2) { foreach ($sp668460 as $sp63ddab) { if ($sp63ddab->status === \App\Order::STATUS_PAID) { if ($sp42d708 === \App\Order::SEND_STATUS_CARD_PROCESSING) { $sp63ddab->send_status = $sp42d708; $sp63ddab->saveOrFail(); } elseif ($sp42d708 === \App\Order::SEND_STATUS_CARD_SUCCESS) { $sp63ddab->send_status = $sp42d708; $sp63ddab->saveOrFail(); $this->ship(new Request(array('id' => $sp63ddab->id, 'card' => $sp25a9a2))); } } $spc86f0f = $sp63ddab->contact_ext; if ($spc86f0f) { if ($spc86f0f[0] === '[') { $spc86f0f = substr($spc86f0f, 2); } if ($spc86f0f[strlen($spc86f0f) - 1] === ']') { $spc86f0f = substr($spc86f0f, 0, -2); } } $sp30b232 .= '"' . $sp63ddab->order_no . '","' . $sp63ddab->product_name . '","' . $sp63ddab->created_at . '","' . sprintf('%.2f', $sp63ddab->price / 100) . '","' . sprintf('%.2f', $sp63ddab->discount / 100) . '","' . sprintf('%.2f', $sp63ddab->paid / 100) . '","' . sprintf('%.2f', $sp63ddab->fee / 100) . '","' . sprintf('%.2f', $sp63ddab->cost / 100) . '","' . sprintf('%.2f', ($sp63ddab->paid - $sp63ddab->fee - $sp63ddab->cost) / 100) . '","' . ($sp63ddab->pay ? $sp63ddab->pay->name : '未知#' . $sp63ddab->pay_id) . '","' . $sp63ddab->pay_trade_no . '","' . $sp63ddab->paid_at . '","' . \App\Order::STATUS[$sp63ddab->status] . '","' . $sp63ddab->contact . '","' . $spc86f0f . '"'; $sp30b232 .= '
'; } }); $spd167c4 = 'export_orders_' . $this->getUserIdOrFail($sp62e4cd) . '_' . date('YmdHis') . '.csv'; $spcb575a = array('Content-type' => 'text/plain', 'Content-Disposition' => sprintf('attachment; filename="%s"', $spd167c4), 'Content-Length' => strlen($sp30b232)); return response()->make($sp30b232, 200, $spcb575a); } $sp295466 = (int) $sp62e4cd->input('current_page', 1); $spe5b040 = (int) $sp62e4cd->input('per_page', 20); $sp6492f8 = $sp4210ad->paginate($spe5b040, array('*'), 'page', $sp295466); if ($sp09b66d) { $sp6492f8 = $sp6492f8->toArray(); $sp6492f8['profit_sum'] = $sp9cf8be; } return Response::success($sp6492f8); } function export(Request $sp62e4cd) { return self::get($sp62e4cd, true); } function stat(Request $sp62e4cd) { $this->validate($sp62e4cd, array('day' => 'required|integer|between:7,30')); $sp0d78d7 = (int) $sp62e4cd->input('day'); if ($sp0d78d7 === 30) { $sp20bce8 = Carbon::now()->addMonths(-1)->toDateString() . ' 00:00:00'; } else { $sp20bce8 = Carbon::now()->addDays(-$sp0d78d7)->toDateString() . ' 00:00:00'; } $sp6492f8 = $this->authQuery($sp62e4cd, \App\Order::class)->where(function ($sp4210ad) { $sp4210ad->where('status', \App\Order::STATUS_PAID)->orWhere('status', \App\Order::STATUS_SUCCESS); })->where('paid_at', '>=', $sp20bce8)->groupBy('date')->orderBy('date', 'DESC')->selectRaw('DATE(`paid_at`) as "date",COUNT(*) as "count",SUM(`paid`) as "paid",SUM(`paid`-`sms_price`-`cost`-`fee`) as "profit"')->get()->toArray(); $spa59707 = array(); foreach ($sp6492f8 as $spf1bfa9) { $spa59707[$spf1bfa9['date']] = array((int) $spf1bfa9['count'], (int) $spf1bfa9['paid'], (int) $spf1bfa9['profit']); } return Response::success($spa59707); } function info(Request $sp62e4cd) { $this->validate($sp62e4cd, array('id' => 'required|integer')); $spdc31ea = $sp62e4cd->input('id'); $sp63ddab = $this->authQuery($sp62e4cd, \App\Order::class)->with(array('pay' => function (Relation $sp4210ad) { $sp4210ad->select(array('id', 'name')); }, 'card_orders.card' => function (Relation $sp4210ad) { $sp4210ad->select(array('id', 'card')); }))->findOrFail($spdc31ea); $sp63ddab->addHidden(array('system_fee')); return Response::success($sp63ddab); } function remark(Request $sp62e4cd) { $this->validate($sp62e4cd, array('id' => 'required|integer', 'remark' => 'required|string')); $spdc31ea = $sp62e4cd->input('id'); $sp63ddab = $this->authQuery($sp62e4cd, \App\Order::class)->findOrFail($spdc31ea); $sp63ddab->remark = $sp62e4cd->input('remark'); $sp63ddab->save(); return Response::success(); } function set_send_status(Request $sp62e4cd) { $this->validate($sp62e4cd, array('id' => 'required|integer', 'send_status' => 'required|integer')); $spdc31ea = $sp62e4cd->input('id'); $sp63ddab = $this->authQuery($sp62e4cd, \App\Order::class)->findOrFail($spdc31ea); if ($sp63ddab->status !== \App\Order::STATUS_PAID) { return Response::fail('此订单不是未发货状态, 无法增加发货标记'); } $sp63ddab->send_status = $sp62e4cd->input('send_status'); $sp63ddab->saveOrFail(); return Response::success(); } function ship(Request $sp62e4cd) { $this->validate($sp62e4cd, array('id' => 'required|integer')); $sp63ddab = $this->authQuery($sp62e4cd, \App\Order::class)->with('product')->findOrFail($sp62e4cd->input('id')); if ($sp63ddab->status !== \App\Order::STATUS_PAID) { return Response::fail('订单不是待发货状态, 无法发货'); } if ($sp63ddab->product === null) { return Response::fail('订单对应商品不存在, 无法发货'); } $sp1401e8 = $sp63ddab->product->delivery; $spca039f = ''; if ($sp1401e8 === \App\Product::DELIVERY_MANUAL) { $this->validate($sp62e4cd, array('card' => 'required|string')); $spca039f = $sp62e4cd->input('card'); } $sp8c8b20 = null; $spbd612e = array(); if (FundHelper::orderSuccess($sp63ddab->id, function () use(&$sp63ddab, &$sp8c8b20, &$spbd612e, $sp1401e8, $spca039f) { $sp63ddab = \App\Order::where('id', $sp63ddab->id)->lockForUpdate()->firstOrFail(); if ($sp63ddab->cards && count($sp63ddab->cards)) { $sp8c8b20 = '该订单已经发货，无需再次发货'; return false; } $spfd49bd = $sp63ddab->product()->lockForUpdate()->firstOrFail(); if ($sp1401e8 === \App\Product::DELIVERY_MANUAL) { $sp63ddab->status = \App\Order::STATUS_SUCCESS; $sp63ddab->send_status = \App\Order::SEND_STATUS_CARD_SUCCESS; $sp63ddab->saveOrFail(); $spb6adc1 = \App\Card::create(array('user_id' => Auth::id(), 'product_id' => $spfd49bd->id, 'card' => $spca039f, 'type' => \App\Card::TYPE_ONETIME, 'status' => \App\Card::STATUS_SOLD, 'count_sold' => 1, 'count_all' => 1)); $spbd612e[] = $spb6adc1->card; $sp63ddab->cards()->attach($spb6adc1->id); $spfd49bd->count_sold += $sp63ddab->count; $spfd49bd->saveOrFail(); return FundHelper::ACTION_CONTINUE; } $spb533ba = \App\Card::where('product_id', $spfd49bd->id)->whereRaw('`count_sold`<`count_all`')->take($sp63ddab->count)->lockForUpdate()->get(); if (count($spb533ba) !== $sp63ddab->count) { $sp8c8b20 = '商品卡密不足, 请添加卡密后再发货'; return false; } else { $sp63ddab->status = \App\Order::STATUS_SUCCESS; $sp63ddab->saveOrFail(); $sp43c46a = array(); foreach ($spb533ba as $spb6adc1) { $sp43c46a[] = $spb6adc1->id; $spbd612e[] = $spb6adc1->card; } $sp63ddab->cards()->attach($sp43c46a); \App\Card::whereIn('id', $sp43c46a)->update(array('status' => \App\Card::STATUS_SOLD, 'count_sold' => DB::raw('`count_sold`+1'))); $spfd49bd->count_sold += $sp63ddab->count; $spfd49bd->saveOrFail(); return FundHelper::ACTION_CONTINUE; } })) { if (System::_getInt('mail_send_order')) { $spa6cdee = @json_decode($sp63ddab->contact_ext, true)['_mail']; if ($spa6cdee) { $sp63ddab->sendEmail($spa6cdee); } } if ($sp63ddab->status === \App\Order::STATUS_SUCCESS && System::_getInt('sms_send_order')) { $sp75a7e2 = @json_decode($sp63ddab->contact_ext, true)['_mobile']; if ($sp75a7e2) { $sp63ddab->sendSms($sp75a7e2); } } $sp63ddab['card_orders'] = array_map(function ($spf1bfa9) { return array('card' => array('card' => $spf1bfa9)); }, $spbd612e); $sp63ddab->addHidden(array('system_fee')); return Response::success($sp63ddab); } else { return Response::fail($sp8c8b20 ?? '数据库繁忙, 请联系客服'); } } }