
		var chatSwiper = new Swiper('.swiper-container',{
			pagination: '.wechat-pagination',
			paginationClickable: true,
			paginationBulletRender: function (chatSwiper, index, className) {
				switch (index) {
					case 0:
						name='<i class="ico i1"><em class="wc__badge">105</em></i><span>消息</span>';
						break;
					case 1:
						name='<i class="ico i2"></i><span>通讯录</span>';
						break;
					case 2:
						name='<i class="ico i4"></i><span>我</span>';
						break;
					default: name='';
				}
				return '<li class="flex1 ' + className + '">' + name + '</li>';
			}
		})

		/** __公共函数 */
		$(function(){
			// 禁止长按弹出系统菜单
			$(".wechat__panel").on("contextmenu", function(e){
				e.preventDefault();
			});
		});
		
		/** __自定函数 */
		$(function(){
			//***1、消息-------------------------
			// 聊天记录页面（长按操作）
			$("#J__recordChatList").on("longTap", "li", function(e){
				var _this = $(this);
				wcPop({
					skin: 'androidSheet',
					shadeClose: true,

					btns: [
						{text: '标为未读', style: 'font-size:14px;line-height:50px;'},
						{text: '置顶聊天', style: 'font-size:14px;line-height:50px;'},
						{
							text: '删除该聊天',
							style: 'font-size:14px;line-height:50px;',
							onTap() {
								wcPop({
									skin: 'android',
									content: '删除后，将会清空该聊天记录',

									btns: [
										{
											text: '取消',
											onTap() {
												wcPop.close();
											}
										},
										{
											text: '删除',
											style: 'color:#ffba00',
											onTap() {
												_this.remove();
												wcPop.close();
											}
										}
									]
								});
							}
						}
					]
				});
			});
			// 跳转链接
			$(".wechat__panel").on("click", "*[routeUrl]", function(e){
				var routeurl = $(this).attr('routeUrl');
				if(!routeurl) return;
				window.location.href = routeurl;
			});

			//***2、通讯录-------------------------
			// 右侧浮动条
			$(".wc__addrFriend-floatletter").on("click", "em", function() {
				var letter = $(this).text();
				if($("#" + letter).length > 0){
					// 滚动到指定位置
					//$("#J__addrFriendList").parent().animate({ scrollTop: $("#" + letter).position().top}, 300);
					document.getElementById(letter).scrollIntoView();
				}
				$(".wc__addrFriend-showletter").text(letter).fadeIn(300);

				setTimeout(function(){
					$(".wc__addrFriend-showletter").fadeOut(300);
				}, 500);
			});

			// 通讯录（长按操作）
			$("#J__addrFriendList").on("longTap", ".row", function(e){
				var _this = $(this);
				wcPop({
					skin: 'androidSheet',
					shadeClose: true,

					btns: [
						{
							text: '设置备注及标签',
							style: 'font-size:14px;line-height:50px;',
							onTap() {
								wcPop.close();
							}
						}
					]
				});
			});

			//***3、我的-------------------------
			// 关于微聊系统
			$("#J__aboutChatRoom").on("click", function(){
				var aboutChat = wcPop({
					skin: 'ios',
					content: '<div>h5微聊天室 v1.0.0</div>',
					//style: 'max-width: 750px',

					shadeClose: true,

					btns: [
						{
							text: '知道了',
							style: 'color:#5c93fd;',
							onTap() {
								wcPop.close(aboutChat);
							}
						}
					]
				});
			});

			// 退出登录
			$("#J__logout").on("click", function(){
				var logout = wcPop({
					skin: 'android',
					content: '确定要退出聊天室嚒？',

					btns: [
						{
							text: '取消',
							onTap() {
								wcPop.close();
							}
						},
						{
							text: '退出',
							style: 'color:#5c93fd',
							onTap() {
								window.location.href = "登录.html";
								wcPop.close();
							}
						}
					]
				});
			});
		});
