<?php
/*
Captcher
version 1.1
copyright 2006-9 Gecko Tribe, LLC
by Antone Roundy

http://WhiteHatCrew.com/captcher/
*/
/***** CONFIGURE *****/

$captcherpath='/home/yourusername/captcher';
$fonts=array(
	'my-font-1.gdf',
	'my-font-2.gdf'
);
$bgfonts=array(
	'my-font-3.gdf',
	'my-font-4.gdf'
);
$randomletters=0;
$textcolors=array(
	array(255,0,0),
	array(0,255,0)
);
$backgroundcolors=array(
	array(25,25,25),
	array(51,51,51),
	array(76,76,76),
	array(102,102,102),
	array(127,127,127)
);

/*******************/

$fontnums=array();
$maxw=0;
$maxh=0;
$bgfonts=array_merge($fonts,$bgfonts);
foreach($bgfonts as $v) {
	$fontnums[]=$f=imageloadfont("$captcherpath/gdfonts/$v");
	$w=imagefontwidth($f);
	$h=imagefontheight($f);
	if ($w>$maxw) $maxw=$w;
	if ($h>$maxh) $maxh=$h;
}

require_once "$captcherpath/captcher-utils.php";
$text=isset($_GET['key'])?GetCaptchaText(stripslashes($_GET['key'])):$_GET['text'];

Header('Content-Type: image/gif');

$imgheight=$maxh*2;
$imgwidth=$maxw*strlen($text)+20;
$img=imagecreatetruecolor($imgwidth,$imgheight);

$colors=array();
foreach($backgroundcolors as $v) $colors[]=imagecolorallocate($img,$v[0],$v[1],$v[2]);
$tc=$textcolors[rand(0,count($textcolors)-1)];
$textcolor=imagecolorallocate($img,$tc[0],$tc[1],$tc[2]);

$maxfont=count($fonts)-1;
$maxbgfont=count($bgfonts)-1;
$maxcolor=count($colors)-1;
$maxrandw=$imgwidth-$maxw;
$maxtexth=$maxh-5;
$textlen=strlen($text);

if (!$randomletters) $randomletters=$textlen*3;
for ($i=0;$i<$randomletters;$i++) {
	imagechar($img,$fontnums[floor(rand(0,$maxbgfont))],
		floor(rand(0,$maxrandw)),floor(rand(0,$maxh)),
		$captcherallowedchars{rand(0,$captcherallowedcharsmax)},$colors[floor(rand(0,$maxcolor))]);
}

for ($i=0;$i<$textlen;$i++) {
	imagechar($img,$fontnums[floor(rand(0,$maxfont))],
		10+($i*$maxw),floor(rand(5,$maxtexth)),
		$text{$i},$textcolor);
}

imagegif($img);
imagedestroy($img);
?>