#!/usr/bin/php
<?php
// Slight BBS, Basic telnet "BBS" for PHP/Linux (v0.96)
// Inspired by, but not a clone of, bboard on sdf.org. Run from inetd/xinetd on whatever port you'd like

/*
The MIT License (MIT)
Copyright (c) 2017 Joe Lyman (tfurrows@sdf.org)
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


//// [CONFIGURATION & VARS] ////

// Misc initial vars
$debug = 1;		// set to 1 for additional log entries
$anonuser="anonymous";	// anonymous user, leave empty to disable
$nl = "\r\n";		//  newline
$hline = str_repeat("-",60).$nl;

// turn color on by default; comment out to turn color off by default
color_toggle();

// require one localized strings file for your language
require("/usr/local/lib/slightbbs/strings.en.php");

// files and directories
$docRoot = "/srv/bbs/docs";
$boardRoot = "/srv/bbs/boards";
$lastLoginRoot = "/srv/bbs/login";	// directory with last login information for each user
$authValid = "/srv/bbs/validated";	// flatfile for validated email addresses, should be readable only by bbs user, not world readable
$authWaiting = "/srv/bbs/codes";	// flatfile for email addresses with codes, can be world readable or not

// date() for month/year log rotation
$logFile = "/srv/bbs/visits-".date("m_Y").".log";

// ASCII Documents
$startDoc = "welcome";
$helpDoc = "help";
$help2Doc = "help2";
$validateDoc = "validate";
$loginDoc = "login";
$rulesDoc = "rules";
$anonWelcomeDoc = "anonwelcome";	// or leave blank if anonymous login is disabled/blank

// additional config
$currentBoard = "GENERAL"; // the board you want them to start in
$siteBoards = array("FEEDBACK","GUESTBOOK","BUGS","ANNOUNCE"); // boards that will show at the bottom of the list as "system" boards
$adminBoards = array ("ANNOUNCE"); // admin boards only admins can post to
$adminEmails = array("tfurrows@gmail.com"); // site administrators
$logIgnore = array("192.168.1.1","127.0.0.1","Unknown Host"); // hosts that will not be logged


//// [INIT] ////

// stream timeout for telnet users (not CLI)
stream_set_timeout(STDIN, 300);

// Get remote IP/info
if(isset($_SERVER['REMOTE_HOST'])) {
	$remoteIp = $_SERVER['REMOTE_HOST'];
} else {
	$remoteIp = "Unknown Host";
}

// get a list of valid users & their codes
$validEmails = array();
$validUsers = array();
$fp = fopen($authValid,"r");
if($fp) {
	while (($line = fgets($fp)) !== false) {
		$emailCode = explode("|",trim($line));
		$validEmails[] = $emailCode[0];
		$validUsers[$emailCode[0]] = $emailCode[1];
	}
	fclose($fp);
}

// get a list of boards on the system
$boardDirs = glob($boardRoot . '/*' , GLOB_ONLYDIR); /* */
$boardNames = array();
foreach($boardDirs as $boardDir) {
	$boardNames[] = basename($boardDir);
}

// serve up the starting document
echo $clearScreen.readDoc("$docRoot/$startDoc").$nl;


//// [MAIN COMMAND LOOP] ////

logEntry($localString['sysConnect']);

// initial variables
$loggedIn = "";
$lastLogin = 0;
$pinTries = 0;
$data = "";
$data1 = "";
$prompt = $localString['cmdHelp'];
$cmdCount = 0;
$passCommand = "l";	// use: break out of a case but jump into another
			// Set passCommand to something here before the command loop 
			// if you want a default initial command
$passArg = "";		// use: after breaking and jumping, pass yet another item to that case

while(strtolower($data) != $localString['menuQuit']) {
	// Display help offer intelligently
	$cmdCount++;
	if($cmdCount>3) $prompt = $localString['cmdDefault']; 

	// Prompt for a command unless one was passed from a case
	if($passCommand == "") {
		if(in_array($currentBoard,$adminBoards)) {
			echo $nl."[".ct($currentBoard,"purple")."] $prompt :> ";
		} else {
			echo $nl."[".ct($currentBoard,"cyan")."] $prompt :> ";
		}
		$data = getLine();
	} else {
		$data = $passCommand;
		$passCommand = "";
	}

	// If blank, they may need help.
	if($data == "") {
		$cmdCount = 0;
		$prompt = $localString['cmdHelp'];
	}

	if(preg_match("/([a-z])\ .*?/i",$data)) {
		$passArg = substr($data,2);
		$data = substr($data,0,1);
	}

	// Process commands
	switch ($data) {
		case $localString['menuVersion']:
			// display version info
			echo $hline.ct($localString['versionReport'],"green").$nl.$hline;
			break;
		case $localString['menuHelp']:
			// (h)elp menu
			echo readDoc("$docRoot/$helpDoc");
			break;
		case $localString['menuHelp2']:
			// (?) expanded help menu
			echo readDoc("$docRoot/$help2Doc");
			break;
		case $localString['menuRules']:
			// (!) rules menu
			echo readDoc("$docRoot/$rulesDoc");
			break;
		case $localString['menuValidate']:
			// (v)alidate a user's email
			// first, ask if they already have a code (here for step 2)
			echo $localString['msgValidate1'];

			$data1 = getLine();
			$data1 = strtolower($data1);

			if(strtolower($data1) == $localString['inputYes']) {
				// Step 2, validate code+email
				echo $localString['msgValidate2'];

				// Get email
				$email = "";
				$email = getLine();

				// Make sure they're not already validated
				if(in_array($email,$validEmails)) {
					echo $localString['msgValidate3'].$nl;
					break;
				}

				echo $localString['msgValidate4'];

				$code = "";
				$code = getLine();

				// Check that they match
				$fp = fopen($authWaiting,"r");
				if($fp) {
					while (($line = fgets($fp)) !== false) {
						$line = trim($line);
						$emailCode = explode("|",$line);

						if($emailCode[0] == $email && $emailCode[1] == $code) {
							// Match found. ask for new pin
							echo $localString['msgValidate5'];

							$pin = "";
							$pin = getLine();
							$pin = substr($pin,0,4);

							file_put_contents($authValid,$email."|".$pin.$nl, FILE_APPEND | LOCK_EX);
							logEntry("$email ".$localString['sysValidated']);

							echo $localString['msgValidate6'].$nl;
							$validEmails[] = $email;
							$validUsers[$email] = $pin;
						}
					}
					fclose($fp);
				}
				if(isset($pin) && $pin != "") {
					break;
				}
				echo "[$email]+[$code] ".$localString['msgValidate7'].$nl;

			} elseif(strtolower($data1) == $localString['inputNo']) {
				// Step 1, send code to email
				echo $clearScreen.readDoc("$docRoot/$validateDoc").$localString['msgValidate8'];

				// Get email
				$email = "";
				$email = getLine();

				if(filter_var($email,FILTER_VALIDATE_EMAIL)) {
					// A valid email address was provided
					// make sure they're not abusing the system

					// First, are they already validated?
					if(in_array($email,$validEmails)) {
						echo $localString['msgValidate9'].$nl;
						break;
					}

					// Next, are they already waiting to be validated more than n times?
					// we'll allow for a certain number of validation emails, in case
					// they can't find one.

					$waitingCount = 0;
					$fp = fopen($authWaiting,"r");
					if($fp) {
						while (($line = fgets($fp)) !== false) {
							$emailCode = explode("|",$line);
							if($email == $emailCode[0]) {
								$waitingCount++;
							}
						}
						fclose($fp);
					}
					if($waitingCount>2) {
						echo $localString['msgValidate10'].$nl.$nl;
						break;
					}

					// Generate, save, and send the code
					$p1 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$p2 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$p3 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$validCode = $p1."-".$p2."-".$p3;

					file_put_contents($authWaiting,$email."|".$validCode.$nl, FILE_APPEND | LOCK_EX);

					$message = $localString['msgValidate11'].$nl;

					mail($email,$localString['msgValidate12'],$message);
					logEntry($localString['sysValidSent']." $email");

					echo "[ $email ] ".$localString['msgValidate13'].$nl;
				} else {
					// Error, invalid email address entered
					echo $localString['msgValidate14'].$nl;
				}
			}

			break;
		case $localString['menuList']:
			// (l)ist boards
			// display a header for this list of boards
			echo $localString['msgList1'].$nl.$hline;

			$regBoards = "";
			$sBoards = "";

			foreach($boardDirs as $boardDir) {
				// get board topic, first line only for this listing
				$topicFP = fopen($boardDir."/topic", 'r');
				$topic = trim(fgets($topicFP));
				fclose($topicFP);

				// get board post count (from dir listing)
				if(isset($listPosts)) unset($listPosts);
				$listPosts = glob($boardDir . '/*' , GLOB_ONLYDIR); /* */

				$postCount = str_pad(count($listPosts),4,'0',STR_PAD_LEFT);

				$boardName = basename($boardDir);
				$padding = str_repeat(" ",20 - strlen($boardName));
				if(in_array($boardName,$siteBoards)) {
					if(in_array($boardName,$adminBoards)){
						$sBoards .= " *".ct($boardName,"purple").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
					} else {
						$sBoards .= "  ".ct($boardName,"cyan").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
					}
				} else {
					if(in_array($boardName,$adminBoards)) {
						$regBoards .= " *".ct($boardName,"purple").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
					} else {
						$regBoards .= "  ".ct($boardName,"cyan").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
					}
				}
			}

			echo $regBoards.$localString['msgList2'].str_repeat("-",38).$nl.$sBoards;
			break;
		case $localString['menuGoto']:
			// (g)oto a board
			if($passArg == "") {
				echo $localString['msgGoto1'];
				$gotoBoard = "";
				$gotoBoard = getLine();
			} else {
				$gotoBoard = $passArg;
				$passArg = "";
			}

			$gotoBoard = strtoupper($gotoBoard);

			if($gotoBoard == "") {
				// bboard style behavior, if they hit g but don't enter anything if gives a list
				echo $localString['msgGoto2'].$nl;
				$passCommand = "l";
				break;
			}

			// see if the board exists
			if(in_array($gotoBoard,$boardNames)) {
				$currentBoard = $gotoBoard;
				$topic = readDoc($boardRoot."/".$currentBoard."/topic");
				echo $hline."[".ct($currentBoard,"cyan")."] ".$localString['msgGoto3'].$nl.$hline.$topic.$nl;
			} else {
				echo $localString['msgGoto4']." ".ct($gotoBoard,"cyan").$nl;
			}

			break;
		case $localString['menuMsgsFull']:
		case $localString['menuMsgs']:
			// (m)essage list for current board
			// (M)essage list with reply authors and dates (bboard style)
			if($debug==1) { logEntry("DEBUG(1): 'm' on $currentBoard"); }
			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "[".ct($currentBoard,"cyan")."] ".$localString['msgMsgs1'].$nl;
				break;
			}

			// message listing header
			echo $clearScreen.$hline.ct($currentBoard,"cyan")." ".$localString['msgMsgs2'].$nl;
			echo $localString['msgMsgs3'].$nl.$hline;

			// Go through each message folder, get info and display
			foreach($postNumbers as $pn => $post) {
				$threadInfo = getThreadInfo($post);

				$subject = trim(str_replace($localString['sysSubject'],"",$threadInfo['subject']));
				$author = strtok(trim(str_replace($localString['sysAuthor'],"",$threadInfo['author']))," ");
				if(strlen($author)>13) {
					$author = substr($author,0,13).">";
				}
				if(strlen($author)<14) {
					$author = str_pad($author,14," ");
				}

				//$author = str_pad(substr(strtok(trim(str_replace("[AUTHOR]","",$threadInfo['author']))," "),0,12),14,".");
				$date = trim(str_replace($localString['sysDate'],"",$threadInfo['date']));

				$tsDate = strtotime($date);
				$fmtDate = date("m/d/y",$tsDate);
				$fmtPostNum = str_pad($pn,3,' ',STR_PAD_LEFT);

				echo "  [".ct($fmtPostNum,"yellow")."]  ".ct($fmtDate,"red")." ".ct($author,"yellow")." $subject (".ct("posts: ".$threadInfo['count'],"light_blue").")".$nl;

				// If they asked for a full listing, give it to them
				if($data == $localString['menuMsgsFull']) {
					// build list of posts in this thread
					if(isset($listReplies)) unset($listReplies);
					$listReplies = glob($post.'/*'); /* */
					usort($listReplies, create_function('$a,$b', 'return filemtime($a) - filemtime($b);'));

					foreach($listReplies as $reply) {
						if(substr(strrchr($reply,"/"),1) == "original") continue;
						preg_match("/([0-9]+)\-(.*)/",substr(strrchr($reply,"/"),1),$matches);
						$replyDate = $matches[1];
						$author = $matches[2];
						echo "         ".ct(date("m/d/y",$replyDate),'red')." ".ct($author,'yellow').$nl;
					}
					echo $hline;
				}
			}

			if($data == $localString['menuMsgs']) {
				echo $hline.$localString['msgMsgs4'].$nl;
			}
			break;
		case $localString['menuType']:
			// (t)ype a message, in other words, view a thread
			if($debug==1) { logEntry("DEBUG(1): type on $currentBoard"); }
			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "[".ct($currentBoard,"cyan")."] "." ".$localString['msgMsgs1'].$nl;
				break;
			}

			// find out which message they want to view
			if($passArg == "") {
				echo $localString['msgType1'];
				$typeId = "";
    				$typeId = getLine();
			} else {
				$typeId = $passArg;
				$passArg = "";
			}

			if($typeId == "") {
				echo $localString['msgType2'].$nl;
				break;
			}

			// see if that thread exists
			if(isset($postNumbers[$typeId])) {
				// It exists, show them the latest post, and offer contextual menu
				// build list of posts in this thread
				if(isset($listMessages)) unset($listMessages);
				$listMessages = glob($postNumbers[$typeId].'/*'); /* */
				usort($listMessages, create_function('$b,$a', 'return filemtime($a) - filemtime($b);'));

				$threadCount = count($listMessages);
				$viewMessage = 0;

				// View the latest message in the thread
				echo $clearScreen.readDoc($listMessages[$viewMessage]).$nl;

				// Context menu loop
				$typeContext = "";
				while(strtolower($typeContext) != $localString['menuType5']) {
					// context "menu"
					echo $nl.$localString['msgType3']." ".ct(($threadCount - $viewMessage),"yellow")." ".$localString['msgType4']." ".ct($threadCount,"yellow").$nl;
					echo $localString['msgType5'];

					$typeContext = "";
					$typeContext = getLine();

					switch($typeContext) {
						case $localString['menuType1']:
							// reply to this thread
							$passCommand = $localString['menuReply'];
							$passArg = $typeId;
						break 2; // break out of main swtich as well
						case "": // if they press <enter> let them view previous thread messages
						case $localString['menuType2']:
							// goto older message in thread
							if($threadCount-$viewMessage == 1) {
								echo $localString['msgType6'].$nl;
								break;
							}

							$viewMessage++;
							echo $clearScreen.readDoc($listMessages[$viewMessage]).$nl;
						break;
						case $localString['menuType3']:
							// goto newer message in thread
							if($viewMessage == 0) {
								echo $localString['msgType7'].$nl;
								break;
							}

							$viewMessage--;
							echo $clearScreen.readDoc($listMessages[$viewMessage]).$nl;
						break;
						case $localString['menuType4']:
							// view first post in thread
							$viewMessage = $threadCount-1;
							echo $clearScreen.readDoc($listMessages[$viewMessage]).$nl;
						break;
						default:
					}
				}

			} else {
				echo $localString['msgType8'].$nl;
			}
			break;
		case $localString['menuReply']:
			// Post a reply to a thread
			if($loggedIn == "") {
				echo $localString['msgReply1'].$nl;
				$passArg = "";
				break;
			}

			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "[".ct($currentBoard,"cyan")."] "." ".$localString['msgMsgs1'].$nl;
				break;
			}

			// find out which message they want to reply to, unless one was passed
			if($passArg == "") {
				echo $localString['msgReply2'];

				$typeId = "";
				$typeId = getLine();
			} else {
				$typeId = $passArg;
				$passArg = "";
			}

			// see if that thread exists
			if(isset($postNumbers[$typeId])) {
				// get the thread subject from the original post and display it
				$threadInfo = getThreadInfo($postNumbers[$typeId]);

				echo $clearScreen.$localString['msgReply3']." ".ct($currentBoard,"cyan").$nl.$hline;
				echo $threadInfo['subject'].$threadInfo['author'].$threadInfo['date'].$hline;
				echo $localString['msgReply4'].$nl.$hline;

				$replyText = getMultiLines();

				if($replyText == "") {
					echo "Cancelled.".$nl;
					break;
				}

				// Verify reply post is what they want.
				if($anonuser!="" && $loggedIn == $anonuser) {
					$emailParts=explode("@",$loggedIn."@none");
				} else {
					$emailParts = explode("@",$loggedIn);
				}
				$postDate = date("D M j G:i:s T Y");

				$msgSave = $hline;
				$msgSave .= str_replace($localString['sysSubject'],$localString['sysSubRe'],$threadInfo['subject']);
				$msgSave .= $localString['sysAuthor']."  ".$emailParts[0]." [@] ".$emailParts[1].$nl;
				$msgSave .= $localString['sysDate']."    ".$postDate.$nl;
				$msgSave .= $hline;
				$msgSave .= implode($nl,$replyText).$nl;
				$msgSave .= $hline;

				echo $clearScreen.$msgSave.$nl.$localString['msgReply5'];

				$confirm = "";
				$confirm = getLine();
				$confirm = strtolower($confirm);

				if($confirm == $localString['inputNo']) {
					echo "Cancelled.".$nl;
					break;
				}

				// Save reply to a file
				$newFile = $postNumbers[$typeId]."/".time()."-".preg_replace('/[^a-z0-9]/', '', $emailParts[0]);

				$newfp = fopen($newFile,"w");
				fwrite($newfp,$msgSave);
				fclose($newfp);

				echo $localString['msgReply6'].$nl;
				logEntry($localString['sysNewRep']." $newFile");

			} else {
				echo $localString['msgReply7'].$nl;
			}

			break;
		case $localString['menuScan']:
			// (s)can for new messages since last login/scan
			if($loggedIn == "") {
				echo $localString['msgScan1'].$nl;
				break;
			}

			echo $localString['msgScan2'].$nl.$hline;
			$maxNameLen = max(array_map('strlen',$boardNames));

			foreach($boardNames as $boardName) {
				echo $localString['msgScan3']." ".ct($boardName,"cyan").str_repeat(" ",$maxNameLen-strlen($boardName))." ";

				$numNew=0;
				$listPosts = glob($boardRoot."/".$boardName.'/*', GLOB_ONLYDIR); /* */
				foreach($listPosts as $post) {
					if(filemtime($post) > $lastLogin) $numNew++;
				}

				if($numNew>0) {
					echo ct("$numNew ".$localString['msgScan4'],"blue").$nl;
				} else {
					echo $localString['msgScan5'].$nl;
				}
			}

			// Set lastlogin to now, and update lastlogin file
			setLastLogin($loggedIn);
			$lastLogin = time();

			echo $hline;
			echo $localString['msgScan6'].$nl;
			break;
		case $localString['menuColor']:
			// Disable/enable ansi colors
			color_toggle();
			if($colorState == false) {
				echo $localString['msgColor1'].$nl;
			} else {
				echo $localString['msgColor2'].$nl;
			}
			break;
		case $localString['menuNew']:
			// (n)ew post in current board
			if($loggedIn == "") {
				echo $localString['msgNew1'].$nl;
				break;
			}

			// check if admin only board
			if(in_array($currentBoard,$adminBoards)) {
				if(!in_array($loggedIn,$adminEmails)) {
					// not admin
					echo $localString['msgNew2'].$nl;
					break;
				}
			}

			echo $clearScreen.$hline.$localString['msgNew3']." ".ct($currentBoard,"cyan").$nl.$hline;

			echo $localString['msgNew4'];

			$subject = "";
			$subject = getLine();
			$subject = mb_strimwidth($subject,0,60, "...");

			if($subject == "") {
				echo $localString['msgNew5'].$nl;
				break;
			}

			echo $localString['msgNew6'].$nl.$hline;

			$messageBody = getMultiLines();

			if($messageBody == "") {
				echo $localString['msgNew5'].$nl;
				break;
			}

			// Verify post is what they want.
			if($anonuser!="" && $loggedIn==$anonuser) {
				$emailParts = explode("@",$loggedIn."@none");
			} else {
				$emailParts = explode("@",$loggedIn);
			}
			$postDate = date("D M j G:i:s T Y");

			$msgSave = $hline;
			$msgSave .= $localString['sysSubject']." ".$subject.$nl;
			$msgSave .= $localString['sysAuthor']."  ".$emailParts[0]." [@] ".$emailParts[1].$nl;
			$msgSave .= $localString['sysDate']."    ".$postDate.$nl;
			$msgSave .= $hline;
			$msgSave .= implode($nl,$messageBody).$nl;
			$msgSave .= $hline;

			echo $clearScreen.$msgSave.$nl.$localString['msgNew7'];

			$confirm = "";
			$confirm = getLine();
			$confirm = strtolower($confirm);

			if($confirm == "n") {
				echo $localString['msgNew5'].$nl;
				break;
			}

			// Save to a file
			$newFolder = $boardRoot."/".$currentBoard."/".time()."-".preg_replace('/[^a-z0-9]/', '', $emailParts[0]);

			mkdir($newFolder);

			$newfp = fopen($newFolder."/original","w");
			fwrite($newfp,$msgSave);
			fclose($newfp);

			echo $localString['msgNew8'].$nl;
			logEntry($localString['sysNewThr']." $email: $newFolder");

			break;
		case $localString['menuLogin']:
			// (login) authenticate for this session
			if($debug==1) { logEntry("DEBUG(1): 'login'"); }

			if($loggedIn != "") {
				echo $localString['msgLogin1'].$nl;
				break;
			}

			echo readDoc("$docRoot/$loginDoc");
			if($anonuser != "") {
				echo $localString['msgLogin2'];
			} else {
				echo $localString['msgLogin3'];
			}

			// Get email
			$email = "";
			$email = getLine();

			if($email == "") {
				echo $localString['msgLogin4'].$nl;
				break;
			}

			if($anonuser != "" && $email == $anonuser) {
					// login anonymous user
					echo $clearScreen.$localString['msgLogin5'].$nl;
					echo readDoc("$docRoot/$anonWelcomeDoc");

					$loggedIn = $email;
					logEntry($localString['sysLogin']." $email");
					break;
			}

			echo $nl.$localString['msgLogin6'].$fg_color['black'];

			// Get pin
			$pin = "";
			$pin = getLine();

			echo $color_reset;
			if($pin == "") {
				echo $localString['msgLogin4'].$nl;
				break;
			}

			// Check against list
			if(in_array($email,$validEmails)) {
				if($validUsers[$email]==$pin) {
					// Email and pin valid, logged in
					// save last login time, for new message scan
					setLastLogin($email);

					// Welcome them, set logged in
					echo $clearScreen;
					echo $localString['msgLogin7'].$nl;
					$loggedIn = $email;
					logEntry($localString['sysLogin']." $email");
				} else {
					// wrong pin
					$pinTries++;

					if($pinTries > 2) {
						echo $localString['msgLogin10'].$nl;
						break 2;
					}
					echo $localString['msgLogin8'].$nl;
				}
			} else {
				echo $localString['msgLogin9'].$nl;
			}

			break;
		default:
			if($data != $localString['menuQuit']) {
				// unrecognized command, they may need help
				echo $localString['sysUnrec'].$nl;
				$cmdCount = 0;
				$prompt = $localString['cmdHelp'];
			}
	}

}

//echo $clearScreen;
echo $localString['sysBye'].$nl;

// log the disconnect
logEntry($localString['sysDiscon']);


//// [FUNCTIONS]
function logEntry($entry) {
	global $logFile,$remoteIp,$logIgnore,$nl;

	if(in_array($remoteIp,$logIgnore)) {
		return;
	}

	$logEntry = "[".date("D M j G:i:s T Y")."] -- $entry -- $remoteIp".$nl;
	file_put_contents($logFile,$logEntry, FILE_APPEND | LOCK_EX);
}

function getLine () {
	global $nl,$localString;
	// get a line from STDIN, and handle timeout
	$getLine = fgets(STDIN);
	$getLine = rtrim($getLine);

	// timeout
	$timeOutCheck = stream_get_meta_data(STDIN);
	if($timeOutCheck['timed_out']==true) {
		logEntry($localString['sysTimeout']);
		echo $localString['sysTimeoutMsg'].$nl;
		exit;
	}

	return $getLine;
}

function getMultiLines () {
	// multi-line input loop
	// longer timeout here

	global $nl,$localString;

	$bodyLine = "";
	$messageBody = "";
	$timesOut = 0;

	while (strtolower($bodyLine) != $localString['inputDone']) {
		$bodyLine = "";
		$bodyLine = fgets(STDIN);
		$bodyLine = rtrim($bodyLine);

		// timeout check
		$timeOutCheck = stream_get_meta_data(STDIN);
		if($timeOutCheck['timed_out']==true) {
			$timesOut++;

			if($timesOut>5) {
				logEntry($localString['sysTimeout']);
				echo $nl.$localString['sysTimeoutMsg'].$nl;
				exit;
			}
		} else {
			if(strtolower($bodyLine) != $localString['inputDone']) {
				$messageBody [] = $bodyLine;
			}
		}
	}

	return $messageBody;
}

function getMessageList ($board) {
	// build an array list of posts in a board
	$listPosts = glob($board.'/*', GLOB_ONLYDIR); /* */
	usort($listPosts, create_function('$b,$a', 'return filemtime($a) - filemtime($b);'));

	if(count($listPosts)>0) {
		$postCount = 0;
		$postNumbers = array();

		foreach($listPosts as $post) {
			// assign a number for a post
			$postCount++;
			$postNumbers[$postCount] = $post;
		}

		return $postNumbers;
	} else {
		return 0;
	}
}

function getThreadInfo($post) {
	// get info from a single thread, original post
	$threadInfo = array();

	$postfp = fopen($post."/original",'r');
	$line = fgets($postfp);
	$threadInfo['subject'] = fgets($postfp);
	$threadInfo['author'] = fgets($postfp);
	$threadInfo['date'] = fgets($postfp);
	fclose($postfp);

	// get number of posts in thread
	$threadInfo['count'] = count(glob($post."/*")); /* */

	return $threadInfo;
}

function color_toggle () {
	global $colorState, $color_reset, $fg_color, $bg_color, $clearScreen;

	if(!isset($colorState) || $colorState == false) {
		$colorState = true;
		// Colors are currently OFF, turn them ON
		$clearScreen = "\033[2J\033[H";
		$color_reset = "\033[0m";

		$fg_color = [
			'black' 	=> "\033[0;30m",	'dark_gray' 	=> "\033[1;30m",
			'blue' 		=> "\033[0;34m",	'light_blue' 	=> "\033[1;34m",
			'green' 	=> "\033[0;32m",	'light_green' 	=> "\033[1;32m",
			'cyan' 		=> "\033[0;36m",	'light_cyan' 	=> "\033[1;36m",
			'red' 		=> "\033[0;31m",	'light_red' 	=> "\033[1;31m",
			'purple' 	=> "\033[0;35m",	'light_purple' 	=> "\033[1;35m",
			'brown' 	=> "\033[0;33m",	'yellow' 	=> "\033[1;33m",
			'light_gray' 	=> "\033[0;37m"
		];

		$bg_color = [
			'black' 	=> "\033[40m",
			'red' 		=> "\033[41m",
			'green' 	=> "\033[42m",
			'yellow' 	=> "\033[43m",
			'blue' 		=> "\033[44m",
			'magenta' 	=> "\033[45m",
			'cyan' 		=> "\033[46m",
			'light_gray' 	=> "\033[47m"
		];
	} else {
		$colorState = false;
		// Colors were ON, turn them OFF
		$color_reset = "";
		$clearScreen = "";
		$fg_color = array_fill_keys(array_keys($fg_color), null);
		$bg_color = array_fill_keys(array_keys($bg_color), null);
	}
}

function ct($text,$color) {
	// COLOR TEXT: return text with ansi foreground color codes wrapped around it
	// todo: support background colors with another parameter
	global $fg_color,$color_reset;
	if(isset($fg_color[$color])) {
		return $fg_color[$color].$text.$color_reset;
	} else {
		return $text;
	}
}

function readDoc($docName) {
	// read in a document
	// to replace line endings with whatever is specified in config var
	global $nl;
	$orig_text = file_get_contents($docName);
	$new_text = preg_replace('/\R/u',$nl,$orig_text);
	return $new_text;
}

function setLastLogin($email) {
	// saves last login, or last newscan time, in a file for the use
	// also retrieves the last login time from the file before resetting it
	global $lastLoginRoot,$lastLogin,$anonuser;
	if($anonuser!="" && $email == $anonuser) {
		$loginFile= $lastLoginRoot."/".$anonuser;
	} else {
		$emailParts = explode("@",$email);
		$loginFile = $lastLoginRoot."/".preg_replace('/[^a-z0-9]/', '', $emailParts[0])."_at_".$emailParts[1];
	}

	if(file_exists($loginFile)) $lastLogin = file_get_contents($loginFile);

	$loginfp = fopen($loginFile,"w");
	fwrite($loginfp,"".time());
	fclose($loginfp);
}


?>
