/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.AltKeyEventProcessor;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

public class GraphicsUtils
extends SynthGraphicsUtils {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");

    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n, int n2, int n3) {
        Object object;
        Object object2;
        JComponent jComponent = synthContext.getComponent();
        if (synthContext.getRegion() == Region.BUTTON || synthContext.getRegion() == Region.TOGGLE_BUTTON) {
            if (!SyntheticaLookAndFeel.getBoolean("Button.showMnemonics", jComponent, true)) {
                n3 = -1;
            }
            if ((object2 = (String)SyntheticaLookAndFeel.get("Synthetica.button.textBackground", jComponent)) != null && ((String)object2).length() > 0 && string != null && string.trim().length() > 0) {
                Object object3 = object = (Insets)SyntheticaLookAndFeel.get("Synthetica.button.textBackground.insets", jComponent);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n4 = fontMetrics.getHeight();
                int n5 = fontMetrics.stringWidth(string);
                ImagePainter imagePainter = new ImagePainter(graphics, n - 2, n2, n5 + 4, n4, (String)object2, (Insets)object, (Insets)object3, 0, 0);
                imagePainter.draw();
            }
        } else if (synthContext.getRegion() == Region.TABBED_PANE_TAB) {
            TabbedPanePainter tabbedPanePainter;
            object2 = (JTabbedPane)jComponent;
            int n6 = ((JTabbedPane)object2).getSelectedIndex();
            int n7 = (Integer)((JComponent)object2).getClientProperty("Synthetica.tabbedPane.tabIndex");
            Color color = ((JTabbedPane)object2).getForegroundAt(n7);
            if (color != null && !(color instanceof UIResource)) {
                graphics.setColor(color);
            }
            if (n6 != n7 && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", (Component)object2)) {
                int n8 = graphics.getFontMetrics().stringWidth(string);
                graphics.setFont(graphics.getFont().deriveFont(0));
                int n9 = graphics.getFontMetrics().stringWidth(string);
                n += (n8 - n9) / 2;
            }
            if (SyntheticaLookAndFeel.get("Synthetica.TabbedPanePainter", jComponent) != null && !(tabbedPanePainter = (TabbedPanePainter)SyntheticaLookAndFeel.get("Synthetica.TabbedPanePainter", jComponent)).paintTabbedPaneTabText(synthContext, graphics, string, n, n2, n3)) {
                return;
            }
        } else if (synthContext.getRegion() == Region.PROGRESS_BAR) {
            object2 = (String)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground", jComponent);
            if (object2 != null && ((String)object2).length() > 0 && string != null && string.trim().length() > 0) {
                Object object4 = object = (Insets)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground.insets", jComponent);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n10 = fontMetrics.getHeight();
                int n11 = fontMetrics.stringWidth(string);
                ImagePainter imagePainter = new ImagePainter(graphics, n - 2, n2, n11 + 4, n10, (String)object2, (Insets)object, (Insets)object4, 0, 0);
                imagePainter.draw();
            }
        } else if (synthContext.getRegion() == Region.INTERNAL_FRAME_TITLE_PANE) {
            if (!JAVA5 && n3 == -1) {
                return;
            }
        } else if (!(synthContext.getRegion() != Region.MENU && synthContext.getRegion() != Region.MENU_ITEM || this.getPaintMnemonics())) {
            n3 = -1;
        } else if (synthContext.getRegion() == Region.MENU_ITEM_ACCELERATOR && UIManager.get("MenuItem.acceleratorDelimiter") != null) {
            string = string.replace("+", UIManager.getString("MenuItem.acceleratorDelimiter"));
        }
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", jComponent)) {
            object2 = (Graphics2D)graphics;
            object = ((Graphics2D)object2).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JAVA5) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            super.paintText(synthContext, (Graphics)object2, string, n, n2, n3);
            ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            super.paintText(synthContext, graphics, string, n, n2, n3);
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", synthContext.getComponent())) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JAVA5) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            super.paintText(synthContext, graphics2D, string, icon, n, n2, n3, n4, n5, n6, n7);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            super.paintText(synthContext, graphics, string, icon, n, n2, n3, n4, n5, n6, n7);
        }
    }

    protected boolean getPaintMnemonics() {
        if (AltKeyEventProcessor.showMnemonicsOnAltKeyOnly()) {
            return AltKeyEventProcessor.isMenuActive();
        }
        return true;
    }

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (object instanceof String && ((String)object).startsWith("Tree.")) {
            String string;
            Color color = null;
            if (object.equals("Tree.horizontalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.horizontal", jComponent);
            } else if (object.equals("Tree.verticalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.vertical", jComponent);
            }
            if (color != null) {
                graphics.setColor(color);
            }
            if ("SOLID".equals(string = SyntheticaLookAndFeel.getString("Synthetica.tree.line.type", jComponent))) {
                graphics.drawLine(n, n2, n3, n4);
            } else if ("DASHED".equals(string)) {
                int n5;
                int n6 = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.line", jComponent);
                if (n6 <= 0) {
                    n6 = 2;
                }
                if ((n5 = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.space", jComponent)) <= 0) {
                    n5 = 1;
                }
                if (object.equals("Tree.horizontalLine")) {
                    int n7 = n;
                    while (n7 < n3) {
                        graphics.drawLine(n7, n2, Math.min(n7 + n6 - 1, n3), n4);
                        n7 += n6 + n5;
                    }
                } else {
                    int n8 = n2;
                    while (n8 < n4) {
                        graphics.drawLine(n, n8, n, Math.min(n8 + n6 - 1, n4));
                        n8 += n6 + n5;
                    }
                }
            }
            return;
        }
        if (n == n3 && object instanceof String && ((String)object).equals("Table.grid") && SyntheticaLookAndFeel.getInt("Synthetica.table.columnMargin", synthContext.getComponent(), 1) == 0) {
            return;
        }
        super.drawLine(synthContext, object, graphics, n, n2, n3, n4);
    }

    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        Object object;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JTabbedPane) {
            n3 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.text.position.leading", jComponent) ? 10 : 11;
            object = SyntheticaLookAndFeel.getStyleFactory();
            SynthStyle synthStyle = ((SynthStyleFactory)object).getStyle(synthContext.getComponent(), Region.TABBED_PANE);
            if (synthStyle.get(synthContext, "TabbedPane.textIconGap") == null) {
                n5 = 4;
            }
        }
        if (jComponent instanceof JMenuItem && jComponent.getParent() instanceof MenuElement) {
            this.menuItemTextGapCorrection(synthContext, (JMenuItem)jComponent, rectangle);
        }
        object = super.layoutText(synthContext, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (jComponent instanceof JMenuItem && jComponent.getParent() instanceof MenuElement) {
            this.menuItemIndentCorrection(synthContext, (JMenuItem)jComponent, rectangle3, rectangle2);
        }
        if (jComponent instanceof JTabbedPane && ((JTabbedPane)jComponent).getTabCount() > 0) {
            this.tabbedPaneTabCorrection(synthContext, (JTabbedPane)jComponent, fontMetrics, string, icon, rectangle, rectangle3, rectangle2);
        }
        return object;
    }

    private void menuItemTextGapCorrection(SynthContext synthContext, JMenuItem jMenuItem, Rectangle rectangle) {
        MenuElement menuElement = (MenuElement)((Object)jMenuItem.getParent());
        JPopupMenu jPopupMenu = this.findPopup((Container)((Object)menuElement));
        if (jPopupMenu == null) {
            return;
        }
        boolean bl = jPopupMenu.getComponentOrientation().isLeftToRight();
        SynthStyleFactory synthStyleFactory = SyntheticaLookAndFeel.getStyleFactory();
        SynthStyle synthStyle = synthStyleFactory.getStyle(jMenuItem, Region.MENU_ITEM);
        int n = (Integer)synthStyle.get(synthContext, "MenuItem.textIconGap");
        if (!(jMenuItem instanceof JRadioButtonMenuItem || jMenuItem instanceof JCheckBoxMenuItem || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu))) {
            rectangle.x = rectangle.x - (bl ? n : 0);
            rectangle.width += n;
        }
        if (jMenuItem instanceof JRadioButtonMenuItem || jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JMenu) {
            SynthStyle synthStyle2;
            jMenuItem.setIconTextGap(n);
            if (JAVA5 || SyntheticaLookAndFeel.JAVA6U23_OR_ABOVE) {
                rectangle.x = rectangle.x + (bl ? n - 4 : 0);
                rectangle.width += -n + 4;
                if (jMenuItem instanceof JMenu) {
                    if (jMenuItem.getIcon() == null) {
                        rectangle.width = rectangle.width + (bl ? 0 : -n + 4 - synthStyle.getInsets((SynthContext)synthContext, null).right);
                    } else {
                        synthStyle2 = synthStyleFactory.getStyle(jMenuItem, Region.MENU);
                        int n2 = (Integer)synthStyle2.get(synthContext, "Menu.textIconGap");
                        rectangle.x = rectangle.x + (bl ? n + 4 - n2 * 2 : -n + 4 - synthStyle.getInsets((SynthContext)synthContext, null).right);
                        rectangle.width += -n - 4 + n2 * 2;
                    }
                }
            }
            if (jMenuItem instanceof JMenu) {
                synthStyle2 = synthStyleFactory.getStyle(jMenuItem, Region.MENU);
                Insets insets = synthStyle2.getInsets(synthContext, null);
                rectangle.x = rectangle.x - (bl ? insets.left : insets.right);
                rectangle.width += insets.left + insets.right;
            }
        }
    }

    private void menuItemIndentCorrection(SynthContext synthContext, JMenuItem jMenuItem, Rectangle rectangle, Rectangle rectangle2) {
        MenuElement menuElement = (MenuElement)((Object)jMenuItem.getParent());
        JPopupMenu jPopupMenu = this.findPopup((Container)((Object)menuElement));
        if (jPopupMenu == null) {
            return;
        }
        boolean bl = jPopupMenu.getComponentOrientation().isLeftToRight();
        boolean bl2 = SyntheticaLookAndFeel.popupHasIcons(jPopupMenu);
        boolean bl3 = SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu);
        int n = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.icon.width", jPopupMenu, 16);
        int n2 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.checkRadioIcon.width", jPopupMenu, 14);
        int n3 = n2 < n ? n - n2 : 0;
        SynthStyleFactory synthStyleFactory = SyntheticaLookAndFeel.getStyleFactory();
        SynthStyle synthStyle = synthStyleFactory.getStyle(jMenuItem, Region.MENU_ITEM);
        int n4 = (Integer)synthStyle.get(synthContext, "MenuItem.textIconGap");
        if (!(menuElement instanceof JPopupMenu) || JAVA5 || SyntheticaLookAndFeel.JAVA6U23_OR_ABOVE) {
            int n5 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", jPopupMenu, 0);
            if (bl2 && !bl3) {
                if (bl) {
                    rectangle.x = rectangle2.width == 0 ? n : rectangle.x;
                } else {
                    rectangle.x = rectangle.x - (rectangle2.width == 0 ? n + n4 : 0);
                    rectangle.width = rectangle.width + (rectangle2.width == 0 ? n + n4 : 0);
                }
            }
            if (jMenuItem instanceof JMenu) {
                SynthStyle synthStyle2 = synthStyleFactory.getStyle(jMenuItem, Region.MENU);
                int n6 = (Integer)synthStyle2.get(synthContext, "Menu.textIconGap");
                if (jMenuItem.getIcon() == null) {
                    rectangle.x = rectangle.x + (bl ? n4 * 2 - n6 * 2 : n4 * 2 - 8);
                    if (bl3) {
                        rectangle.x = rectangle.x + (bl ? n2 - n4 + 4 : -n2);
                    }
                    if (bl2 && bl3) {
                        rectangle.x = rectangle.x + (bl ? n3 : -n3);
                    } else if (!bl2 && !bl3) {
                        rectangle.x = rectangle.x - (bl ? n4 - 4 : 0);
                    }
                } else {
                    int n7 = SyntheticaLookAndFeel.JAVA6U23_OR_ABOVE ? -n4 + 4 : 0;
                    rectangle.x = rectangle.x + (bl ? n4 - n6 : n4 * 2 - 8 + n7);
                    rectangle2.x = rectangle2.x + (bl ? 0 : n4 * 2 - 8 + n7);
                    if (bl3) {
                        rectangle2.x = rectangle2.x - (bl ? n4 : -n4);
                        rectangle.x = rectangle.x - (bl ? n4 : -n4);
                    }
                }
            } else if (bl2 && bl3) {
                if (jMenuItem instanceof JRadioButtonMenuItem || jMenuItem instanceof JCheckBoxMenuItem) {
                    rectangle.x = rectangle.x + (bl ? n4 + n3 - 4 : -n4 - n3 + 4);
                } else if (jMenuItem.getIcon() != null) {
                    rectangle2.x = rectangle2.x + (bl ? -n4 : n4);
                    rectangle.x = rectangle.x + (bl ? -n4 : n4);
                } else {
                    rectangle.x = rectangle.x + (bl ? n2 + n3 : -n2 - n3);
                }
            } else if (bl3) {
                rectangle.x = jMenuItem instanceof JRadioButtonMenuItem || jMenuItem instanceof JCheckBoxMenuItem ? rectangle.x + (bl ? n4 - 4 : -n4 + 4) : rectangle.x + (bl ? n2 : 0);
                rectangle.width += n4 * 3 - 13;
            }
            if (bl2 || bl3) {
                rectangle.x = rectangle.x + (bl ? n5 : -n5);
                rectangle.width += n5;
            }
        } else {
            if (bl2 && bl3) {
                if (jMenuItem.getIcon() != null && !(jMenuItem instanceof JRadioButtonMenuItem) && !(jMenuItem instanceof JCheckBoxMenuItem)) {
                    rectangle2.x = rectangle2.x - (bl ? n4 : -n4);
                    rectangle.x = rectangle.x - (bl ? n4 : -n4);
                }
            } else if (bl2) {
                rectangle.width += n;
            }
            if ((bl2 || bl3) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
                int n8 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", jPopupMenu, 0);
                rectangle.x = rectangle.x + (bl ? n8 : -n8);
                rectangle.width += n8;
            }
        }
    }

    private JPopupMenu findPopup(Container container) {
        if (container instanceof JPopupMenu) {
            return (JPopupMenu)container;
        }
        if (container == null) {
            return null;
        }
        Container container2 = container.getParent();
        return this.findPopup(container2);
    }

    private void tabbedPaneTabCorrection(SynthContext synthContext, JTabbedPane jTabbedPane, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n;
        int n2 = jTabbedPane.getSelectedIndex();
        boolean bl = n2 == (n = ((Integer)jTabbedPane.getClientProperty("Synthetica.tabbedPane.tabIndex")).intValue());
        int n3 = jTabbedPane.getTabPlacement();
        if (jTabbedPane.getIconAt(n) != null) {
            int n4 = fontMetrics.getHeight();
            int n5 = Math.max(n4, jTabbedPane.getIconAt(n).getIconHeight());
            rectangle2.y += (n4 - n5) / 2;
        }
        String string2 = "tabbedPane.tab";
        if (bl) {
            string2 = String.valueOf(string2) + ".selected";
        }
        if (n3 == 1) {
            string2 = String.valueOf(string2) + ".top";
        } else if (n3 == 2) {
            string2 = String.valueOf(string2) + ".left";
        } else if (n3 == 3) {
            string2 = String.valueOf(string2) + ".bottom";
        } else if (n3 == 4) {
            string2 = String.valueOf(string2) + ".right";
        }
        Insets insets = SyntheticaLookAndFeel.getInsets(string2, "text.insets", jTabbedPane.getName(), true);
        if (insets != null) {
            rectangle2.x += insets.left;
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    rectangle2.y += insets.top;
                    break;
                }
                case 3: {
                    rectangle2.y -= insets.bottom;
                }
            }
        }
        if (icon != null) {
            insets = SyntheticaLookAndFeel.getInsets(string2, "icon.insets", jTabbedPane.getName(), true);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            rectangle3.x += insets.left;
            if (jTabbedPane.getTabPlacement() == 1) {
                rectangle3.y += insets.top;
            } else if (jTabbedPane.getTabPlacement() == 3) {
                rectangle3.y -= insets.bottom;
            }
        }
    }

    public static Image iconToImage(SynthContext synthContext, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        JComponent jComponent = synthContext == null ? null : synthContext.getComponent();
        icon.paintIcon(jComponent, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public void paintListCellRendererSelectionBackground(JList jList, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = this.cellRendererRespectsFocus(component) ? jList.hasFocus() : true;
        String string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.list.selectionBackground" : "Synthetica.list.selectionBackground.inactive", component);
        if (string != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.list.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTreeCellRendererSelectionBackground(JTree jTree, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        boolean bl = true;
        if (this.cellRendererRespectsFocus(component)) {
            bl = jTree.getParent() instanceof CellRendererPane ? jTree.getParent().getParent().hasFocus() : jTree.hasFocus();
        }
        if ((string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.tree.selectionBackground" : "Synthetica.tree.selectionBackground.inactive", component)) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.tree.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTableCellRendererSelectionBackground(JTable jTable, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        boolean bl;
        boolean bl2 = bl = this.cellRendererRespectsFocus(component) ? jTable.hasFocus() : true;
        if (jTable.getCellEditor() != null) {
            bl = true;
        }
        if ((string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.table.selectionBackground" : "Synthetica.table.selectionBackground.inactive", component)) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.table.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    private boolean cellRendererRespectsFocus(Component component) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", component, false);
    }
}

