/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthIcon;

public class SyntheticaMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthConstants {
    private static WeakHashMap<Component, MaxWidth> maxWidths = new WeakHashMap();
    private String acceleratorDelimiter;
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle acceleratorRect = new Rectangle();
    private static Rectangle checkIconRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaMenuItemUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        Object object;
        SynthStyle synthStyle = this.getStyle(jMenuItem);
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        String string = this.getPropertyPrefix();
        synthStyle.installDefaults(synthContext);
        Object object2 = synthStyle.get(synthContext, String.valueOf(string) + ".textIconGap");
        if (object2 != null) {
            LookAndFeel.installProperty(jMenuItem, "iconTextGap", object2);
        }
        this.defaultTextIconGap = jMenuItem.getIconTextGap();
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            object = (Insets)synthStyle.get(synthContext, String.valueOf(string) + ".margin");
            if (object == null) {
                object = new InsetsUIResource(0, 0, 0, 0);
            }
            this.menuItem.setMargin((Insets)object);
        }
        if ((object = UIManager.getString("MenuItem.acceleratorDelimiter")) == null) {
            object = "+";
        }
        this.acceleratorDelimiter = synthStyle.getString(synthContext, String.valueOf(string) + ".acceleratorDelimiter", (String)object);
        this.arrowIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon");
        this.checkIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SyntheticaMenuItemUI.getPreferredMenuItemSize(synthContext, synthContext2, true, jComponent, icon, icon2, n, this.acceleratorDelimiter);
        return dimension;
    }

    static Dimension getPreferredMenuItemSize(SynthContext synthContext, SynthContext synthContext2, boolean bl, JComponent jComponent, Icon icon, Icon icon2, int n, String string) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string2 = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string3 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string3 = KeyEvent.getKeyModifiersText(n3);
                string3 = String.valueOf(string3) + string;
            }
            string3 = (n2 = keyStroke.getKeyCode()) != 0 ? String.valueOf(string3) + KeyEvent.getKeyText(n2) : String.valueOf(string3) + keyStroke.getKeyChar();
        }
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(synthContext2.getStyle().getFont(synthContext2));
        SyntheticaMenuItemUI.resetRects();
        SyntheticaMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, string2, fontMetrics2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string2 == null ? 0 : n, n, bl);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(SyntheticaMenuItemUI.iconRect.x, SyntheticaMenuItemUI.iconRect.y, SyntheticaMenuItemUI.iconRect.width, SyntheticaMenuItemUI.iconRect.height, r);
        Container container = jMenuItem.getParent();
        if (container instanceof JPopupMenu) {
            object = maxWidths.get(container);
            if (object == null) {
                object = new MaxWidth();
                ((MaxWidth)object).maxTextWidth = SyntheticaMenuItemUI.r.width;
                ((MaxWidth)object).maxAcceleratorWidth = SyntheticaMenuItemUI.acceleratorRect.width;
                maxWidths.put(container, (MaxWidth)object);
            }
            SyntheticaMenuItemUI.r.width = ((MaxWidth)object).maxTextWidth = Math.max(((MaxWidth)object).maxTextWidth, SyntheticaMenuItemUI.r.width);
            ((MaxWidth)object).maxAcceleratorWidth = Math.max(((MaxWidth)object).maxAcceleratorWidth, SyntheticaMenuItemUI.acceleratorRect.width);
            SyntheticaMenuItemUI.r.width += ((MaxWidth)object).maxAcceleratorWidth;
        } else if (!(container == null || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.acceleratorRect.width;
        }
        if (bl) {
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.checkIconRect.width;
            SyntheticaMenuItemUI.r.width += n;
            SyntheticaMenuItemUI.r.width += n;
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.arrowIconRect.width;
        }
        SyntheticaMenuItemUI.r.width += 2 * n;
        object = synthContext.getStyle().getInsets(synthContext, null);
        if (object != null) {
            SyntheticaMenuItemUI.r.width += ((Insets)object).left + ((Insets)object).right;
            SyntheticaMenuItemUI.r.height += ((Insets)object).top + ((Insets)object).bottom;
        }
        if (SyntheticaMenuItemUI.r.width % 2 == 0) {
            ++SyntheticaMenuItemUI.r.width;
        }
        if (SyntheticaMenuItemUI.r.height % 2 == 0) {
            ++SyntheticaMenuItemUI.r.height;
        }
        return r.getSize();
    }

    private static String layoutMenuItem(SynthContext synthContext, FontMetrics fontMetrics, SynthContext synthContext2, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6, boolean bl) {
        int n7;
        Object object;
        JComponent jComponent = synthContext.getComponent();
        Container container = jComponent.getParent();
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        if ((jComponent instanceof JCheckBoxMenuItem || jComponent instanceof JRadioButtonMenuItem) && ((AbstractButton)(object = (JMenuItem)jComponent)).getIcon() == null) {
            rectangle.x = rectangle.x + (bl2 ? -n6 + 4 : n6 - 4);
        }
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, icon, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
        if (jComponent instanceof JCheckBoxMenuItem || jComponent instanceof JRadioButtonMenuItem) {
            rectangle3.x = rectangle3.x + (bl2 ? -n6 + 4 : n6 - 4);
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            object = synthContext2.getStyle();
            rectangle4.width = ((SynthStyle)object).getGraphicsUtils(synthContext2).computeStringWidth(synthContext2, fontMetrics2.getFont(), fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (bl) {
            if (icon2 != null) {
                rectangle5.width = SynthIcon.getIconWidth((Icon)icon2, (SynthContext)synthContext);
                rectangle5.height = SynthIcon.getIconHeight((Icon)icon2, (SynthContext)synthContext);
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = SynthIcon.getIconWidth((Icon)icon3, (SynthContext)synthContext);
                rectangle6.height = SynthIcon.getIconHeight((Icon)icon3, (SynthContext)synthContext);
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        object = rectangle2.union(rectangle3);
        int n8 = n7 = maxWidths.get(container) == null ? rectangle4.width : SyntheticaMenuItemUI.maxWidths.get((Object)container).maxAcceleratorWidth;
        if (bl2) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - n7;
            if (jComponent instanceof JRadioButtonMenuItem || jComponent instanceof JCheckBoxMenuItem) {
                rectangle4.x += n6 - 4;
            }
            if (bl) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - rectangle6.width - n6;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6 + n7 - rectangle4.width;
            if (jComponent instanceof JRadioButtonMenuItem || jComponent instanceof JCheckBoxMenuItem) {
                rectangle4.x += -n6 + 4;
            }
            if (bl) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle4.height / 2;
        if (bl) {
            rectangle6.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle6.height / 2;
            rectangle5.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        MenuPainter.getInstance(synthContext).paintMenuItemBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        MenuPainter.getInstance(synthContext).paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paint(this.getContext(jComponent), graphics);
    }

    private void paint(SynthContext synthContext, Graphics graphics) {
        JComponent jComponent = synthContext.getComponent();
        SynthStyle synthStyle = this.getStyle(jComponent);
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String string = this.getPropertyPrefix();
        SyntheticaMenuItemUI.paint(synthContext, synthContext2, graphics, synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon"), synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon"), true, this.acceleratorDelimiter, this.defaultTextIconGap);
    }

    static void paint(SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Icon icon, Icon icon2, boolean bl, String string, int n) {
        int n2;
        JComponent jComponent = synthContext.getComponent();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Insets insets = synthContext.getStyle().getInsets(synthContext, null);
        SyntheticaMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        SyntheticaMenuItemUI.viewRect.x += insets.left;
        SyntheticaMenuItemUI.viewRect.y += insets.top;
        SyntheticaMenuItemUI.viewRect.width -= insets.right + SyntheticaMenuItemUI.viewRect.x;
        SyntheticaMenuItemUI.viewRect.height -= insets.bottom + SyntheticaMenuItemUI.viewRect.y;
        SynthStyle synthStyle = synthContext.getStyle();
        Font font = synthStyle.getFont(synthContext);
        graphics.setFont(font);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        FontMetrics fontMetrics2 = SwingUtilities2.getFontMetrics(jComponent, graphics, synthContext2.getStyle().getFont(synthContext2));
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n3);
                string2 = String.valueOf(string2) + string;
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? String.valueOf(string2) + KeyEvent.getKeyText(n2) : String.valueOf(string2) + keyStroke.getKeyChar();
        }
        String string3 = SyntheticaMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, jMenuItem.getText(), fontMetrics2, string2, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n, bl);
        if (icon != null && bl) {
            SynthIcon.paintIcon((Icon)icon, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.checkIconRect.x, (int)SyntheticaMenuItemUI.checkIconRect.y, (int)SyntheticaMenuItemUI.checkIconRect.width, (int)SyntheticaMenuItemUI.checkIconRect.height);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                SynthIcon.paintIcon((Icon)icon3, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.iconRect.x, (int)SyntheticaMenuItemUI.iconRect.y, (int)SyntheticaMenuItemUI.iconRect.width, (int)SyntheticaMenuItemUI.iconRect.height);
            }
        }
        if (string3 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                graphics.setFont(synthStyle.getFont(synthContext));
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string3, SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.textRect.y, jMenuItem.getDisplayedMnemonicIndex());
            }
        }
        if (string2 != null && !string2.equals("")) {
            n2 = 0;
            SynthStyle synthStyle2 = synthContext2.getStyle();
            graphics.setColor(synthStyle2.getColor(synthContext2, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle2.getFont(synthContext2));
            synthStyle2.getGraphicsUtils(synthContext2).paintText(synthContext2, graphics, string2, SyntheticaMenuItemUI.acceleratorRect.x - n2, SyntheticaMenuItemUI.acceleratorRect.y, -1);
        }
        if (icon2 != null && bl) {
            SynthIcon.paintIcon((Icon)icon2, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.arrowIconRect.x, (int)SyntheticaMenuItemUI.arrowIconRect.y, (int)SyntheticaMenuItemUI.arrowIconRect.width, (int)SyntheticaMenuItemUI.arrowIconRect.height);
        }
    }

    private SynthStyle getStyle(JComponent jComponent) {
        return SynthLookAndFeel.getStyle(jComponent, this.getRegion(jComponent));
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return this.getContext(jComponent, this.getRegion(jComponent), n);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(jComponent, region);
        SynthContext synthContext = new SynthContext(jComponent, region, synthStyle, n);
        return synthContext;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        int n = 0;
        n = !jComponent.isEnabled() ? 8 : (this.menuItem.isArmed() ? 2 : (jComponent.isEnabled() ? (jComponent.isFocusOwner() ? 257 : 1) : 8));
        if (this.menuItem.isSelected()) {
            n |= 0x200;
        }
        return n;
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SyntheticaLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenuItem)propertyChangeEvent.getSource());
        }
    }

    private static class MaxWidth {
        int maxTextWidth;
        int maxAcceleratorWidth;

        private MaxWidth() {
        }
    }
}

