/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class CheckBoxStyle
extends StyleWrapper {
    private static CheckBoxStyle instance = new CheckBoxStyle();

    private CheckBoxStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (jComponent.getName() == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        CheckBoxStyle checkBoxStyle = new CheckBoxStyle();
        checkBoxStyle.setStyle(synthStyle);
        return checkBoxStyle;
    }

    public Icon getIcon(SynthContext synthContext, Object object) {
        BufferedImage bufferedImage;
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        if (abstractButton.getIcon() != null) {
            return null;
        }
        int n = synthContext.getComponentState();
        Boolean bl = (Boolean)abstractButton.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl2 = bl == null ? false : bl;
        Icon icon = null;
        if ((n & 4) > 0) {
            boolean bl3 = SyntheticaLookAndFeel.getBoolean("Synthetica.checkBox.emulatedPressedState.enabled", abstractButton);
            boolean bl4 = abstractButton.isSelected();
            if (bl3) {
                icon = SyntheticaLookAndFeel.loadIcon(bl4 ? "Synthetica.checkBox.selected.image" : "Synthetica.checkBox.image");
            }
            if (icon == null) {
                icon = this.synthStyle.getIcon(new SynthContext(abstractButton, synthContext.getRegion(), synthContext.getStyle(), bl4 ? 516 : 4), object);
            }
            if (bl3) {
                bufferedImage = (BufferedImage)GraphicsUtils.iconToImage(synthContext, icon);
                Color color = SyntheticaLookAndFeel.getColor("Synthetica.checkBox.emulatedPressedState.color", abstractButton, UIManager.getColor("Panel.background").darker());
                float f = (float)SyntheticaLookAndFeel.getInt("Synthetica.checkBox.emulatedPressedState.alpha", abstractButton, 25) / 100.0f;
                BufferedImage bufferedImage2 = Synthetica2DUtils.createColorizedImage(bufferedImage, color, f);
                icon = new ImageIcon(bufferedImage2);
            }
        } else {
            icon = (n & 0x200) > 0 && bl2 ? this.synthStyle.getIcon(new SynthContext(abstractButton, synthContext.getRegion(), synthContext.getStyle(), n | 2), object) : this.synthStyle.getIcon(synthContext, object);
        }
        if (abstractButton.getClientProperty("Synthetica.background") != null) {
            float f = abstractButton.getClientProperty("Synthetica.background.alpha") == null ? 0.1f : ((Float)abstractButton.getClientProperty("Synthetica.background.alpha")).floatValue();
            BufferedImage bufferedImage3 = (BufferedImage)GraphicsUtils.iconToImage(synthContext, icon);
            bufferedImage = Synthetica2DUtils.createColorizedImage(bufferedImage3, (Color)abstractButton.getClientProperty("Synthetica.background"), f);
            icon = new ImageIcon(bufferedImage);
        }
        return icon;
    }
}

