/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.EventQueue;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class MenuItemStyle
extends StyleWrapper {
    private static MenuItemStyle instance = new MenuItemStyle();

    private MenuItemStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        jComponent.setOpaque(false);
        if (jComponent.getName() == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        MenuItemStyle menuItemStyle = new MenuItemStyle();
        menuItemStyle.setStyle(synthStyle);
        return menuItemStyle;
    }

    public Font getFont(SynthContext synthContext) {
        MenuItemStyle.menuItemHtmlColorCorrection(synthContext);
        return this.synthStyle.getFont(synthContext);
    }

    public Icon getIcon(SynthContext synthContext, Object object) {
        JMenuItem jMenuItem = (JMenuItem)synthContext.getComponent();
        if ((jMenuItem instanceof JRadioButtonMenuItem || jMenuItem instanceof JCheckBoxMenuItem) && jMenuItem.isSelected() && !jMenuItem.isEnabled()) {
            SynthContext synthContext2 = new SynthContext(jMenuItem, synthContext.getRegion(), synthContext.getStyle(), 520);
            return this.synthStyle.getIcon(synthContext2, object);
        }
        return this.synthStyle.getIcon(synthContext, object);
    }

    public String getString(SynthContext synthContext, Object object, String string) {
        String string2;
        if ("MenuItem.acceleratorDelimiter".equals(object) && (string2 = UIManager.getString("MenuItem.acceleratorDelimiter")) != null) {
            return string2;
        }
        return super.getString(synthContext, object, string);
    }

    static void menuItemHtmlColorCorrection(SynthContext synthContext) {
        Object object;
        boolean bl;
        JMenuItem jMenuItem = (JMenuItem)synthContext.getComponent();
        String string = jMenuItem.getText();
        if (string == null || jMenuItem.getClientProperty("html") == null) {
            return;
        }
        SynthStyle synthStyle = synthContext.getStyle();
        int n = synthContext.getComponentState();
        boolean bl2 = jMenuItem instanceof JMenu ? (n & 0x200) > 0 : (n & 2) > 0;
        boolean bl3 = (n & 8) > 0;
        Boolean bl4 = (Boolean)jMenuItem.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl5 = bl4 == null ? false : bl4;
        boolean bl6 = bl = (n & 0x200) > 0;
        if (bl2 || bl3) {
            int n2 = string.toLowerCase().indexOf("<html>");
            String string2 = Integer.toHexString(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND).getRGB());
            object = "color=#" + string2.substring(2);
            String string3 = string.substring(n2, n2 + 6);
            string = string.replaceFirst(string3, "<html><font " + (String)object + ">");
        }
        if (!jMenuItem.getParent().isVisible()) {
            jMenuItem.putClientProperty("Synthetica.oldText", "");
            if (jMenuItem instanceof JMenu) {
                jMenuItem.putClientProperty("Synthetica.oldHover", Boolean.FALSE);
            }
        }
        String string4 = (String)jMenuItem.getClientProperty("Synthetica.oldText");
        jMenuItem.putClientProperty("Synthetica.oldText", string);
        boolean bl7 = false;
        if (jMenuItem instanceof JMenu) {
            bl7 = (Boolean)jMenuItem.getClientProperty("Synthetica.oldHover");
            jMenuItem.putClientProperty("Synthetica.oldHover", bl5);
        }
        object = (View)jMenuItem.getClientProperty("html");
        if (!string.equals(string4) && object != jMenuItem.getClientProperty("Synthetica.oldView") || jMenuItem instanceof JMenu && bl && !bl5 && bl7 != bl5) {
            jMenuItem.putClientProperty("Synthetica.oldView", object);
            MenuItemStyle.updateHTMLRenderer(jMenuItem);
        }
    }

    private static void updateHTMLRenderer(final JMenuItem jMenuItem) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BasicHTML.updateRenderer(jMenuItem, (String)jMenuItem.getClientProperty("Synthetica.oldText"));
            }
        });
    }
}

