/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountBalance;
import account.AccountLedger;
import database.DBConn;
import database.DBUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import system.Config;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;

public class AccountMonth {
    private int g_Ac_month_seq = -1;
    private int g_Ac_year_seq = -1;
    private Timestamp g_Start_date = null;
    private Timestamp g_End_date = null;
    private Timestamp g_Posting_date = null;

    public AccountMonth() {
    }

    public AccountMonth(int ac_month_seq) {
        this.g_Ac_month_seq = ac_month_seq;
        this.load();
    }

    public int getAc_month_seq() {
        return this.g_Ac_month_seq;
    }

    public int getAc_year_seq() {
        return this.g_Ac_year_seq;
    }

    public Timestamp getStart_date() {
        return this.g_Start_date;
    }

    public Timestamp getEnd_date() {
        return this.g_End_date;
    }

    public Timestamp getPosting_date() {
        return this.g_Posting_date;
    }

    public void setStart_date(Timestamp s) {
        this.g_Start_date = s;
    }

    public void setEnd_date(Timestamp s) {
        this.g_End_date = s;
    }

    private void load() {
        String sql = "select AC_YEAR_SEQ,START_DATE,END_DATE,POSTING_DATE from ac_month where AC_MONTH_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"AC_YEAR_SEQ", "START_DATE", "END_DATE", "POSTING_DATE"}, new int[]{4, 93, 93, 93}, new Object[]{new Integer(this.g_Ac_month_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Ac_year_seq = ArrayUtil.getInt("AC_YEAR_SEQ", 0, v);
            this.g_Start_date = ArrayUtil.getTimestamp("START_DATE", 0, v);
            this.g_End_date = ArrayUtil.getTimestamp("END_DATE", 0, v);
            this.g_Posting_date = ArrayUtil.getTimestamp("POSTING_DATE", 0, v);
        }
    }

    public static int insert(Timestamp start_date, Timestamp end_date) {
        String sql = "insert into ac_month( AC_MONTH_SEQ,AC_YEAR_SEQ,START_DATE,END_DATE,POSTING_DATE)values(?,?,?,?,?)";
        DBConn conn = new DBConn();
        int ac_month_seq = DBUtil.getNextValueFor("ac_month_seq", conn);
        Timestamp posting_date = TimeUtil.getCurrentTimestamp();
        DBUtil.update(new Object[]{new Integer(ac_month_seq), new Integer(-1), start_date, end_date, posting_date}, new int[]{4, 4, 93, 93, 93}, sql, conn);
        AccountMonth.post(ac_month_seq, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_month_seq : -1;
    }

    public static int update(int ac_month_seq) {
        String sql = "update ac_month set POSTING_DATE=? where AC_MONTH_SEQ=?";
        DBConn conn = new DBConn();
        Timestamp posting_date = TimeUtil.getCurrentTimestamp();
        DBUtil.update(new Object[]{posting_date, new Integer(ac_month_seq)}, new int[]{93, 4}, sql, conn);
        AccountMonth.post(ac_month_seq, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_month_seq : -1;
    }

    private static void post(int ac_month_seq, DBConn conn) {
        ArrayList v = AccountMonth.getMonthInfo(ac_month_seq, conn);
        Timestamp start_date = ArrayUtil.getTimestamp("START_DATE", 0, v);
        Timestamp end_date = ArrayUtil.getTimestamp("END_DATE", 0, v);
        AccountLedger.update(ac_month_seq, start_date, end_date, conn);
        AccountBalance.update(ac_month_seq, start_date, end_date, conn);
    }

    public static void postAcYearSeq(int ac_year_seq, Timestamp start_date1, Timestamp start_date2, DBConn conn) {
        String sql = "update ac_month set ac_year_seq=? where start_date>=? and start_date<=?";
        DBUtil.update(new Object[]{new Integer(ac_year_seq), start_date1, start_date2}, new int[]{4, 93, 93}, sql, conn);
    }

    public static void unpostAcYearSeq(int ac_year_seq, DBConn conn) {
        String sql = "update ac_month set ac_year_seq=-1 where ac_year_seq=?";
        DBUtil.update(new Object[]{new Integer(ac_year_seq)}, new int[]{4}, sql, conn);
    }

    public static RecordList search() {
        String sql = "select acm.ac_month_seq as ac_month_seq,acm.start_date as start_date,acm.end_date as end_date,acm.posting_date as posting_date,acy.name as year_name,acy.lock as lock from ac_month acm left join ac_year acy on acm.ac_year_seq=acy.ac_year_seq order by acm.start_date";
        RecordList r = DBUtil.run("select acm.ac_month_seq as ac_month_seq,acm.start_date as start_date,acm.end_date as end_date,acm.posting_date as posting_date,acy.name as year_name,acy.lock as lock from ac_month acm left join ac_year acy on acm.ac_year_seq=acy.ac_year_seq order by acm.start_date");
        int i = 0;
        while (i < r.size()) {
            String lock = r.getS("lock", i);
            r.setS("lock", lock.equals("Y") ? "\u662f" : "", i);
            ++i;
        }
        return r;
    }

    public static Timestamp getNextMonthStartDate() {
        String sql = "select START_DATE from ac_month order by START_DATE desc";
        RecordList v = DBUtil.select(new String[]{"START_DATE"}, new int[]{93}, sql);
        if (v.isEmpty()) {
            return Config.getT(Config.startAcPeriod);
        }
        return TimeUtil.adjustMonth(ArrayUtil.getTimestamp("START_DATE", 0, v), 1);
    }

    private static ArrayList getMonthInfo(int ac_month_seq, DBConn conn) {
        String sql = "select START_DATE,END_DATE from ac_month where AC_MONTH_SEQ=?";
        return DBUtil.select(new String[]{"START_DATE", "END_DATE"}, new int[]{93, 93}, new Object[]{new Integer(ac_month_seq)}, new int[]{4}, sql, conn);
    }

    public static int getAc_month_seq(Timestamp start_date) {
        String sql = "select AC_MONTH_SEQ from ac_month where START_DATE=?";
        RecordList v = DBUtil.select(new String[]{"AC_MONTH_SEQ"}, new int[]{4}, new Object[]{start_date}, new int[]{93}, sql);
        return !v.isEmpty() ? ArrayUtil.getInt("AC_MONTH_SEQ", 0, v) : -1;
    }

    public static boolean isEmpty() {
        String sql = "select START_DATE from ac_month";
        RecordList r = DBUtil.run(sql);
        return r.isEmpty();
    }
}

