/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountBalance;
import account.AccountMonth;
import java.math.BigDecimal;
import java.util.ArrayList;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import util.Arith;
import util.ArrayListCreator;
import util.ArrayListSet;
import util.ArrayUtil;
import util.TimeUtil;

public class IncomeStatement {
    private ArrayList g_Accounts = null;
    private ExcelPrintout g_Printout = null;
    private ArrayList g_Bf_balances = null;
    private ArrayList g_Period_balances = null;
    private boolean g_Show_group_total = false;
    private boolean g_Show_zero_ac = false;
    private int g_Row = 0;
    private static final String INDENT = "  ";

    public IncomeStatement(int start_acm_seq, int end_acm_seq, boolean show_group_total, boolean show_zero_ac) {
        this.g_Show_group_total = show_group_total;
        this.g_Show_zero_ac = show_zero_ac;
        AccountMonth start_month = new AccountMonth(start_acm_seq);
        AccountMonth end_month = new AccountMonth(end_acm_seq);
        this.g_Accounts = Account.getAllAccounts();
        ArrayList ac_seqs = ArrayUtil.getCol(this.g_Accounts, "AC_SEQ");
        this.g_Bf_balances = AccountBalance.getBfBalances(TimeUtil.adjustDate(start_month.getStart_date(), -1), ac_seqs);
        this.g_Period_balances = AccountBalance.getPeriodBalances(start_month.getEnd_date(), end_month.getEnd_date(), ac_seqs);
        this.g_Printout = new ExcelPrintout(ExcelFormat.PA4, new int[]{90, 30, 30, 30});
        this.g_Printout.addHeader(Config.getS(Config.companyName), Lang.set("\u640d\u76ca\u8868"), new String[]{String.valueOf(Lang.set("\u6642\u671f: ")) + TimeUtil.getStringByDate(start_month.getStart_date()) + " - " + TimeUtil.getStringByDate(end_month.getEnd_date())});
        this.g_Row = this.g_Printout.getRowNumAfterHeader();
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u5e33\u6236"), this.g_Printout.TL);
        this.g_Printout.addCell(1, this.g_Row, String.valueOf(Lang.set("\u627f\u4e0a\u7d50\u9918(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(2, this.g_Row, String.valueOf(Lang.set("\u672c\u671f\u7d50\u9918(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(3, this.g_Row, String.valueOf(Lang.set("\u7d2f\u7a4d\u7d50\u9918(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        String r_type = "R";
        ArrayList r_type_acs = ArrayUtil.getGroupItems(this.g_Accounts, "TYPE", r_type);
        this.printTypeAccounts(this.getSign(r_type), r_type_acs);
        double r_bf_bal = this.getBalanceSum(this.getSign(r_type), r_type_acs, this.g_Bf_balances);
        double r_month_bal = this.getBalanceSum(this.getSign(r_type), r_type_acs, this.g_Period_balances);
        double r_all_bal = Arith.add(r_bf_bal, r_month_bal);
        ++this.g_Row;
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u7e3d\u6536\u5165:"), this.g_Printout.AR);
        this.g_Printout.addCell(1, this.g_Row, r_bf_bal, this.g_Printout.BTBD);
        this.g_Printout.addCell(2, this.g_Row, r_month_bal, this.g_Printout.BTBD);
        this.g_Printout.addCell(3, this.g_Row, r_all_bal, this.g_Printout.BTBD);
        String e_type = "E";
        ArrayList e_type_acs = ArrayUtil.getGroupItems(this.g_Accounts, "TYPE", e_type);
        this.printTypeAccounts(this.getSign(e_type), e_type_acs);
        double e_bf_bal = this.getBalanceSum(this.getSign(e_type), e_type_acs, this.g_Bf_balances);
        double e_month_bal = this.getBalanceSum(this.getSign(e_type), e_type_acs, this.g_Period_balances);
        double e_all_bal = Arith.add(e_bf_bal, e_month_bal);
        ++this.g_Row;
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u7e3d\u652f\u51fa:"), this.g_Printout.AR);
        this.g_Printout.addCell(1, this.g_Row, e_bf_bal, this.g_Printout.BTBD);
        this.g_Printout.addCell(2, this.g_Row, e_month_bal, this.g_Printout.BTBD);
        this.g_Printout.addCell(3, this.g_Row, e_all_bal, this.g_Printout.BTBD);
        this.g_Row += 2;
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u7e3d\u640d\u76ca:"), this.g_Printout.AR);
        this.g_Printout.addCell(1, this.g_Row, Arith.sub(r_bf_bal, e_bf_bal), this.g_Printout.BD);
        this.g_Printout.addCell(2, this.g_Row, Arith.sub(r_month_bal, e_month_bal), this.g_Printout.BD);
        this.g_Printout.addCell(3, this.g_Row, Arith.sub(r_all_bal, e_all_bal), this.g_Printout.BD);
        this.g_Printout.genPrintout();
    }

    private void printTypeAccounts(int sign, ArrayList type_acs) {
        ArrayList first_level_acs = ArrayUtil.getGroupItems(type_acs, "PARENT_AC_SEQ", new Integer(-1));
        ++this.g_Row;
        ArrayList self_totals = this.getNewEmptyTotals();
        this.printGroupAccounts(0, sign, first_level_acs, self_totals);
    }

    private void printGroupAccounts(int level, int sign, ArrayList group_acs, ArrayList parent_totals) {
        int i = 0;
        while (i < group_acs.size()) {
            int ac_seq = ArrayUtil.getInt("AC_SEQ", i, group_acs);
            String is_parent = ArrayUtil.getString("IS_PARENT", i, group_acs);
            String id = ArrayUtil.getString("ID", i, group_acs);
            String name = ArrayUtil.getString("NAME", i, group_acs);
            String id_name = String.valueOf(this.getIndent(level)) + id + " " + name;
            int row = ++this.g_Row;
            double bf_bal = 0.0;
            double month_bal = 0.0;
            if (is_parent.equals("N")) {
                int k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Bf_balances);
                bf_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Bf_balances) : 0.0;
                k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Period_balances);
                month_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Period_balances) : 0.0;
            } else {
                ArrayList next_level_acs = ArrayUtil.getGroupItems(this.g_Accounts, "PARENT_AC_SEQ", new Integer(ac_seq));
                ArrayList self_totals = this.getNewEmptyTotals();
                this.printGroupAccounts(level + 1, sign, next_level_acs, self_totals);
                bf_bal = ArrayUtil.getDouble("BF_BAL", 0, self_totals);
                month_bal = ArrayUtil.getDouble("MONTH_BAL", 0, self_totals);
            }
            if (bf_bal == 0.0 && month_bal == 0.0 && !this.g_Show_zero_ac) {
                --this.g_Row;
            } else {
                this.g_Printout.addCell(0, row, id_name);
                if (is_parent.equals("N") || this.g_Show_group_total) {
                    this.g_Printout.addCell(1, row, Arith.mul(bf_bal, sign));
                    this.g_Printout.addCell(2, row, Arith.mul(month_bal, sign));
                    this.g_Printout.addCell(3, row, Arith.mul(Arith.add(bf_bal, month_bal), sign));
                }
                ArrayUtil.addDouble("BF_BAL", bf_bal, 0, parent_totals);
                ArrayUtil.addDouble("MONTH_BAL", month_bal, 0, parent_totals);
            }
            ++i;
        }
    }

    private ArrayList getNewEmptyTotals() {
        ArrayListCreator creator = new ArrayListCreator(new String[]{"bf_bal", "month_bal"});
        creator.add(new Object[]{new BigDecimal(0), new BigDecimal(0)});
        return creator.getArrayList();
    }

    private double getBalanceSum(int sign, ArrayList type_acs, ArrayList balances) {
        ArrayListSet set = new ArrayListSet(type_acs, balances, new String[]{"AC_SEQ"});
        return Arith.mul(sign, ArrayUtil.getDoubleSum(set.getIntersectOfRight(), "BALANCE"));
    }

    private int getSign(String type) {
        if (type.equals("R")) {
            return -1;
        }
        if (type.equals("E")) {
            return 1;
        }
        return 0;
    }

    private String getIndent(int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < level) {
            b.append(INDENT);
            ++i;
        }
        return b.toString();
    }
}

