/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.VouTemplateItem;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import system.SystemCode;
import util.RecordList;
import util.Tools;

public class VouTemplate {
    private int g_Vou_template_seq = -1;
    private String g_Id = "";
    private String g_Status = "";
    public static String VOU_TEMPLATE_SEQ = "vou_template_seq";
    public static String ID = "id";
    public static String STATUS = "status";

    public VouTemplate() {
    }

    public VouTemplate(int vou_template_seq) {
        this.g_Vou_template_seq = vou_template_seq;
        this.load();
    }

    public int getVou_template_seq() {
        return this.g_Vou_template_seq;
    }

    public String getId() {
        return this.g_Id;
    }

    public String getStatus() {
        return this.g_Status;
    }

    private void load() {
        String sql = "select id,status from vou_template where vou_template_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Vou_template_seq);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Id = r.getS(ID);
            this.g_Status = r.getS(STATUS);
        }
    }

    public static int insert(String id, String status, RecordList items) {
        String sql = "insert into vou_template( vou_template_seq,id,status)values(?,?,?)";
        DBConn conn = new DBConn();
        int vou_template_seq = DBUtil.getNextValueFor("vou_template_seq", conn);
        DBUtil.run(sql, new Object[]{new Integer(vou_template_seq), id, status}, conn);
        VouTemplateItem.update(vou_template_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? vou_template_seq : -1;
    }

    public static int update(int vou_template_seq, String id, String status, RecordList items) {
        String sql = "update vou_template set id=?,status=? where vou_template_seq=?";
        DBConn conn = new DBConn();
        DBUtil.run(sql, new Object[]{id, status, new Integer(vou_template_seq)}, conn);
        VouTemplateItem.update(vou_template_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? vou_template_seq : -1;
    }

    public static boolean existID(String id, int vou_template_seq) {
        String sql = "select 'x' as TMP from vou_template where id=? and vou_template_seq<>?";
        RecordList r = DBUtil.run(sql, new Object[]{id, new Integer(vou_template_seq)});
        return !r.isEmpty();
    }

    public static RecordList search(String id, String ac_id) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(vt.id) like lower(?)", "lower(ac.id) like lower(?)"}, new Object[]{Tools.pad(id), Tools.pad(ac_id)});
        String sql = "select vt.vou_template_seq,vt.id,vt.status from vou_template vt,vou_template_item vti,ac_master ac where vt.vou_template_seq=vti.vou_template_seq and vti.ac_seq=ac.ac_seq" + clause.getConds() + " group by vt.vou_template_seq,vt.id,vt.status" + " order by vt.id" + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS(STATUS, SystemCode.getStatus(r.getS(STATUS)));
            ++i;
        }
        return r;
    }

    public static RecordList getActiveTemplate() {
        String sql = "select vou_template_seq,id from vou_template where status='" + SystemCode.STATUS__A + "'" + " order by id";
        return DBUtil.run(sql);
    }
}

