/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import member.MemberLabelPrintout;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.TableLayout;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class MemberLabelPrintoutDialog
extends DataDialog {
    private JButton printB;
    private JButton cancelB;
    private JRadioButton showHorizontalRB;
    private JRadioButton verticalRB;
    private Properties g_Config = null;
    private int g_Cellx = 0;
    private int g_Celly = 0;
    private int copy_Cell = 0;
    private JTextField rowTF;
    private JTextField columnTF;
    private JTextField copyTF;
    private JCheckBox showBorderCB;
    private JCheckBox showNameEngCB;
    private JCheckBox showBarcodeCB;
    private boolean g_Border = false;
    private ComboBoxCN sortingCN;
    private ArrayList sortingAL;
    private String[] cbcnCode;
    private String[] cbcnName;
    private ArrayList gMember_seqs;

    public MemberLabelPrintoutDialog(DataDialog f, ArrayList member_seqs) {
        super(f, "\u5217\u5370\u6703\u773e\u6a19\u7c64", false);
        this.gMember_seqs = member_seqs;
        this.setLayout();
        this.getConfigValue();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 250, 295, 5, 10);
        t.addTable(new int[]{40, 55, 45, 40, 20}, new int[]{30, 30, 30, 30, 30, 30, 30});
        this.columnTF = new JTextField("");
        this.rowTF = new JTextField("");
        JLabel jLabel = new JLabel("\u6392\u5217");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.columnTF, 1, 0, 20, 0, 30, -1);
        JLabel jLabel2 = new JLabel("\u76f4\u884c x");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.rowTF, 3, 0, -1, 0, 30, -1);
        JLabel jLabel3 = new JLabel("\u6a6b\u884c");
        t.getClass();
        t.addCell(jLabel3, 4, 0, -1, 0);
        this.sortingAL = new ArrayList();
        this.cbcnCode = new String[]{"member_id", "name_chi", "name_eng"};
        this.cbcnName = new String[]{"\u6703\u773e\u7de8\u865f", "\u4e2d\u6587\u59d3\u540d", "\u82f1\u6587\u59d3\u540d"};
        int i = 0;
        while (i < this.cbcnName.length) {
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("code", this.cbcnCode[i]);
            h.put("name", this.cbcnName[i]);
            h.put("default_item", "N");
            this.sortingAL.add(h);
            ++i;
        }
        this.sortingCN = new ComboBoxCN(this.sortingAL);
        this.sortingCN.hasNilItem(false);
        this.sortingCN.setItemSelected("member_id");
        JLabel jLabel4 = new JLabel("\u6392\u5e8f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.sortingCN, 1, 1, 20, 0);
        this.copyTF = new JTextField("");
        this.showBorderCB = new JCheckBox("\u542b\u908a\u6846", this.g_Border);
        this.showNameEngCB = new JCheckBox("\u542b\u82f1\u6587\u59d3\u540d", true);
        this.showBarcodeCB = new JCheckBox("\u542b\u6703\u773e\u7de8\u865f\u689d\u78bc", true);
        this.showHorizontalRB = new JRadioButton("\u6a6b\u5411\u5217\u5370");
        this.verticalRB = new JRadioButton("\u76f4\u5411\u5217\u5370");
        this.showHorizontalRB.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.showHorizontalRB);
        group.add(this.verticalRB);
        JLabel jLabel5 = new JLabel("\u4efd\u6578");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.copyTF, 1, 2, 20, 0, 30, -1);
        t.getClass();
        t.addCell(this.showBorderCB, 1, 3, 20, 0);
        t.getClass();
        t.addCell(this.showNameEngCB, 1, 4, 20, 0);
        t.getClass();
        t.addCell(this.showBarcodeCB, 1, 5, 20, 0);
        t.addCell(this.showHorizontalRB, 1, 6, 20, 0);
        t.addCell(this.verticalRB, 3, 6, 10, 0);
        t.addYSpace(10);
        t.addTable(new int[]{110, 20, 80}, new int[]{20});
        this.printB = new JButton("\u532f\u51fa\u6a19\u7c64");
        this.cancelB = new JButton("\u53d6\u6d88");
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberLabelPrintoutDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberLabelPrintoutDialog.this.onCancel(evt);
            }
        });
    }

    public void onPrint(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.rowTF.getText(), "\u6a6b\u884c", "R,I");
        validation.add(this.columnTF.getText(), "\u76f4\u884c", "R,I");
        validation.add(this.copyTF.getText(), "\u4efd\u6578", "R,I");
        if (!validation.isValid()) {
            return;
        }
        if (!(this.checkInputRange(this.rowTF.getText(), "\u6a6b\u884c") && this.checkInputRange(this.columnTF.getText(), "\u76f4\u884c") && this.checkInputRange(this.copyTF.getText(), "\u4efd\u6578"))) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        MemberLabelPrintout p = new MemberLabelPrintout("", "", this.gMember_seqs, this.columnTF.getText(), this.rowTF.getText(), this.copyTF.getText(), this.sortingCN.getSelectedCode(), this.showHorizontalRB.isSelected(), this.showBorderCB.isSelected(), this.showNameEngCB.isSelected(), this.showBarcodeCB.isSelected());
        p.genFile();
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }

    public boolean checkInputRange(String input, String name) {
        if (Integer.parseInt(input) < 1 || Integer.parseInt(input) > 101) {
            JOptionPane.showMessageDialog(null, String.valueOf(name) + " \u7684\u6578\u503c\u61c9\u5728 1-100 \u4e4b\u5167", "\u8cc7\u6599\u8f38\u5165\u932f\u8aa4", 1);
            return false;
        }
        return true;
    }

    public void getConfigValue() {
        this.g_Config = new Properties();
        try {
            this.g_Config.load(new FileInputStream("config/member_label_config.txt"));
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        this.g_Cellx = this.getIntFromConfig("h_cell_num");
        this.g_Celly = this.getIntFromConfig("v_cell_num");
        this.copy_Cell = this.getIntFromConfig("copy");
        this.g_Border = !this.getStringFromConfig("use_border").equals("N");
        this.columnTF.setText(Integer.toString(this.g_Cellx));
        this.rowTF.setText(Integer.toString(this.g_Celly));
        this.copyTF.setText(Integer.toString(this.copy_Cell));
    }

    private int getIntFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    private String getStringFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return value;
        }
        return "";
    }
}

