/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import system.Config;
import system.Constants;
import system.SystemUpdate;
import system.User;
import system.UserSession;
import ui.DataDialog;
import ui.TableLayout;
import util.Tools;
import util.WinUtil;

public class CheckUpdateDialog
extends DataDialog {
    private JCheckBox knownCB;
    private JButton visitWebB;
    private JButton closeB;
    private JFrame fr;
    private boolean gIsBackEnd;
    private String gLatestVersion;

    public CheckUpdateDialog(JFrame frame, boolean isBackEnd) {
        super(frame, "\u6aa2\u67e5\u66f4\u65b0", true);
        this.gIsBackEnd = isBackEnd;
        this.gLatestVersion = this.checkUpdate();
        this.fr = frame;
        this.setLayout();
        this.setEventHandler();
    }

    private void setLayout() {
        TableLayout t = new TableLayout(this, 320, 250, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30});
        this.knownCB = new JCheckBox("\u4e0d\u9700\u63d0\u793a\u9019\u7248\u672c\u7684\u66f4\u65b0", false);
        this.visitWebB = new JButton("\u9032\u5165\u5b98\u65b9\u7db2\u7ad9");
        this.closeB = new JButton("\u95dc\u9589");
        if (!SystemUpdate.isUpdate(Constants.VERSION, this.gLatestVersion)) {
            JLabel jLabel = new JLabel("\u8acb\u7559\u610f, \u7cfb\u7d71\u5df2\u6709\u65b0\u7248\u672c! \u53ef\u5230\u5b98\u65b9\u7db2\u7ad9\u4e0b\u8f09\u4f7f\u7528.");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, -1, 0);
        }
        JLabel jLabel = new JLabel("\u672c\u6a5f\u7248\u672c:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 1, 1, 0);
        JLabel jLabel2 = new JLabel(Constants.VERSION);
        t.getClass();
        t.addCell(jLabel2, 1, 1, 20, 0);
        JLabel jLabel3 = new JLabel("\u6700\u65b0\u7248\u672c:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        JLabel jLabel4 = new JLabel(this.gLatestVersion);
        t.getClass();
        t.addCell(jLabel4, 1, 2, 20, 0);
        JLabel jLabel5 = new JLabel("\u5b98\u65b9\u7db2\u7ad9:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 3, 1, 0);
        JLabel jLabel6 = new JLabel("http://acts.sourceforge.net");
        t.getClass();
        t.addCell(jLabel6, 1, 3, 20, 0);
        if (this.gIsBackEnd) {
            t.getClass();
            t.addCell(this.knownCB, 1, 4, 20, 0);
        }
        t.addYSpace(10);
        int[] nArray2 = new int[4];
        t.getClass();
        nArray2[0] = 0;
        nArray2[1] = 15;
        nArray2[2] = 60;
        nArray2[3] = 10;
        t.addTable(nArray2, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.visitWebB, 0, 0, 1, 0, 100, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.closeB, 2, 0, -1, 0, 60, -1);
    }

    private void setEventHandler() {
        this.visitWebB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckUpdateDialog.this.onVisitWeb(evt);
            }
        });
        this.closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckUpdateDialog.this.onClose(evt);
            }
        });
    }

    private void onVisitWeb(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("cmd /c start http://acts.sourceforge.net");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        this.dispose();
    }

    private void onClose(ActionEvent evt) {
        if (this.knownCB.isSelected()) {
            User.setKnownVersion(this.gLatestVersion, UserSession.getLoginUserSeq());
        }
        this.dispose();
    }

    public void setShow() {
        User user = new User(UserSession.getLoginUserSeq());
        if (!this.gIsBackEnd || !SystemUpdate.isUpdate(user.getKnown_version(), this.gLatestVersion)) {
            WinUtil.getWaitingDialog(null, "\u6aa2\u67e5\u66f4\u65b0\u4e2d...", 0.7);
            this.setVisible(true);
        }
    }

    private String checkUpdate() {
        try {
            URL url = new URL("http://acts.sourceforge.net/checkupdate.php?uid=" + Config.getS(Config.uid) + "&v=" + Constants.VERSION);
            URLConnection c = url.openConnection();
            c.setReadTimeout(5000);
            BufferedReader rd = new BufferedReader(new InputStreamReader(c.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            rd.close();
            return sb.toString();
        }
        catch (Exception e) {
            Tools.writeError(String.valueOf(e.toString()) + " [Cannot connect]");
            return Constants.VERSION;
        }
    }
}

