/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.Member;
import member.MemberGroup;
import member.MemberGroupMember;
import system.SystemCode;
import system.User;
import system.UserListDialog;
import system.UserPrivilege;
import system.UserPrivilegeBase;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.RecordList;
import util.Validation;
import util.WinUtil;

public class UserInfoDialog
extends DataDialog {
    private AutoComboBoxNV memberNV;
    private ComboBoxCN statusCN;
    private JTextField passwordTF;
    private ScrollList itemSL;
    private RecordList gItems;
    JButton saveB;
    JButton cancelB;
    private boolean gIsModify;
    private User gUser;
    private TableObj gTableObj;
    private RecordList gUPBases;

    public UserInfoDialog(DataDialog f, int user_seq, boolean isModify) {
        super(f, "\u4fee\u6539\u4f7f\u7528\u8005", false);
        if (!isModify) {
            this.setTitle("\u65b0\u589e\u4f7f\u7528\u8005");
        }
        this.gUser = new User(user_seq);
        UserPrivilege usp = new UserPrivilege(user_seq);
        this.gItems = usp.getItems();
        this.gUPBases = UserPrivilegeBase.getAllPrivileges();
        this.gIsModify = isModify;
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.passwordTF = new JTextField("");
        this.statusCN = new ComboBoxCN(SystemCode.getStatus(), this.gUser.getStatus());
        this.statusCN.hasNilItem(false);
        Member m = new Member(this.gUser.getMember_seq());
        this.memberNV = new AutoComboBoxNV((ArrayList)MemberGroupMember.getActiveMembersInGroup(MemberGroup.ROOT_GROUP_SEQ, -1), "list_item", "member_seq", this.gUser.getMember_seq());
        if (this.gIsModify) {
            this.memberNV.setEnabled(false);
        } else {
            this.statusCN.setSelectedCode(SystemCode.STATUS__A);
        }
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.saveB.setEnabled(User.hasPrivilege("userModify"));
        if (this.gUser.getUser_seq() == User.ADMIN_USER_SEQ) {
            this.saveB.setEnabled(false);
        }
        TableLayout t = new TableLayout(this, 700, 590, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 350;
        nArray[2] = 100;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30});
        JLabel jLabel = new JLabel("\u59d3\u540d(\u4e2d)");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.memberNV, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, 0, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 3, 0, 20, 0);
        JLabel jLabel3 = new JLabel("\u5bc6\u78bc");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.passwordTF, 1, 1, 20, 0, 250, -1);
        String[] names = new String[this.gUPBases.size() + 1];
        String[] keys = new String[this.gUPBases.size() + 1];
        int[] colSizes = new int[this.gUPBases.size() + 1];
        boolean[] colEditables = new boolean[this.gUPBases.size() + 1];
        names[0] = "\u6703\u773e\u7fa4\u7d44";
        keys[0] = "member_group_name";
        colSizes[0] = 150;
        colEditables[0] = false;
        int i = 0;
        while (i < this.gUPBases.size()) {
            this.gUPBases.setCurrentRow(i);
            String hasMG = this.gUPBases.getS("has_member_group");
            names[i + 1] = this.verticalize(String.valueOf(this.gUPBases.getS("name")) + (hasMG.equals("Y") ? "#" : ""));
            keys[i + 1] = this.gUPBases.getS("privilege");
            colSizes[i + 1] = 20;
            colEditables[i + 1] = true;
            ++i;
        }
        this.gTableObj = new TableObj(this.gItems);
        this.itemSL = new ScrollList(660, 395, this.gTableObj.getTableList(), colSizes, names, keys, colEditables);
        this.itemSL.setHorizontalScroll();
        i = 0;
        while (i < this.gUPBases.size()) {
            this.itemSL.setCheckBoxYNColumn(keys[i + 1], "Y", "N");
            ++i;
        }
        t.addYSpace(15);
        t.addTable(new int[]{570}, new int[]{415});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[3];
        nArray2[0] = 550;
        nArray2[1] = 65;
        t.getClass();
        nArray2[2] = 0;
        t.addTable(nArray2, new int[]{30});
        JLabel jLabel4 = new JLabel("# \u9019\u4e9b\u6b0a\u9650\u53ef\u4ee5\u9078\u64c7\u500b\u5225\u7684\u6703\u773e\u7fa4\u7d44");
        t.getClass();
        t.addCell(jLabel4, 0, 0, 10, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private String verticalize(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            sb.append(s.charAt(i));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public void setEventHandler() {
        this.memberNV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInfoDialog.this.onChangeMember(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onChangeMember(ActionEvent evt) {
        int member_seq = this.memberNV.getSelectedIntValue();
        Member m = new Member(member_seq);
        if (m.getPassword().equals("")) {
            this.passwordTF.setText("");
            this.passwordTF.setEnabled(true);
        } else {
            this.passwordTF.setText("\u6b64\u6703\u773e\u5df2\u5728\u6703\u773e\u8cc7\u6599\u5167\u8a2d\u5b9a\u500b\u4eba\u5bc6\u78bc");
            this.passwordTF.setEnabled(false);
        }
    }

    public void onSave(ActionEvent evt) {
        int member_seq = this.memberNV.getSelectedIntValue();
        RecordList privileges = this.gTableObj.getSelectedData();
        Validation validation = new Validation();
        if (!this.gIsModify) {
            validation.add(!User.exist(member_seq), "\u6b64\u6703\u773e\u5df2\u662f\u4f7f\u7528\u8005,\u8acb\u9078\u53e6\u4e00\u4f4d\u6703\u773e", "RT");
        }
        int i = 0;
        while (i < this.gUPBases.size()) {
            RecordList items;
            this.gUPBases.setCurrentRow(i);
            if (this.gUPBases.getS("has_member_group").equals("N") && (items = privileges.getGroupItems(UserPrivilege.PRIVILEGE, this.gUPBases.getS("privilege"))).size() != 0) {
                validation.add(items.size() == 1 && items.getI(UserPrivilege.MEMBER_GROUP_SEQ, 0) == MemberGroup.ROOT_GROUP_SEQ, "[" + this.gUPBases.getS("name") + "] \u53ea\u53ef\u9078\u64c7\u6700\u9802\u5c64\u7684\u6703\u773e\u7fa4\u7d44", "RT");
            }
            ++i;
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.gIsModify) {
            User.update(this.gUser.getUser_seq(), this.gUser.getMember_seq(), this.statusCN.getSelectedCode(), this.passwordTF.isEnabled() ? this.passwordTF.getText() : "", this.gTableObj.getSelectedData());
        } else {
            User.insert(this.memberNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.passwordTF.isEnabled() ? this.passwordTF.getText() : "", this.gTableObj.getSelectedData());
        }
        ((UserListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }

    private class RowObj {
        private int gMgSeq;
        private Object[] gData;

        RowObj(int mg_seq) {
            this.gData = new Object[UserInfoDialog.this.gUPBases.size() + 2];
            this.gMgSeq = mg_seq;
            int i = 0;
            while (i < UserInfoDialog.this.gUPBases.size()) {
                this.gData[i] = UserInfoDialog.this.gItems.indexOf(new String[]{UserPrivilege.MEMBER_GROUP_SEQ, UserPrivilege.PRIVILEGE}, new Object[]{new Integer(mg_seq), UserInfoDialog.this.gUPBases.getS("privilege", i)}) != -1 ? "Y" : "R";
                ++i;
            }
            this.gData[((UserInfoDialog)UserInfoDialog.this).gUPBases.size()] = new Integer(mg_seq);
            this.gData[((UserInfoDialog)UserInfoDialog.this).gUPBases.size() + 1] = MemberGroup.getName(mg_seq);
        }

        public int getMgSeq() {
            return this.gMgSeq;
        }

        public Object[] getArray() {
            return this.gData;
        }
    }

    private class TableObj {
        private RowObj[] gRows;
        private RecordList gTableList;

        TableObj(RecordList privileges) {
            RecordList allMemberGroups = MemberGroup.getAllActiveGroups();
            this.gRows = new RowObj[allMemberGroups.size()];
            int i = 0;
            while (i < allMemberGroups.size()) {
                int mg_seq = allMemberGroups.getI(UserPrivilege.MEMBER_GROUP_SEQ, i);
                this.gRows[i] = new RowObj(mg_seq);
                ++i;
            }
            String[] colKeys = new String[UserInfoDialog.this.gUPBases.size() + 2];
            int i2 = 0;
            while (i2 < UserInfoDialog.this.gUPBases.size()) {
                colKeys[i2] = UserInfoDialog.this.gUPBases.getS("privilege", i2);
                ++i2;
            }
            colKeys[((UserInfoDialog)UserInfoDialog.this).gUPBases.size()] = UserPrivilege.MEMBER_GROUP_SEQ;
            colKeys[((UserInfoDialog)UserInfoDialog.this).gUPBases.size() + 1] = "member_group_name";
            this.gTableList = new RecordList(colKeys);
            i2 = 0;
            while (i2 < this.gRows.length) {
                this.gTableList.addItem(this.gRows[i2].getArray());
                ++i2;
            }
        }

        public RecordList getTableList() {
            return this.gTableList;
        }

        public RecordList getSelectedData() {
            RecordList r = new RecordList(new String[]{UserPrivilege.USER_PRIVILEGE_SEQ, UserPrivilege.USER_SEQ, UserPrivilege.MEMBER_GROUP_SEQ, UserPrivilege.PRIVILEGE});
            int i = 0;
            while (i < this.gTableList.size()) {
                this.gTableList.setCurrentRow(i);
                int j = 0;
                while (j < UserInfoDialog.this.gUPBases.size()) {
                    if (this.gTableList.getS(UserInfoDialog.this.gUPBases.getS("privilege", j)).equals("Y")) {
                        r.addItem(new Object[]{new Integer(-1), new Integer(UserInfoDialog.this.gUser.getUser_seq()), this.gTableList.getInteger(UserPrivilege.MEMBER_GROUP_SEQ), UserInfoDialog.this.gUPBases.getS("privilege", j)});
                    }
                    ++j;
                }
                ++i;
            }
            return r;
        }
    }
}

