/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import ui.DataDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.Arith;
import util.ComparableHashMap;
import util.Tools;

public class RecordList
extends ArrayList
implements Serializable {
    private String[] gNames;
    private int gCurRow;

    public RecordList() {
        this(new String[0]);
    }

    public RecordList(String[] names) {
        this.gNames = names;
        this.gCurRow = -1;
    }

    public void addItem(Object[] item) {
        if (this.gNames.length != item.length) {
            Tools.writeException("Field not match");
            return;
        }
        ComparableHashMap h = new ComparableHashMap();
        int i = 0;
        while (i < this.gNames.length) {
            h.put(this.gNames[i], item[i]);
            ++i;
        }
        this.add(h);
    }

    public int getCurrentRow() {
        return this.gCurRow;
    }

    public void setCurrentRow(int i) {
        this.gCurRow = i;
    }

    public Object getObj(String colName, int row) {
        if (row == -1 || row >= this.size()) {
            Tools.writeException("row=" + row + " which is not in the list size " + this.size());
            return null;
        }
        ComparableHashMap h = (ComparableHashMap)this.get(row);
        if (!h.containsKey(colName)) {
            Tools.writeException("column " + colName + " not found");
        }
        return h.get(colName);
    }

    public boolean hasObj(String colName, int row) {
        if (row == -1 || row >= this.size()) {
            Tools.writeException("row=" + row + " which is not in the list size " + this.size());
            return false;
        }
        ComparableHashMap h = (ComparableHashMap)this.get(row);
        return h.containsKey(colName);
    }

    public int getI(String colName, int row) {
        Integer result = (Integer)this.getObj(colName, row);
        return result == null ? -1 : result;
    }

    public Integer getInteger(String colName, int row) {
        Integer result = (Integer)this.getObj(colName, row);
        return result;
    }

    public double getD(String colName, int row) {
        BigDecimal result = (BigDecimal)this.getObj(colName, row);
        return result == null ? -1.0 : result.doubleValue();
    }

    public BigDecimal getBigDecimal(String colName, int row) {
        BigDecimal result = (BigDecimal)this.getObj(colName, row);
        return result;
    }

    public String getS(String colName, int row) {
        String result = (String)this.getObj(colName, row);
        return result == null ? "" : result;
    }

    public Timestamp getT(String colName, int row) {
        Timestamp result = (Timestamp)this.getObj(colName, row);
        return result;
    }

    public Object getObj(String colName) {
        return this.getObj(colName, this.gCurRow);
    }

    public int getI(String colName) {
        return this.getI(colName, this.gCurRow);
    }

    public int getInteger(String colName) {
        return this.getInteger(colName, this.gCurRow);
    }

    public double getD(String colName) {
        return this.getD(colName, this.gCurRow);
    }

    public BigDecimal getBigDecimal(String colName) {
        return this.getBigDecimal(colName, this.gCurRow);
    }

    public String getS(String colName) {
        return this.getS(colName, this.gCurRow);
    }

    public Timestamp getT(String colName) {
        return this.getT(colName, this.gCurRow);
    }

    public void setObj(String colName, Object value, int row) {
        this.getComparableHashMapForSet(row).put(colName, value);
    }

    public void setI(String colName, int value, int row) {
        this.getComparableHashMapForSet(row).put(colName, new Integer(value));
    }

    public void setD(String colName, double value, int row) {
        this.getComparableHashMapForSet(row).put(colName, new BigDecimal(value));
    }

    public void setS(String colName, String value, int row) {
        this.getComparableHashMapForSet(row).put(colName, value);
    }

    public void setT(String colName, Timestamp value, int row) {
        this.getComparableHashMapForSet(row).put(colName, value);
    }

    public void setObj(String colName, Object value) {
        this.setObj(colName, value, this.gCurRow);
    }

    public void setI(String colName, int value) {
        this.setI(colName, value, this.gCurRow);
    }

    public void setD(String colName, double value) {
        this.setD(colName, value, this.gCurRow);
    }

    public void setS(String colName, String value) {
        this.setS(colName, value, this.gCurRow);
    }

    public void setT(String colName, Timestamp value) {
        this.setT(colName, value, this.gCurRow);
    }

    private ComparableHashMap getComparableHashMapForSet(int row) {
        ComparableHashMap h;
        if (row >= this.size()) {
            h = new ComparableHashMap();
            this.add(h);
        } else {
            h = (ComparableHashMap)this.get(row);
        }
        return h;
    }

    public void addI(String colName, int value, int row) {
        int a = this.getI(colName, row);
        this.setI(colName, a + value, row);
    }

    public void addD(String colName, double value, int row) {
        double a = this.getD(colName, row);
        this.setD(colName, Arith.add(a, value), row);
    }

    public int indexOf(String colName, Object value) {
        return this.indexOf(new String[]{colName}, new Object[]{value});
    }

    public int indexOf(String[] colNames, Object[] values) {
        int i = 0;
        while (i < this.size()) {
            boolean eq = false;
            int j = 0;
            while (j < colNames.length) {
                Object obj = this.getObj(colNames[j], i);
                if (!obj.equals(values[j])) break;
                if (j == colNames.length - 1) {
                    eq = true;
                }
                ++j;
            }
            if (eq) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double getColumnSum(String colName) {
        double sum = 0.0;
        int i = 0;
        while (i < this.size()) {
            sum = Arith.add(sum, this.getD(colName, i));
            ++i;
        }
        return sum;
    }

    public int getIntColumnSum(String colName) {
        int sum = 0;
        int i = 0;
        while (i < this.size()) {
            sum += this.getI(colName, i);
            ++i;
        }
        return sum;
    }

    public ArrayList getCol(String colName) {
        ArrayList<Object> v = new ArrayList<Object>();
        int i = 0;
        while (i < this.size()) {
            v.add(this.getObj(colName, i));
            ++i;
        }
        return v;
    }

    public RecordList getGroupItems(String colName, int value) {
        return this.getGroupItems(new String[]{colName}, new Integer[]{value});
    }

    public RecordList getGroupItems(String colName, Object value) {
        return this.getGroupItems(new String[]{colName}, new Object[]{value});
    }

    public RecordList getGroupItems(String[] colNames, Object[] values) {
        ComparableHashMap h = new ComparableHashMap();
        RecordList r = new RecordList();
        int i = 0;
        while (i < colNames.length) {
            h.put(colNames[i], values[i]);
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            ComparableHashMap h2 = (ComparableHashMap)this.get(i);
            if (this.compareHashMap(h, h2, colNames) == 0) {
                r.add(h2);
            }
            ++i;
        }
        return r;
    }

    private int compareHashMap(ComparableHashMap h1, ComparableHashMap h2, String[] colNames) {
        int result = 0;
        int i = 0;
        Object obj1 = null;
        Object obj2 = null;
        while (result == 0 && i < colNames.length) {
            obj1 = h1.get(colNames[i]);
            obj2 = h2.get(colNames[i]);
            if (obj1 == null) {
                Tools.writeException("column " + colNames[i] + " is not found");
                return 1;
            }
            if (obj2 == null) {
                Tools.writeException("column " + colNames[i] + " is not found");
                return 1;
            }
            if (obj1 instanceof Integer) {
                result = ((Integer)obj1).compareTo((Integer)obj2);
            } else if (obj1 instanceof BigDecimal) {
                result = ((BigDecimal)obj1).compareTo((BigDecimal)obj2);
            } else if (obj1 instanceof String) {
                result = ((String)obj1).compareTo((String)obj2);
            } else if (obj1 instanceof Timestamp) {
                result = ((Timestamp)obj1).compareTo((Timestamp)obj2);
            }
            ++i;
        }
        return result;
    }

    public RecordList copy() {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        RecordList r1 = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            r1 = (RecordList)ois.readObject();
            oos.close();
            ois.close();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return r1;
    }

    public void replaceColValue(String col, Object origValue, Object newValue) {
        int i = 0;
        while (i < this.size()) {
            this.setCurrentRow(i);
            if (this.getObj(col).equals(origValue)) {
                this.setObj(col, newValue);
            }
            ++i;
        }
    }

    public void sort(String criteria) {
        StringTokenizer st = new StringTokenizer(criteria, ",");
        int count = st.countTokens();
        String[][] criteria_array = new String[count][2];
        int i = 0;
        while (i < count) {
            criteria_array[i] = st.nextToken().split(" ");
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            ((ComparableHashMap)this.get(i)).setCriteria(criteria_array);
            ++i;
        }
        Collections.sort(this);
    }

    public RecordList uniq(String[] cols) {
        RecordList r = this.copy();
        int i = 1;
        while (i < r.size()) {
            if (this.compareHashMap((ComparableHashMap)r.get(i - 1), (ComparableHashMap)r.get(i), cols) == 0) {
                r.remove(i);
                continue;
            }
            ++i;
        }
        return r;
    }

    public int getColNonUniqueIndex(String[] cols) {
        RecordList r = (RecordList)this.clone();
        int i = 0;
        while (i < r.size()) {
            r.setI("__OrigIndex", i, i);
            ++i;
        }
        String criteria = "";
        int i2 = 0;
        while (i2 < cols.length) {
            criteria = String.valueOf(criteria) + "," + cols[i2];
            ++i2;
        }
        r.sort(criteria.substring(1, criteria.length()));
        i2 = 1;
        while (i2 < r.size()) {
            if (this.compareHashMap((ComparableHashMap)r.get(i2 - 1), (ComparableHashMap)r.get(i2), cols) == 0) {
                return r.getI("__OrigIndex", i2 - 1);
            }
            ++i2;
        }
        return -1;
    }

    public int getColNonIdenticalIndex(String[] cols) {
        RecordList r = (RecordList)this.clone();
        int i = 0;
        while (i < r.size()) {
            r.setI("__OrigIndex", i);
            ++i;
        }
        String criteria = "";
        int i2 = 0;
        while (i2 < cols.length) {
            criteria = String.valueOf(criteria) + "," + cols[i2];
            ++i2;
        }
        r.sort(criteria.substring(1, criteria.length()));
        for (i2 = 1; i2 < r.size(); ++i2) {
            if (this.compareHashMap((ComparableHashMap)r.get(i2 - 1), (ComparableHashMap)r.get(i2), cols) == 0) {
                continue;
            }
            return r.getI("__OrigIndex", i2 - 1);
        }
        return -1;
    }

    public void appendRecordList(RecordList r) {
        int i = 0;
        while (i < r.size()) {
            this.add(r.get(i));
            ++i;
        }
    }

    public void showOutput(String title) {
        JComponent c = null;
        if (this.isEmpty()) {
            c = new JLabel("No data");
        } else {
            HashMap h = (HashMap)this.get(0);
            int[] widths = new int[h.size()];
            boolean[] editables = new boolean[h.size()];
            int i = 0;
            while (i < h.size()) {
                widths[i] = 100;
                editables[i] = false;
                ++i;
            }
            Object[] keys = h.keySet().toArray(new String[h.size()]);
            Arrays.sort(keys);
            ScrollList s = new ScrollList(700, 500, this, widths, (String[])keys, (String[])keys, editables);
            c = s;
        }
        DataDialog dialog = new DataDialog(new JFrame(), title, false);
        TableLayout t = new TableLayout(dialog, 730, 540, 0, 0);
        int[] nArray = new int[1];
        t.getClass();
        nArray[0] = 0;
        t.addTable(nArray, new int[]{500});
        t.getClass();
        t.getClass();
        t.addCell(c, 0, 0, -1, -1);
        dialog.setVisible(true);
    }
}

