/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import snaq.db.ConnectionPoolManager;

public class SQLUpdate {
    private ConnectionPoolManager cpm;
    private Connection con;
    private Statement statement;
    private String dbName;
    private ByteArrayOutputStream logBuffer;
    private PrintWriter log;

    public SQLUpdate(String string) throws IOException {
        this.dbName = string;
        this.cpm = ConnectionPoolManager.getInstance();
    }

    private void openConnection(String string) throws SQLException {
        if (string == null || string.equals("")) {
            System.out.println("Please specify a database name");
            System.exit(1);
        }
        this.con = this.cpm.getConnection(string);
        try {
            this.statement = this.con.createStatement();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.logBuffer = new ByteArrayOutputStream();
        this.log = new PrintWriter(this.logBuffer);
    }

    private void closeConnection() {
        try {
            this.statement.close();
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.log.flush();
        this.log.close();
        if (this.logBuffer.size() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("SQLUpdate.log", true);
                fileOutputStream.write(this.logBuffer.toByteArray());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cpm.release();
    }

    private void doStatement(String string) {
        int n = 0;
        try {
            n = this.statement.executeUpdate(string);
            System.out.print(".");
        }
        catch (SQLException sQLException) {
            System.out.print("x");
            this.log.println();
            this.log.println(string);
            this.log.println(sQLException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Usage: java snaq.db.SQLUpdate <database> <text file> [<separator>]");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length < 3 ? null : stringArray[2];
        String string4 = null;
        try {
            int n;
            object3 = new ByteArrayOutputStream();
            object2 = new FileInputStream(string2);
            object = new byte[4096];
            while ((n = ((FileInputStream)object2).read((byte[])object)) != -1) {
                ((ByteArrayOutputStream)object3).write((byte[])object, 0, n);
            }
            ((FileInputStream)object2).close();
            string4 = new String(((ByteArrayOutputStream)object3).toByteArray());
        }
        catch (IOException iOException) {
            System.out.println("I/O error with file " + string2);
            System.exit(1);
        }
        object3 = null;
        try {
            object3 = new SQLUpdate(string);
        }
        catch (IOException iOException) {
            System.err.println("Unable to create instance of SQLUpdate");
            iOException.printStackTrace();
            System.exit(1);
        }
        super.openConnection(string);
        if (string3 == null) {
            object2 = new StringTokenizer(string4, "\n\r");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
                if (((String)object).startsWith("#") || ((String)object).equals("")) continue;
                super.doStatement((String)object);
            }
        } else {
            System.out.println("Separator: " + string3);
            object2 = new StringBuffer();
            object = new StringTokenizer(string4, "\n\r");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string5 = ((StringTokenizer)object).nextToken();
                if (string5.startsWith("#") || string5.startsWith("--")) {
                    ((StringBuffer)object2).setLength(0);
                    continue;
                }
                int n = string5.indexOf(string3);
                if (n >= 0) {
                    ((StringBuffer)object2).append(string5.substring(0, n));
                    super.doStatement(((StringBuffer)object2).toString());
                    ((StringBuffer)object2).setLength(0);
                    continue;
                }
                ((StringBuffer)object2).append(string5);
            }
        }
        super.closeConnection();
        System.out.println();
    }
}

